/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indexmapping;

import cc.redberry.core.indexmapping.IndexMappingBuffer;
import cc.redberry.core.indexmapping.IndexMappingBufferImpl;
import cc.redberry.core.indexmapping.IndexMappingBufferTester;
import cc.redberry.core.indexmapping.IndexMappingProvider;
import cc.redberry.core.indexmapping.IndexMappingProviderFactory;
import cc.redberry.core.indexmapping.Mapping;
import cc.redberry.core.indexmapping.MappingsPort;
import cc.redberry.core.indexmapping.MappingsPortRemovingContracted;
import cc.redberry.core.indexmapping.MinusIndexMappingProviderWrapper;
import cc.redberry.core.indexmapping.ProviderComplex;
import cc.redberry.core.indexmapping.ProviderFunctions;
import cc.redberry.core.indexmapping.ProviderPower;
import cc.redberry.core.indexmapping.ProviderProduct;
import cc.redberry.core.indexmapping.ProviderSimpleTensor;
import cc.redberry.core.indexmapping.ProviderSum;
import cc.redberry.core.indexmapping.SimpleProductMappingsPort;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.Power;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorField;
import cc.redberry.core.tensor.functions.ArcCos;
import cc.redberry.core.tensor.functions.ArcCot;
import cc.redberry.core.tensor.functions.ArcSin;
import cc.redberry.core.tensor.functions.ArcTan;
import cc.redberry.core.tensor.functions.Cos;
import cc.redberry.core.tensor.functions.Cot;
import cc.redberry.core.tensor.functions.Log;
import cc.redberry.core.tensor.functions.Sin;
import cc.redberry.core.tensor.functions.Tan;
import cc.redberry.core.utils.OutputPort;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class IndexMappings {
    private static final Map<Class, IndexMappingProviderFactory> map = new HashMap<Class, IndexMappingProviderFactory>();

    private IndexMappings() {
    }

    public static MappingsPort createPort(Tensor from, Tensor to) {
        return new MappingsPort(IndexMappings.createPortOfBuffers(new IndexMappingBufferImpl(), from, to));
    }

    public static MappingsPort simpleTensorsPort(SimpleTensor from, SimpleTensor to) {
        IndexMappingProvider provider = ProviderSimpleTensor.FACTORY_SIMPLETENSOR.create(IndexMappingProvider.Util.singleton(new IndexMappingBufferImpl()), from, to);
        provider.tick();
        return new MappingsPort(new MappingsPortRemovingContracted(provider));
    }

    public static MappingsPort createBijectiveProductPort(Tensor[] from, Tensor[] to) {
        if (from.length != to.length) {
            throw new IllegalArgumentException("From length != to length.");
        }
        if (from.length == 0) {
            return new MappingsPort(IndexMappingProvider.Util.singleton(new IndexMappingBufferImpl()));
        }
        if (from.length == 1) {
            return new MappingsPort(IndexMappings.createPortOfBuffers(from[0], to[0]));
        }
        return new MappingsPort(new MappingsPortRemovingContracted(new SimpleProductMappingsPort(IndexMappingProvider.Util.singleton(new IndexMappingBufferImpl()), from, to)));
    }

    public static Mapping getFirst(Tensor from, Tensor to) {
        IndexMappingBuffer buffer = IndexMappings.createPortOfBuffers(from, to).take();
        if (buffer == null) {
            return null;
        }
        return new Mapping(buffer);
    }

    public static boolean testMapping(Mapping mapping, Tensor from, Tensor to) {
        return IndexMappingBufferTester.test(new IndexMappingBufferTester(mapping), from, to);
    }

    public static boolean anyMappingExists(Tensor a, Tensor b) {
        return IndexMappings.mappingExists(a, b) || IndexMappings.mappingExists(b, a);
    }

    public static boolean mappingExists(Tensor from, Tensor to) {
        return IndexMappings.getFirstBuffer(from, to) != null;
    }

    public static boolean positiveMappingExists(Tensor from, Tensor to) {
        IndexMappingBuffer buffer;
        OutputPort<IndexMappingBuffer> port = IndexMappings.createPortOfBuffers(from, to);
        while ((buffer = port.take()) != null) {
            if (buffer.getSign()) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(Tensor u, Tensor v) {
        IndexMappingBuffer buffer;
        if (u == v) {
            return true;
        }
        Indices freeIndices = u.getIndices().getFree();
        if (!freeIndices.equalsRegardlessOrder(v.getIndices().getFree())) {
            return false;
        }
        int[] free = freeIndices.getAllIndices().copy();
        IndexMappingBufferTester tester = new IndexMappingBufferTester(free, false);
        OutputPort<IndexMappingBuffer> mp = IndexMappings.createPortOfBuffers(tester, u, v);
        while ((buffer = mp.take()) != null) {
            if (buffer.getSign()) continue;
            return true;
        }
        return false;
    }

    public static Boolean compare1(Tensor u, Tensor v) {
        Indices freeIndices = u.getIndices().getFree();
        if (!freeIndices.equalsRegardlessOrder(v.getIndices().getFree())) {
            return null;
        }
        int[] free = freeIndices.getAllIndices().copy();
        IndexMappingBufferTester tester = new IndexMappingBufferTester(free, false);
        IndexMappingBuffer buffer = IndexMappings.createPortOfBuffers(tester, u, v).take();
        if (buffer == null) {
            return null;
        }
        return buffer.getSign();
    }

    public static boolean isZeroDueToSymmetry(Tensor t) {
        IndexMappingBuffer buffer;
        int[] indices = IndicesUtils.getIndicesNames(t.getIndices().getFree());
        IndexMappingBufferTester bufferTester = new IndexMappingBufferTester(indices, false);
        OutputPort<IndexMappingBuffer> mp = IndexMappings.createPortOfBuffers(bufferTester, t, t);
        while ((buffer = mp.take()) != null) {
            if (!buffer.getSign()) continue;
            return true;
        }
        return false;
    }

    public static Set<Mapping> getAllMappings(Tensor from, Tensor to) {
        return IndexMappings.getAllMappings(IndexMappings.createPort(from, to));
    }

    private static Set<Mapping> getAllMappings(OutputPort<Mapping> opu) {
        Mapping c;
        HashSet<Mapping> res = new HashSet<Mapping>();
        while ((c = opu.take()) != null) {
            res.add(c);
        }
        return res;
    }

    static OutputPort<IndexMappingBuffer> createPortOfBuffers(Tensor from, Tensor to) {
        return IndexMappings.createPortOfBuffers(new IndexMappingBufferImpl(), from, to);
    }

    static OutputPort<IndexMappingBuffer> createPortOfBuffers(IndexMappingBuffer buffer, Tensor from, Tensor to) {
        IndexMappingProvider provider = IndexMappings.createPort(IndexMappingProvider.Util.singleton(buffer), from, to);
        provider.tick();
        return new MappingsPortRemovingContracted(provider);
    }

    static IndexMappingBuffer getFirstBuffer(Tensor from, Tensor to) {
        return IndexMappings.createPortOfBuffers(from, to).take();
    }

    private static Tensor extractNonComplexFactor(Tensor t) {
        Product p = (Product)t;
        if (p.getFactor().isMinusOne()) {
            return p.get(1);
        }
        return null;
    }

    static IndexMappingProvider createPort(IndexMappingProvider opu, Tensor from, Tensor to) {
        if (from.hashCode() != to.hashCode()) {
            return IndexMappingProvider.Util.EMPTY_PROVIDER;
        }
        if (from.getClass() != to.getClass()) {
            if (from instanceof Product && !(to instanceof Product)) {
                if (from.size() != 2) {
                    return IndexMappingProvider.Util.EMPTY_PROVIDER;
                }
                Tensor nonComplex = IndexMappings.extractNonComplexFactor(from);
                if (nonComplex != null) {
                    return new MinusIndexMappingProviderWrapper(IndexMappings.createPort(opu, nonComplex, to));
                }
                return IndexMappingProvider.Util.EMPTY_PROVIDER;
            }
            if (to instanceof Product && !(from instanceof Product)) {
                if (to.size() != 2) {
                    return IndexMappingProvider.Util.EMPTY_PROVIDER;
                }
                Tensor nonComplex = IndexMappings.extractNonComplexFactor(to);
                if (nonComplex != null) {
                    return new MinusIndexMappingProviderWrapper(IndexMappings.createPort(opu, from, nonComplex));
                }
                return IndexMappingProvider.Util.EMPTY_PROVIDER;
            }
            return IndexMappingProvider.Util.EMPTY_PROVIDER;
        }
        IndexMappingProviderFactory factory = map.get(from.getClass());
        if (factory == null) {
            throw new RuntimeException("Unsupported tensor type: " + from.getClass());
        }
        return factory.create(opu, from, to);
    }

    static {
        map.put(SimpleTensor.class, ProviderSimpleTensor.FACTORY_SIMPLETENSOR);
        map.put(TensorField.class, ProviderSimpleTensor.FACTORY_TENSORFIELD);
        map.put(Product.class, ProviderProduct.FACTORY);
        map.put(Sum.class, ProviderSum.FACTORY);
        map.put(Expression.class, ProviderSum.FACTORY);
        map.put(Complex.class, ProviderComplex.FACTORY);
        map.put(Power.class, ProviderPower.INSTANCE);
        map.put(Sin.class, ProviderFunctions.ODD_FACTORY);
        map.put(ArcSin.class, ProviderFunctions.ODD_FACTORY);
        map.put(Tan.class, ProviderFunctions.ODD_FACTORY);
        map.put(ArcTan.class, ProviderFunctions.ODD_FACTORY);
        map.put(Cos.class, ProviderFunctions.EVEN_FACTORY);
        map.put(ArcCos.class, ProviderFunctions.EVEN_FACTORY);
        map.put(Cot.class, ProviderFunctions.EVEN_FACTORY);
        map.put(ArcCot.class, ProviderFunctions.EVEN_FACTORY);
        map.put(Log.class, ProviderFunctions.FACTORY);
    }
}

