/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indexmapping;

import cc.redberry.core.indexmapping.FromToHolder;
import cc.redberry.core.indexmapping.IndexMappingBuffer;
import cc.redberry.core.indexmapping.IndexMappingBufferImpl;
import cc.redberry.core.indexmapping.IndexMappingBufferRecord;
import cc.redberry.core.indexmapping.IndexMappingProvider;
import cc.redberry.core.indexmapping.IndexMappings;
import cc.redberry.core.indexmapping.Mapping;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.tensor.Tensor;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Arrays;

final class IndexMappingBufferTester
implements IndexMappingBuffer {
    private IndexMappingBufferImpl innerBuffer;
    private final int[] from;
    private final int[] to;
    private final boolean signum;

    public IndexMappingBufferTester(int[] from, boolean sign) {
        from = IndicesUtils.getIndicesNames(from);
        Arrays.sort(from);
        this.to = from;
        this.from = from;
        this.signum = sign;
        this.innerBuffer = new IndexMappingBufferImpl();
    }

    public IndexMappingBufferTester(FromToHolder holder) {
        this.from = holder.from;
        this.to = holder.to;
        this.signum = holder.sign;
        this.innerBuffer = new IndexMappingBufferImpl();
    }

    public IndexMappingBufferTester(Mapping mapping) {
        this.from = mapping.fromNames;
        this.to = IndicesUtils.getIndicesNames(mapping.toData);
        this.signum = mapping.getSign();
        this.innerBuffer = new IndexMappingBufferImpl();
    }

    public IndexMappingBufferTester(IndexMappingBuffer buffer) {
        this(buffer.export());
    }

    private IndexMappingBufferTester(IndexMappingBufferImpl innerBuffer, int[] from, int[] to, boolean signum) {
        this.innerBuffer = innerBuffer;
        this.from = from;
        this.to = to;
        this.signum = signum;
    }

    public static boolean test(IndexMappingBufferTester tester, Tensor from, Tensor to) {
        IndexMappingBuffer buffer;
        tester.reset();
        IndexMappingProvider provider = IndexMappings.createPort(IndexMappingProvider.Util.singleton(tester), from, to);
        provider.tick();
        while ((buffer = (IndexMappingBuffer)provider.take()) != null) {
            if (buffer.getSign()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean tryMap(int from, int to) {
        int fromName = IndicesUtils.getNameWithType(from);
        int toName = IndicesUtils.getNameWithType(to);
        int position = Arrays.binarySearch(this.from, fromName);
        if (position < 0) {
            return this.innerBuffer.tryMap(from, to);
        }
        return this.to[position] == toName;
    }

    @Override
    public void addSign(boolean sign) {
        this.innerBuffer.addSign(sign);
    }

    @Override
    public boolean getSign() {
        return this.signum ^ this.innerBuffer.sign;
    }

    @Override
    public IndexMappingBufferTester clone() {
        return new IndexMappingBufferTester(this.innerBuffer.clone(), this.from, this.to, this.signum);
    }

    @Override
    public void removeContracted() {
        this.innerBuffer.removeContracted();
    }

    @Override
    public boolean isEmpty() {
        return this.innerBuffer.isEmpty();
    }

    @Override
    public TIntObjectHashMap<IndexMappingBufferRecord> getMap() {
        return this.innerBuffer.getMap();
    }

    @Override
    public FromToHolder export() {
        TIntObjectHashMap<IndexMappingBufferRecord> map = this.innerBuffer.map;
        int size = this.from.length + map.size();
        int[] from1 = new int[size];
        int[] to1 = new int[size];
        System.arraycopy(this.from, 0, from1, 0, this.from.length);
        System.arraycopy(this.to, 0, to1, 0, this.from.length);
        int i = this.from.length;
        TIntObjectIterator iterator = map.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            from1[i] = iterator.key();
            to1[i++] = ((IndexMappingBufferRecord)iterator.value()).getIndexName();
        }
        return new FromToHolder(from1, to1, this.getSign());
    }

    public void reset() {
        this.innerBuffer = new IndexMappingBufferImpl();
    }

    public String toString() {
        return "inner: " + this.innerBuffer.toString();
    }
}

