/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.indexmapping;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.Context;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indexmapping.FromToHolder;
import cc.redberry.core.indexmapping.IndexMappingBuffer;
import cc.redberry.core.indexmapping.IndexMappingBufferRecord;
import cc.redberry.core.indices.IndicesUtils;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Comparator;
import java.util.Map;

final class IndexMappingBufferImpl
implements IndexMappingBuffer {
    protected final TIntObjectHashMap<IndexMappingBufferRecord> map;
    protected boolean sign = false;
    private static Comparator<Map.Entry<Integer, IndexMappingBufferRecord>> entryComparator = new Comparator<Map.Entry<Integer, IndexMappingBufferRecord>>(){

        @Override
        public int compare(Map.Entry<Integer, IndexMappingBufferRecord> o1, Map.Entry<Integer, IndexMappingBufferRecord> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };

    public IndexMappingBufferImpl() {
        this.map = new TIntObjectHashMap();
    }

    public IndexMappingBufferImpl(boolean sign) {
        this.map = new TIntObjectHashMap();
        this.sign = sign;
    }

    private IndexMappingBufferImpl(TIntObjectHashMap<IndexMappingBufferRecord> map, boolean sign) {
        this.map = map;
        this.sign = sign;
    }

    @Override
    public void addSign(boolean sign) {
        this.sign ^= sign;
    }

    @Override
    public boolean tryMap(int from, int to) {
        int fromState = IndicesUtils.getStateInt(from);
        if (fromState != IndicesUtils.getStateInt(to) && !CC.isMetric(IndicesUtils.getType(from))) {
            return false;
        }
        int fromName = IndicesUtils.getNameWithType(from);
        IndexMappingBufferRecord record = (IndexMappingBufferRecord)this.map.get(fromName);
        if (record == null) {
            record = new IndexMappingBufferRecord(from, to);
            this.map.put(fromName, (Object)record);
            return true;
        }
        return record.tryMap(from, to);
    }

    @Override
    public void removeContracted() {
        TIntObjectIterator iterator = this.map.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            if (!((IndexMappingBufferRecord)iterator.value()).isContracted()) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean getSign() {
        return this.sign;
    }

    @Override
    public TIntObjectHashMap<IndexMappingBufferRecord> getMap() {
        return this.map;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public FromToHolder export() {
        int size = this.map.size();
        int[] from = new int[size];
        int[] to = new int[size];
        int i = 0;
        TIntObjectIterator iterator = this.map.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            from[i] = iterator.key();
            to[i++] = ((IndexMappingBufferRecord)iterator.value()).getIndexName();
        }
        return new FromToHolder(from, to, this.sign);
    }

    @Override
    public IndexMappingBufferImpl clone() {
        TIntObjectHashMap newMap = new TIntObjectHashMap(this.map);
        TIntObjectIterator iterator = newMap.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            iterator.setValue((Object)((IndexMappingBufferRecord)iterator.value()).clone());
        }
        return new IndexMappingBufferImpl((TIntObjectHashMap<IndexMappingBufferRecord>)newMap, this.sign);
    }

    public String toString() {
        return this.toString(CC.getDefaultOutputFormat());
    }

    private static String toStringIndex(int index, OutputFormat mode) {
        return (IndicesUtils.getState(index) ? "^" : "_") + Context.get().getIndexConverterManager().getSymbol(index, mode);
    }

    public String toString(OutputFormat format) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sign ? (char)'-' : '+').append('{');
        if (this.map.isEmpty()) {
            return sb.append('}').toString();
        }
        TIntObjectIterator iterator = this.map.iterator();
        while (iterator.hasNext()) {
            String to;
            String from;
            iterator.advance();
            if (((IndexMappingBufferRecord)iterator.value()).isContracted()) {
                from = IndexMappingBufferImpl.toStringIndex(iterator.key(), format).substring(1);
                to = IndexMappingBufferImpl.toStringIndex(((IndexMappingBufferRecord)iterator.value()).getIndexName(), format).substring(1);
                sb.append(',');
            } else {
                from = IndexMappingBufferImpl.toStringIndex(IndicesUtils.setRawState(((IndexMappingBufferRecord)iterator.value()).getFromRawState(), iterator.key()), format);
                to = IndexMappingBufferImpl.toStringIndex(IndicesUtils.setRawState(((IndexMappingBufferRecord)iterator.value()).getToRawState(), ((IndexMappingBufferRecord)iterator.value()).getIndexName()), format);
            }
            sb.append(from).append(" -> ").append(to).append(", ");
        }
        sb.deleteCharAt(sb.length() - 1).deleteCharAt(sb.length() - 1).append('}');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexMappingBufferImpl other = (IndexMappingBufferImpl)obj;
        if (this.sign != other.sign) {
            return false;
        }
        if (this.map.size() != other.map.size()) {
            return false;
        }
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        return this.map.equals(other.map);
    }

    public int hashCode() {
        return this.map.hashCode() + (this.sign ? 1 : 0);
    }
}

