/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.groups.permutations;

import java.util.Arrays;

final class SchreierVector {
    int[] data;

    public SchreierVector(int[] data) {
        this.data = data;
    }

    public SchreierVector(int initialCapacity) {
        if (initialCapacity < 10) {
            initialCapacity = 10;
        }
        this.data = new int[initialCapacity];
        Arrays.fill(this.data, -2);
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = Arrays.copyOf(this.data, newCapacity);
            Arrays.fill(this.data, oldCapacity, this.data.length, -2);
        }
    }

    public void set(int position, int num) {
        if (position >= this.data.length) {
            this.ensureCapacity(position + 1);
        }
        this.data[position] = num;
    }

    public int get(int i) {
        if (i >= this.data.length) {
            return -2;
        }
        return this.data[i];
    }

    public int length() {
        return this.data.length;
    }

    public void reset() {
        Arrays.fill(this.data, -2);
    }

    public SchreierVector clone() {
        return new SchreierVector((int[])this.data.clone());
    }
}

