/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.groups.permutations;

import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.Permutations;
import cc.redberry.core.utils.BitArray;
import cc.redberry.core.utils.IntArrayList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;

abstract class PermutationOneLineAbstract
implements Permutation {
    private final boolean isIdentity;
    private final boolean antisymmetry;

    protected PermutationOneLineAbstract(boolean isIdentity, boolean antisymmetry) {
        this.isIdentity = isIdentity;
        this.antisymmetry = antisymmetry;
    }

    @Override
    public boolean antisymmetry() {
        return this.antisymmetry;
    }

    @Override
    public boolean isIdentity() {
        return this.isIdentity;
    }

    @Override
    public Permutation pow(int exponent) {
        if (this.isIdentity) {
            return this;
        }
        Permutation base = this;
        Permutation result = this.getIdentity();
        while (exponent != 0) {
            if (exponent % 2 == 1) {
                result = result.composition(base);
            }
            base = base.composition(base);
            exponent >>= 1;
        }
        return result;
    }

    @Override
    public Permutation getIdentity() {
        if (this.isIdentity) {
            return this;
        }
        return Permutations.createIdentityPermutation(this.length());
    }

    @Override
    public Permutation compositionWithInverse(Permutation other) {
        if (this.isIdentity) {
            return other.inverse();
        }
        if (other.isIdentity()) {
            return this;
        }
        return this.composition(other.inverse());
    }

    @Override
    public Permutation conjugate(Permutation p) {
        return this.inverse().composition(p, this);
    }

    @Override
    public Permutation commutator(Permutation p) {
        return this.inverse().composition(p.inverse(), this, p);
    }

    @Override
    public int[] imageOf(int[] set) {
        if (this.isIdentity()) {
            return (int[])set.clone();
        }
        int[] result = new int[set.length];
        for (int i = 0; i < set.length; ++i) {
            result[i] = this.newIndexOf(set[i]);
        }
        return result;
    }

    @Override
    public int[] permute(int[] array) {
        if (this.isIdentity()) {
            return (int[])array.clone();
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[this.newIndexOf(i)];
        }
        return result;
    }

    @Override
    public char[] permute(char[] array) {
        if (this.isIdentity) {
            return (char[])array.clone();
        }
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[this.newIndexOf(i)];
        }
        return result;
    }

    @Override
    public <T> T[] permute(T[] array) {
        if (this.isIdentity) {
            return (Object[])array.clone();
        }
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[this.newIndexOf(i)];
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Permutation)) {
            return false;
        }
        Permutation that = (Permutation)o;
        if (this.antisymmetry != that.antisymmetry()) {
            return false;
        }
        if (this.degree() != that.degree()) {
            return false;
        }
        for (int i = 0; i < this.degree(); ++i) {
            if (this.newIndexOf(i) == that.newIndexOf(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[][] cycles() {
        ArrayList<int[]> cycles = new ArrayList<int[]>();
        BitArray seen = new BitArray(this.degree());
        int counter = 0;
        while (counter < this.degree()) {
            int start = seen.nextZeroBit(0);
            if (this.newIndexOf(start) == start) {
                ++counter;
                seen.set(start);
                continue;
            }
            IntArrayList cycle = new IntArrayList();
            while (!seen.get(start)) {
                seen.set(start);
                ++counter;
                cycle.add(start);
                start = this.newIndexOf(start);
            }
            cycles.add(cycle.toArray());
        }
        return (int[][])cycles.toArray((T[])new int[cycles.size()][]);
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.degree(); ++i) {
            result = 31 * result + this.newIndexOf(i);
        }
        result = 31 * result + (this.antisymmetry ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.toStringCycles();
    }

    @Override
    public String toStringOneLine() {
        return (this.antisymmetry ? "-" : "+") + this.toStringArray();
    }

    @Override
    public String toStringCycles() {
        String cycles = Arrays.deepToString((Object[])this.cycles());
        return (this.antisymmetry ? "-" : "+") + cycles;
    }

    private String toStringArray() {
        int iMax = this.degree() - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(this.newIndexOf(i));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    @Override
    public int compareTo(Permutation t) {
        int c = Integer.compare(this.degree(), t.degree());
        if (c != 0) {
            return c;
        }
        if (this.antisymmetry != t.antisymmetry()) {
            return this.antisymmetry ? -1 : 1;
        }
        for (int i = 0; i < this.degree(); ++i) {
            if (this.newIndexOf(i) < t.newIndexOf(i)) {
                return -1;
            }
            if (this.newIndexOf(i) <= t.newIndexOf(i)) continue;
            return 1;
        }
        return 0;
    }
}

