/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.groups.permutations;

import cc.redberry.core.groups.permutations.InconsistentGeneratorsException;
import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.Permutations;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

final class BruteForcePermutationIterator
implements Iterator<Permutation> {
    static final Comparator<Permutation> JUST_PERMUTATION_COMPARATOR = new Comparator<Permutation>(){

        @Override
        public int compare(Permutation o1, Permutation o2) {
            return o1.compareTo(o2);
        }
    };
    private TreeSet<Permutation> set = null;
    private List<Permutation> upperLayer;
    private List<Permutation> lowerLayer = new ArrayList<Permutation>();
    private List<Permutation> nextLayer = new ArrayList<Permutation>();
    private boolean forward = false;
    private int upperIndex = 0;
    private int lowerIndex = 0;
    Permutation current;

    public BruteForcePermutationIterator(List<Permutation> permutations) {
        this.set = new TreeSet<Permutation>(JUST_PERMUTATION_COMPARATOR);
        this.upperLayer = new ArrayList<Permutation>();
        this.upperLayer.add(Permutations.createIdentityPermutation(Permutations.internalDegree(permutations)));
        this.lowerLayer = permutations;
    }

    @Override
    public boolean hasNext() {
        this.current = this.next1();
        return this.current != null;
    }

    @Override
    public Permutation next() {
        return this.current;
    }

    private Permutation next1() {
        Permutation composition = null;
        while (composition == null) {
            if (this.forward) {
                composition = this.tryPair(this.upperLayer.get(this.upperIndex), this.lowerLayer.get(this.lowerIndex));
                this.nexIndices();
                if (this.lowerLayer.isEmpty()) break;
                this.forward = !this.forward;
                continue;
            }
            composition = this.tryPair(this.lowerLayer.get(this.lowerIndex), this.upperLayer.get(this.upperIndex));
            this.forward = !this.forward;
        }
        return composition;
    }

    private void nexIndices() {
        if (++this.upperIndex < this.upperLayer.size()) {
            return;
        }
        this.upperIndex = 0;
        if (++this.lowerIndex < this.lowerLayer.size()) {
            return;
        }
        this.lowerIndex = 0;
        this.upperLayer = new ArrayList<Permutation>(this.set);
        this.lowerLayer = this.nextLayer;
        this.nextLayer = new ArrayList<Permutation>();
    }

    private Permutation tryPair(Permutation p0, Permutation p1) {
        Permutation composition = p0.composition(p1);
        Permutation setComposition = this.set.ceiling(composition);
        if (setComposition != null && JUST_PERMUTATION_COMPARATOR.compare(setComposition, composition) == 0) {
            if (setComposition.equals(composition)) {
                return null;
            }
            throw new InconsistentGeneratorsException(composition + " and " + setComposition);
        }
        this.set.add(composition);
        this.nextLayer.add(composition);
        return composition;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

