/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.groups.permutations;

import cc.redberry.core.context.CC;
import cc.redberry.core.groups.permutations.BSGSCandidateElement;
import cc.redberry.core.groups.permutations.BSGSElement;
import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.Permutations;
import cc.redberry.core.groups.permutations.RandomPermutation;
import cc.redberry.core.groups.permutations.SchreierVector;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.BitArray;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.core.utils.MathUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;

public final class AlgorithmsBase {
    public static final List<BSGSElement> TRIVIAL_BSGS = new ArrayList<BSGSElement>(1);
    public static final int SMALL_DEGREE_THRESHOLD = 100;
    private static final ArrayList<BSGSElement>[] CACHED_SYMMETRIC_GROUPS;
    private static final List<BSGSElement>[] CACHED_ANTISYMMETRIC_GROUPS;
    private static final List<BSGSElement>[] CACHED_ALTERNATING_GROUPS;

    private AlgorithmsBase() {
    }

    public static StripContainer strip(List<? extends BSGSElement> BSGS, Permutation permutation) {
        int size = BSGS.size();
        for (int i = 0; i < size; ++i) {
            int beta = permutation.newIndexOf(BSGS.get((int)i).basePoint);
            if (!BSGS.get(i).belongsToOrbit(beta)) {
                return new StripContainer(i, permutation);
            }
            permutation = permutation.composition(BSGS.get(i).getInverseTransversalOf(beta));
        }
        return new StripContainer(BSGS.size(), permutation);
    }

    public static boolean membershipTest(List<? extends BSGSElement> BSGS, Permutation permutation) {
        StripContainer sc = AlgorithmsBase.strip(BSGS, permutation);
        return sc.terminationLevel == BSGS.size() && sc.remainder.isIdentity();
    }

    public static List<BSGSCandidateElement> createRawBSGSCandidate(Permutation ... generators) {
        return AlgorithmsBase.createRawBSGSCandidate(Arrays.asList(generators));
    }

    public static List<BSGSCandidateElement> createRawBSGSCandidate(List<Permutation> generators) {
        return AlgorithmsBase.createRawBSGSCandidate(generators, Permutations.internalDegree(generators));
    }

    public static List<BSGSCandidateElement> createRawBSGSCandidate(List<Permutation> generators, int degree) {
        if (degree == 0) {
            return Collections.EMPTY_LIST;
        }
        int firstBasePoint = -1;
        block0: for (Permutation permutation : generators) {
            for (int i = 0; i < degree; ++i) {
                if (permutation.newIndexOf(i) == i) continue;
                firstBasePoint = i;
                break block0;
            }
        }
        if (firstBasePoint == -1) {
            return Collections.EMPTY_LIST;
        }
        IntArrayList base = new IntArrayList();
        base.add(firstBasePoint);
        ArrayList<BSGSCandidateElement> BSGS = new ArrayList<BSGSCandidateElement>();
        BSGS.add(new BSGSCandidateElement(firstBasePoint, new ArrayList<Permutation>(generators), degree));
        AlgorithmsBase.makeUseOfAllGenerators(BSGS);
        return BSGS;
    }

    public static List<BSGSCandidateElement> createRawBSGSCandidate(int[] knownBase, List<Permutation> generators) {
        return AlgorithmsBase.createRawBSGSCandidate(knownBase, generators, Permutations.internalDegree(generators));
    }

    public static List<BSGSCandidateElement> createRawBSGSCandidate(int[] knownBase, List<Permutation> generators, int degree) {
        if (degree == 0) {
            return Collections.EMPTY_LIST;
        }
        IntArrayList base = new IntArrayList((int[])knownBase.clone());
        block0: for (int i = base.size() - 1; i >= 0; --i) {
            for (Permutation permutation : generators) {
                if (permutation.newIndexOf(base.get(i)) == base.get(i)) continue;
                continue block0;
            }
            base.remove(i);
        }
        if (base.isEmpty()) {
            return AlgorithmsBase.createRawBSGSCandidate(generators, degree);
        }
        ArrayList<BSGSCandidateElement> BSGS = new ArrayList<BSGSCandidateElement>(knownBase.length);
        BSGS.add(new BSGSCandidateElement(base.get(0), new ArrayList<Permutation>(generators), degree));
        int size = base.size();
        for (int i = 1; i < size; ++i) {
            ArrayList<Permutation> stabilizerGenerators = new ArrayList<Permutation>();
            block3: for (Permutation stabilizerGenerator : generators) {
                for (int j = 0; j < i; ++j) {
                    if (stabilizerGenerator.newIndexOf(base.get(j)) != base.get(j)) continue block3;
                }
                stabilizerGenerators.add(stabilizerGenerator);
            }
            BSGS.add(new BSGSCandidateElement(base.get(i), stabilizerGenerators, degree));
        }
        AlgorithmsBase.makeUseOfAllGenerators(BSGS);
        return BSGS;
    }

    public static List<BSGSElement> createBSGSList(List<Permutation> generators) {
        return AlgorithmsBase.createBSGSList(generators, Permutations.internalDegree(generators));
    }

    public static List<BSGSElement> createBSGSList(List<Permutation> generators, int degree) {
        List<BSGSCandidateElement> BSGSCandidate = AlgorithmsBase.createRawBSGSCandidate(generators, degree);
        if (BSGSCandidate.isEmpty()) {
            return TRIVIAL_BSGS;
        }
        AlgorithmsBase.SchreierSimsAlgorithm((ArrayList)BSGSCandidate);
        AlgorithmsBase.removeRedundantBaseRemnant((ArrayList)BSGSCandidate);
        return AlgorithmsBase.asBSGSList(BSGSCandidate);
    }

    public static List<BSGSElement> createBSGSList(int[] knownBase, List<Permutation> generators) {
        return AlgorithmsBase.createBSGSList(knownBase, generators, Permutations.internalDegree(generators));
    }

    public static List<BSGSElement> createBSGSList(int[] knownBase, List<Permutation> generators, int degree) {
        List<BSGSCandidateElement> BSGSCandidate = AlgorithmsBase.createRawBSGSCandidate(knownBase, generators, degree);
        if (BSGSCandidate.isEmpty()) {
            return TRIVIAL_BSGS;
        }
        AlgorithmsBase.SchreierSimsAlgorithm((ArrayList)BSGSCandidate);
        AlgorithmsBase.removeRedundantBaseRemnant((ArrayList)BSGSCandidate);
        return AlgorithmsBase.asBSGSList(BSGSCandidate);
    }

    public static void makeUseOfAllGenerators(List<BSGSCandidateElement> BSGSCandidate) {
        List generators = BSGSCandidate.get((int)0).stabilizerGenerators;
        int degree = BSGSCandidate.get(0).internalDegree();
        if (degree == 0) {
            return;
        }
        for (Permutation generator : generators) {
            boolean fixesBase = true;
            for (BSGSCandidateElement element : BSGSCandidate) {
                if (generator.newIndexOf(element.basePoint) == element.basePoint) continue;
                fixesBase = false;
                break;
            }
            if (!fixesBase) continue;
            for (int point = 0; point < degree; ++point) {
                if (generator.newIndexOf(point) == point) continue;
                BSGSCandidate.add(new BSGSCandidateElement(point, BSGSCandidate.get(BSGSCandidate.size() - 1).getStabilizersOfThisBasePoint(), degree));
            }
        }
    }

    public static void SchreierSimsAlgorithm(ArrayList<BSGSCandidateElement> BSGSCandidate) {
        if (BSGSCandidate.isEmpty()) {
            return;
        }
        int degree = BSGSCandidate.get(0).internalDegree();
        if (degree == 0) {
            return;
        }
        int index = BSGSCandidate.size() - 1;
        block0: while (index >= 0) {
            BSGSCandidateElement currentElement = BSGSCandidate.get(index);
            int sizeOfOrbit = currentElement.orbitList.size();
            for (int indexInOrbit = 0; indexInOrbit < sizeOfOrbit; ++indexInOrbit) {
                int beta = currentElement.orbitList.get(indexInOrbit);
                Permutation transversalOfBeta = currentElement.getTransversalOf(beta);
                for (Permutation stabilizer : currentElement.stabilizerGenerators) {
                    int i;
                    Permutation transversalOfBetaX = currentElement.getTransversalOf(stabilizer.newIndexOf(beta));
                    if (transversalOfBeta.composition(stabilizer).equals(transversalOfBetaX)) continue;
                    Permutation SchreierGenerator = transversalOfBeta.composition(stabilizer, transversalOfBetaX.inverse());
                    StripContainer strip = AlgorithmsBase.strip(BSGSCandidate, SchreierGenerator);
                    boolean toAddNewGenerator = false;
                    if (strip.terminationLevel < BSGSCandidate.size()) {
                        toAddNewGenerator = true;
                    } else if (!strip.remainder.isIdentity()) {
                        toAddNewGenerator = true;
                        for (i = 0; i < degree; ++i) {
                            if (strip.remainder.newIndexOf(i) == i) continue;
                            BSGSCandidate.add(new BSGSCandidateElement(i, new ArrayList<Permutation>(), degree));
                            break;
                        }
                    }
                    if (!toAddNewGenerator) continue;
                    for (i = index + 1; i <= strip.terminationLevel; ++i) {
                        BSGSCandidate.get(i).addStabilizer(strip.remainder);
                    }
                    index = strip.terminationLevel;
                    continue block0;
                }
            }
            --index;
        }
    }

    public static void RandomSchreierSimsAlgorithm(ArrayList<BSGSCandidateElement> BSGSCandidate, double confidenceLevel, RandomGenerator randomGenerator) {
        if (confidenceLevel > 1.0 || confidenceLevel < 0.0) {
            throw new IllegalArgumentException("Confidence level must be between 0 and 1.");
        }
        if (BSGSCandidate.isEmpty()) {
            return;
        }
        int degree = BSGSCandidate.get(0).internalDegree();
        if (degree == 0) {
            return;
        }
        ArrayList<Permutation> source = new ArrayList<Permutation>(BSGSCandidate.get((int)0).stabilizerGenerators);
        RandomPermutation.randomness(source, 10, 20, randomGenerator);
        AlgorithmsBase.makeUseOfAllGenerators(BSGSCandidate);
        int sifted = 0;
        int CL = (int)(-FastMath.log((double)2.0, (double)(1.0 - confidenceLevel)));
        assert (CL > 0);
        while (sifted < CL) {
            int i;
            Permutation randomElement = RandomPermutation.random(source, randomGenerator);
            StripContainer strip = AlgorithmsBase.strip(BSGSCandidate, randomElement);
            boolean toAddNewGenerator = false;
            if (strip.terminationLevel < BSGSCandidate.size()) {
                toAddNewGenerator = true;
            } else if (!strip.remainder.isIdentity()) {
                toAddNewGenerator = true;
                for (i = 0; i < degree; ++i) {
                    if (strip.remainder.newIndexOf(i) == i) continue;
                    BSGSCandidate.add(new BSGSCandidateElement(i, new ArrayList<Permutation>(), degree));
                    break;
                }
            }
            if (toAddNewGenerator) {
                for (i = 1; i <= strip.terminationLevel; ++i) {
                    BSGSCandidate.get(i).addStabilizer(strip.remainder);
                }
                sifted = 0;
                continue;
            }
            ++sifted;
        }
    }

    public static void RandomSchreierSimsAlgorithmForKnownOrder(ArrayList<BSGSCandidateElement> BSGSCandidate, BigInteger groupOrder, RandomGenerator randomGenerator) {
        if (BSGSCandidate.isEmpty()) {
            return;
        }
        int degree = BSGSCandidate.get(0).internalDegree();
        if (degree == 0) {
            return;
        }
        ArrayList<Permutation> source = new ArrayList<Permutation>(BSGSCandidate.get((int)0).stabilizerGenerators);
        RandomPermutation.randomness(source, 10, 20, randomGenerator);
        while (!groupOrder.equals(AlgorithmsBase.calculateOrder(BSGSCandidate))) {
            int i;
            Permutation randomElement = RandomPermutation.random(source, randomGenerator);
            StripContainer strip = AlgorithmsBase.strip(BSGSCandidate, randomElement);
            boolean toAddNewGenerator = false;
            if (strip.terminationLevel < BSGSCandidate.size()) {
                toAddNewGenerator = true;
            } else if (!strip.remainder.isIdentity()) {
                toAddNewGenerator = true;
                for (i = 0; i < degree; ++i) {
                    if (strip.remainder.newIndexOf(i) == i) continue;
                    BSGSCandidate.add(new BSGSCandidateElement(i, new ArrayList<Permutation>(), degree));
                    break;
                }
            }
            if (!toAddNewGenerator) continue;
            for (i = 1; i <= strip.terminationLevel; ++i) {
                BSGSCandidate.get(i).addStabilizer(strip.remainder);
            }
        }
    }

    public static final BigInteger calculateOrder(List<? extends BSGSElement> BSGSList) {
        return AlgorithmsBase.calculateOrder(BSGSList, 0);
    }

    static final BigInteger calculateOrder(List<? extends BSGSElement> BSGSList, int from) {
        BigInteger order = BigInteger.ONE;
        int size = BSGSList.size();
        for (int i = from; i < size; ++i) {
            order = order.multiply(BigInteger.valueOf(BSGSList.get(i).orbitSize()));
        }
        return order;
    }

    public static void removeRedundantGenerators(ArrayList<BSGSCandidateElement> BSGSCandidate) {
        if (BSGSCandidate.size() <= 1) {
            return;
        }
        int degree = BSGSCandidate.get(0).internalDegree();
        if (degree == 0) {
            return;
        }
        for (int i = BSGSCandidate.size() - 2; i > 0; --i) {
            BSGSCandidateElement element = BSGSCandidate.get(i);
            ListIterator iterator = element.stabilizerGenerators.listIterator();
            ArrayList<Permutation> tempStabilizers = null;
            boolean removed = false;
            block1: while (iterator.hasNext()) {
                Permutation current = (Permutation)iterator.next();
                if (current.isIdentity()) {
                    iterator.remove();
                    removed = true;
                    continue;
                }
                if (current.newIndexOf(element.basePoint) == element.basePoint && BSGSCandidate.get((int)(i + 1)).stabilizerGenerators.contains(element)) continue;
                if (tempStabilizers == null) {
                    tempStabilizers = new ArrayList<Permutation>(element.stabilizerGenerators);
                }
                tempStabilizers.remove(current);
                if (Permutations.getOrbitSize(tempStabilizers, element.basePoint, degree) == element.orbitSize()) {
                    int[] subBase = AlgorithmsBase.getBaseAsArray(BSGSCandidate, i);
                    List<BSGSCandidateElement> _subBSGS = AlgorithmsBase.createRawBSGSCandidate(subBase, tempStabilizers, degree);
                    if (_subBSGS.isEmpty()) {
                        assert (AlgorithmsBase.calculateOrder(BSGSCandidate, i).intValue() != 1);
                        continue;
                    }
                    ArrayList subBSGS = (ArrayList)_subBSGS;
                    AlgorithmsBase.SchreierSimsAlgorithm(subBSGS);
                    if (!AlgorithmsBase.calculateOrder(BSGSCandidate, i).equals(AlgorithmsBase.calculateOrder(subBSGS))) continue;
                    for (Permutation stabGen : BSGSCandidate.get((int)(i + 1)).stabilizerGenerators) {
                        if (AlgorithmsBase.membershipTest(subBSGS, stabGen)) continue;
                        continue block1;
                    }
                    iterator.remove();
                    removed = true;
                    continue;
                }
                tempStabilizers.add(current);
            }
            if (!removed) continue;
            element.recalculateOrbitAndSchreierVector();
        }
    }

    public static void removeRedundantBaseRemnant(ArrayList<BSGSCandidateElement> BSGS) {
        for (int i = BSGS.size() - 1; i >= 0 && BSGS.get((int)i).stabilizerGenerators.isEmpty(); --i) {
            BSGS.remove(i);
        }
    }

    public static boolean isBSGS(List<? extends BSGSElement> BSGSCandidate) {
        if (BSGSCandidate.isEmpty()) {
            return true;
        }
        for (int index = BSGSCandidate.size() - 1; index >= 0; --index) {
            BSGSElement currentElement = BSGSCandidate.get(index);
            int sizeOfOrbit = currentElement.orbitList.size();
            for (int indexInOrbit = 0; indexInOrbit < sizeOfOrbit; ++indexInOrbit) {
                int beta = currentElement.orbitList.get(indexInOrbit);
                Permutation transversalOfBeta = currentElement.getTransversalOf(beta);
                for (Permutation stabilizer : currentElement.stabilizerGenerators) {
                    Permutation transversalOfBetaX = currentElement.getTransversalOf(stabilizer.newIndexOf(beta));
                    if (transversalOfBeta.composition(stabilizer).equals(transversalOfBetaX)) continue;
                    Permutation SchreierGenerator = transversalOfBeta.composition(stabilizer, transversalOfBetaX.inverse());
                    StripContainer strip = AlgorithmsBase.strip(BSGSCandidate, SchreierGenerator);
                    if (strip.terminationLevel >= BSGSCandidate.size() && strip.remainder.isIdentity()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isBSGS(List<? extends BSGSElement> BSGSCandidate, double confidenceLevel, RandomGenerator randomGenerator) {
        if (confidenceLevel > 1.0 || confidenceLevel < 0.0) {
            throw new IllegalArgumentException("Confidence level must be between 0 and 1.");
        }
        ArrayList<Permutation> source = new ArrayList<Permutation>(BSGSCandidate.get((int)0).stabilizerGenerators);
        RandomPermutation.randomness(source, 10, 20, randomGenerator);
        source = new ArrayList<Permutation>(source);
        int CL = (int)(-FastMath.log((double)2.0, (double)(1.0 - confidenceLevel)));
        assert (CL > 0);
        for (int sifted = 0; sifted < CL; ++sifted) {
            Permutation randomElement = RandomPermutation.random(source, randomGenerator);
            StripContainer strip = AlgorithmsBase.strip(BSGSCandidate, randomElement);
            boolean toAddNewGenerator = false;
            if (strip.terminationLevel >= BSGSCandidate.size() && strip.remainder.isIdentity()) continue;
            return false;
        }
        return true;
    }

    public static long numberOfStrongGenerators(List<? extends BSGSElement> BSGS) {
        long num = 0L;
        for (BSGSElement bSGSElement : BSGS) {
            num += (long)bSGSElement.stabilizerGenerators.size();
        }
        return num;
    }

    public static void swapAdjacentBasePoints(ArrayList<BSGSCandidateElement> BSGS, int i) {
        if (i > BSGS.size() - 2) {
            throw new IndexOutOfBoundsException();
        }
        int ithBeta = BSGS.get((int)i).basePoint;
        int jthBeta = BSGS.get((int)(i + 1)).basePoint;
        int effectiveDegree = Math.max(BSGS.get(0).internalDegree(), Math.max(ithBeta + 1, jthBeta + 1));
        int d = Permutations.getOrbitSize(BSGS.get((int)i).stabilizerGenerators, BSGS.get((int)(i + 1)).basePoint, effectiveDegree);
        int s = (int)((long)BSGS.get(i).orbitSize() * (long)BSGS.get(i + 1).orbitSize() / (long)d);
        ArrayList<Permutation> newStabilizers = i == BSGS.size() - 2 ? new ArrayList<Permutation>() : new ArrayList(BSGS.get((int)(i + 2)).stabilizerGenerators);
        BitArray allowedPoints = new BitArray(effectiveDegree);
        allowedPoints.setAll(BSGS.get((int)i).orbitList, true);
        allowedPoints.set(ithBeta, false);
        allowedPoints.set(jthBeta, false);
        BSGSCandidateElement newOrbitStabilizer = new BSGSCandidateElement(ithBeta, newStabilizers, effectiveDegree);
        block0: while (newOrbitStabilizer.orbitSize() != s) {
            Permutation newStabilizer;
            int nextBasePoint = -1;
            while (true) {
                ++nextBasePoint;
                if ((nextBasePoint = allowedPoints.nextBit(nextBasePoint)) == -1) continue block0;
                Permutation transversal = BSGS.get(i).getTransversalOf(nextBasePoint);
                int newIndexUnderInverse = transversal.newIndexOfUnderInverse(jthBeta);
                if (!BSGS.get(i + 1).belongsToOrbit(newIndexUnderInverse)) {
                    IntArrayList toRemove = Permutations.getOrbitList(newOrbitStabilizer.stabilizerGenerators, nextBasePoint, effectiveDegree);
                    allowedPoints.setAll(toRemove, false);
                    continue;
                }
                newStabilizer = BSGS.get(i + 1).getTransversalOf(newIndexUnderInverse).composition(transversal);
                if (!newOrbitStabilizer.belongsToOrbit(newStabilizer.newIndexOf(ithBeta))) break;
            }
            newOrbitStabilizer.addStabilizer(newStabilizer);
            IntArrayList toRemove = Permutations.getOrbitList(newOrbitStabilizer.stabilizerGenerators, nextBasePoint, effectiveDegree);
            allowedPoints.setAll(toRemove, false);
        }
        BSGSCandidateElement ith = new BSGSCandidateElement(BSGS.get((int)(i + 1)).basePoint, BSGS.get((int)i).stabilizerGenerators, effectiveDegree);
        BSGSCandidateElement jth = new BSGSCandidateElement(BSGS.get((int)i).basePoint, newStabilizers, effectiveDegree);
        BSGS.set(i, ith);
        BSGS.set(i + 1, jth);
    }

    static void changeBasePointWithTranspositions(ArrayList<BSGSCandidateElement> BSGS, int oldBasePointPosition, int newBasePoint) {
        int insertionPosition;
        assert (BSGS.get((int)oldBasePointPosition).basePoint != newBasePoint);
        for (int index = oldBasePointPosition + 1; index < BSGS.size(); ++index) {
            if (BSGS.get((int)index).basePoint != newBasePoint) continue;
            while (index > oldBasePointPosition) {
                AlgorithmsBase.swapAdjacentBasePoints(BSGS, --index);
            }
            return;
        }
        block2: for (insertionPosition = oldBasePointPosition + 1; insertionPosition < BSGS.size(); ++insertionPosition) {
            for (Permutation permutation : BSGS.get((int)insertionPosition).stabilizerGenerators) {
                if (permutation.newIndexOf(newBasePoint) == newBasePoint) continue;
                continue block2;
            }
        }
        int degree = BSGS.get(0).internalDegree();
        if (insertionPosition == BSGS.size()) {
            BSGS.add(new BSGSCandidateElement(newBasePoint, new ArrayList<Permutation>(), degree));
        } else if (BSGS.get((int)insertionPosition).basePoint != newBasePoint) {
            BSGS.add(insertionPosition, new BSGSCandidateElement(newBasePoint, new ArrayList<Permutation>(BSGS.get((int)insertionPosition).stabilizerGenerators), degree));
        }
        while (insertionPosition > oldBasePointPosition) {
            AlgorithmsBase.swapAdjacentBasePoints(BSGS, --insertionPosition);
        }
    }

    public static void rebaseWithTranspositions(ArrayList<BSGSCandidateElement> BSGS, int[] newBase) {
        for (int i = 0; i < newBase.length && i < BSGS.size(); ++i) {
            int newBasePoint = newBase[i];
            if (BSGS.get((int)i).basePoint == newBasePoint) continue;
            AlgorithmsBase.changeBasePointWithTranspositions(BSGS, i, newBasePoint);
        }
        AlgorithmsBase.removeRedundantBaseRemnant(BSGS);
    }

    public static void rebaseWithConjugationAndTranspositions(ArrayList<BSGSCandidateElement> BSGS, int[] newBase) {
        Permutation conjugation = Permutations.getIdentityPermutation();
        int degree = BSGS.get(0).internalDegree();
        int positionOfFirstChanged = -1;
        for (int i = 0; i < newBase.length && i < BSGS.size(); ++i) {
            int newBasePoint = conjugation.newIndexOfUnderInverse(newBase[i]);
            if (BSGS.get((int)i).basePoint == newBasePoint) continue;
            if (positionOfFirstChanged == -1) {
                positionOfFirstChanged = i;
            }
            if (BSGS.get(i).belongsToOrbit(newBasePoint)) {
                Permutation transversal = BSGS.get(i).getTransversalOf(newBasePoint);
                conjugation = transversal.composition(conjugation);
                continue;
            }
            AlgorithmsBase.changeBasePointWithTranspositions(BSGS, i, newBasePoint);
        }
        AlgorithmsBase.removeRedundantBaseRemnant(BSGS);
        if (BSGS.size() <= positionOfFirstChanged) {
            return;
        }
        if (!conjugation.isIdentity()) {
            Permutation inverse = conjugation.inverse();
            ListIterator<BSGSCandidateElement> elementsIterator = BSGS.listIterator(positionOfFirstChanged);
            while (elementsIterator.hasNext()) {
                BSGSCandidateElement element = elementsIterator.next();
                ArrayList<Permutation> newStabilizers = new ArrayList<Permutation>(element.stabilizerGenerators.size());
                for (Permutation oldStabilizer : element.stabilizerGenerators) {
                    newStabilizers.add(inverse.composition(oldStabilizer, conjugation));
                }
                int newBasePoint = conjugation.newIndexOf(element.basePoint);
                elementsIterator.set(new BSGSCandidateElement(newBasePoint, newStabilizers, degree));
            }
        }
        AlgorithmsBase.removeRedundantBaseRemnant(BSGS);
    }

    public static void rebaseFromScratch(ArrayList<BSGSCandidateElement> BSGS, int[] newBase) {
        int i;
        List<BSGSCandidateElement> newBSGS = AlgorithmsBase.createRawBSGSCandidate(newBase, BSGS.get((int)0).stabilizerGenerators, BSGS.get(0).internalDegree());
        if (newBSGS.isEmpty()) {
            return;
        }
        BigInteger order = AlgorithmsBase.calculateOrder(BSGS);
        AlgorithmsBase.RandomSchreierSimsAlgorithmForKnownOrder((ArrayList)newBSGS, order, CC.getRandomGenerator());
        for (i = 0; i < newBSGS.size() && i < BSGS.size(); ++i) {
            BSGS.set(i, newBSGS.get(i));
        }
        if (i < newBSGS.size()) {
            while (i < newBSGS.size()) {
                BSGS.add(newBSGS.get(i));
                ++i;
            }
        }
        if (i < BSGS.size()) {
            for (int j = BSGS.size() - 1; j >= i; --j) {
                BSGS.remove(j);
            }
        }
    }

    public static void rebase(ArrayList<BSGSCandidateElement> BSGS, int[] newBase) {
        AlgorithmsBase.rebaseWithConjugationAndTranspositions(BSGS, newBase);
    }

    public static ArrayList<BSGSElement> directProduct(List<? extends BSGSElement> bsgs1, List<? extends BSGSElement> bsgs2) {
        int degree1 = bsgs1.get(0).internalDegree();
        int degree2 = bsgs2.get(0).internalDegree();
        int deg = degree1 + degree2;
        ArrayList<BSGSElement> groupBsgsExtended = new ArrayList<BSGSElement>(bsgs2.size());
        for (BSGSElement bSGSElement : bsgs2) {
            ArrayList<Permutation> arrayList = new ArrayList<Permutation>(bSGSElement.stabilizerGenerators.size());
            for (Permutation p : bSGSElement.stabilizerGenerators) {
                arrayList.add(p.moveRight(degree1));
            }
            int[] SchreierVector2 = new int[deg];
            Arrays.fill(SchreierVector2, 0, degree1, -2);
            System.arraycopy(bSGSElement.SchreierVector.data, 0, SchreierVector2, degree1, degree2);
            IntArrayList orbit = new IntArrayList(bSGSElement.orbitList.size());
            for (int i = bSGSElement.orbitList.size() - 1; i >= 0; --i) {
                orbit.add(bSGSElement.orbitList.get(i) + degree1);
            }
            groupBsgsExtended.add(new BSGSElement(bSGSElement.basePoint + degree1, arrayList, new SchreierVector(SchreierVector2), orbit));
        }
        ArrayList<BSGSElement> bsgs = new ArrayList<BSGSElement>(bsgs1.size() + bsgs2.size());
        for (BSGSElement bSGSElement : bsgs1) {
            ArrayList<Permutation> stabilizers = new ArrayList<Permutation>(bSGSElement.stabilizerGenerators.size());
            for (Permutation p : bSGSElement.stabilizerGenerators) {
                stabilizers.add(p);
            }
            stabilizers.addAll(((BSGSElement)groupBsgsExtended.get((int)0)).stabilizerGenerators);
            int[] SchreierVector3 = new int[deg];
            System.arraycopy(bSGSElement.SchreierVector.data, 0, SchreierVector3, 0, degree1);
            Arrays.fill(SchreierVector3, degree1, deg, -2);
            bsgs.add(new BSGSElement(bSGSElement.basePoint, stabilizers, new SchreierVector(SchreierVector3), bSGSElement.orbitList));
        }
        bsgs.addAll(groupBsgsExtended);
        return bsgs;
    }

    public static ArrayList<? extends BSGSElement> union(ArrayList<? extends BSGSElement> bsgs1, ArrayList<? extends BSGSElement> bsgs2) {
        if (bsgs2.isEmpty()) {
            return bsgs1;
        }
        if (bsgs1.isEmpty()) {
            return bsgs2;
        }
        int[] base1 = AlgorithmsBase.getBaseAsArray(bsgs1);
        int[] base2 = AlgorithmsBase.getBaseAsArray(bsgs2);
        int[] base = MathUtils.intSetUnion(base1, base2);
        ArrayList<Permutation> generators = new ArrayList<Permutation>();
        generators.addAll(bsgs1.get((int)0).stabilizerGenerators);
        generators.addAll(bsgs1.get((int)0).stabilizerGenerators);
        int degree = Math.max(ArraysUtils.max(base) + 1, Permutations.internalDegree(generators));
        ArrayList bsgs = (ArrayList)AlgorithmsBase.createRawBSGSCandidate(base, generators, degree);
        AlgorithmsBase.SchreierSimsAlgorithm(bsgs);
        return bsgs;
    }

    public static List<BSGSElement> createAlternatingGroupBSGS(int degree) {
        if (degree == 0) {
            throw new IllegalArgumentException("Degree = 0.");
        }
        if (degree <= 100) {
            List<BSGSElement> bsgs = CACHED_ALTERNATING_GROUPS[degree - 1];
            if (bsgs == null) {
                AlgorithmsBase.CACHED_ALTERNATING_GROUPS[degree - 1] = bsgs = AlgorithmsBase.createAlternatingGroupBSGSForSmallDegree(degree);
            }
            return bsgs;
        }
        return AlgorithmsBase.createAlternatingGroupBSGSForLargeDegree(degree);
    }

    static List<BSGSElement> createAlternatingGroupBSGSForSmallDegree(int degree) {
        if (degree < 3) {
            return TRIVIAL_BSGS;
        }
        ArrayList<BSGSElement> bsgs = new ArrayList<BSGSElement>();
        ArrayList<Permutation> stabilizers = new ArrayList<Permutation>(degree);
        for (int i = 0; i < degree - 2; ++i) {
            int j;
            IntArrayList orbit = new IntArrayList(degree - i);
            for (int j2 = i; j2 < degree; ++j2) {
                orbit.add(j2);
            }
            int[] SchreierVector2 = new int[degree];
            Arrays.fill(SchreierVector2, -2);
            SchreierVector2[i] = -1;
            int[] perm = new int[degree];
            for (j = 1; j < i; ++j) {
                perm[j] = j;
            }
            for (j = i + 3; j < degree; ++j) {
                perm[j] = j;
            }
            perm[i] = i + 1;
            perm[i + 1] = i + 2;
            perm[i + 2] = i;
            SchreierVector2[i + 1] = stabilizers.size();
            stabilizers.add(Permutations.createPermutation(perm));
            SchreierVector2[i + 2] = stabilizers.size();
            stabilizers.add(((Permutation)stabilizers.get(0)).pow(2));
            int inverseParity = 1 - (degree - i) % 2;
            Permutation base = inverseParity == 1 ? (Permutation)stabilizers.get(0) : ((Permutation)stabilizers.get(0)).getIdentity();
            for (int k = 3; k < degree - i; ++k) {
                int j3;
                perm = new int[degree];
                for (j3 = 1; j3 <= i; ++j3) {
                    perm[j3] = j3;
                }
                for (j3 = i + inverseParity; j3 < degree - k + inverseParity; ++j3) {
                    perm[j3] = j3 + k - inverseParity;
                }
                int t = 0;
                while (j3 < degree) {
                    perm[j3] = i + inverseParity + t;
                    ++j3;
                    ++t;
                }
                SchreierVector2[i + k] = stabilizers.size();
                stabilizers.add(base.composition(Permutations.createPermutation(perm)));
            }
            bsgs.add(new BSGSElement(i, new ArrayList<Permutation>(stabilizers), new SchreierVector(SchreierVector2), orbit));
            stabilizers.clear();
        }
        return bsgs;
    }

    static List<BSGSElement> createAlternatingGroupBSGSForLargeDegree(int degree) {
        if (degree < 3) {
            return TRIVIAL_BSGS;
        }
        ArrayList<BSGSElement> bsgs = new ArrayList<BSGSElement>();
        ArrayList<Permutation> stabilizers = new ArrayList<Permutation>(degree);
        for (int i = 0; i < degree - 2; ++i) {
            int j;
            int[] perm = new int[degree];
            for (j = 1; j < i; ++j) {
                perm[j] = j;
            }
            for (j = i + 3; j < degree; ++j) {
                perm[j] = j;
            }
            perm[i] = i + 1;
            perm[i + 1] = i + 2;
            perm[i + 2] = i;
            stabilizers.add(Permutations.createPermutation(perm));
            stabilizers.add(((Permutation)stabilizers.get(0)).pow(2));
            int inverseParity = 1 - (degree - i) % 2;
            Permutation base = inverseParity == 1 ? (Permutation)stabilizers.get(0) : ((Permutation)stabilizers.get(0)).getIdentity();
            for (int r = degree - i - 3; r > 0; r /= 2) {
                int j2;
                int k = r + 2;
                perm = new int[degree];
                for (j2 = 1; j2 <= i; ++j2) {
                    perm[j2] = j2;
                }
                for (j2 = i + inverseParity; j2 < degree - k + inverseParity; ++j2) {
                    perm[j2] = j2 + k - inverseParity;
                }
                int t = 0;
                while (j2 < degree) {
                    perm[j2] = i + inverseParity + t;
                    ++j2;
                    ++t;
                }
                stabilizers.add(base.composition(Permutations.createPermutation(perm)));
            }
            bsgs.add(new BSGSCandidateElement(i, new ArrayList<Permutation>(stabilizers), degree).asBSGSElement());
            stabilizers.clear();
        }
        return bsgs;
    }

    public static ArrayList<BSGSElement> createSymmetricGroupBSGS(int degree) {
        if (degree == 0) {
            throw new IllegalArgumentException("Degree = 0.");
        }
        if (degree <= 100) {
            ArrayList<BSGSElement> bsgs = CACHED_SYMMETRIC_GROUPS[degree - 1];
            if (bsgs == null) {
                AlgorithmsBase.CACHED_SYMMETRIC_GROUPS[degree - 1] = bsgs = AlgorithmsBase.createSymmetricGroupBSGSForSmallDegree(degree);
            }
            return bsgs;
        }
        return AlgorithmsBase.createSymmetricGroupBSGSForLargeDegree(degree);
    }

    static ArrayList<BSGSElement> createSymmetricGroupBSGSForSmallDegree(int degree) {
        ArrayList<BSGSElement> bsgs = new ArrayList<BSGSElement>(degree - 1);
        for (int i = 0; i < degree - 1; ++i) {
            int j;
            IntArrayList orbit = new IntArrayList(degree - i);
            for (j = i; j < degree; ++j) {
                orbit.add(j);
            }
            Permutation[] stabilizers = new Permutation[degree - i - 1];
            int[] SchreierVector2 = new int[degree];
            Arrays.fill(SchreierVector2, -2);
            SchreierVector2[i] = -1;
            int c = 0;
            for (j = i + 1; j < degree; ++j) {
                int[] permutation = new int[degree];
                for (int k = 1; k < degree; ++k) {
                    permutation[k] = k;
                }
                permutation[j] = i;
                permutation[i] = j;
                stabilizers[c] = Permutations.createPermutation(permutation);
                SchreierVector2[j] = c++;
            }
            BSGSElement element = new BSGSElement(i, Arrays.asList(stabilizers), new SchreierVector(SchreierVector2), orbit);
            bsgs.add(element);
        }
        return bsgs;
    }

    static ArrayList<BSGSElement> createSymmetricGroupBSGSForLargeDegree(int degree) {
        ArrayList<BSGSElement> bsgs = new ArrayList<BSGSElement>(degree - 1);
        for (int i = 0; i < degree - 1; ++i) {
            int j;
            IntArrayList orbit = new IntArrayList(degree - i);
            for (j = i; j < degree; ++j) {
                orbit.add(j);
            }
            ArrayList<Permutation> stabilizers = new ArrayList<Permutation>((int)(FastMath.log((double)(degree - i)) / FastMath.log((double)2.0)));
            int[] permutation = new int[degree];
            for (j = 1; j < degree; ++j) {
                permutation[j] = j;
            }
            permutation[i] = i + 1;
            permutation[i + 1] = i;
            stabilizers.add(Permutations.createPermutation(permutation));
            for (j = degree - i - 1; j > 0; j /= 2) {
                int l;
                int k;
                int image = i + j;
                permutation = new int[degree];
                for (k = 0; k < i; ++k) {
                    permutation[k] = k;
                }
                for (l = 0; l < degree - image; ++l) {
                    permutation[k] = image + l;
                    ++k;
                }
                l = 0;
                while (k < degree) {
                    permutation[k] = i + l++;
                    ++k;
                }
                stabilizers.add(Permutations.createPermutation(permutation));
            }
            BSGSElement element = new BSGSCandidateElement(i, stabilizers, degree).asBSGSElement();
            bsgs.add(element);
        }
        return bsgs;
    }

    public static List<BSGSElement> createAntisymmetricGroupBSGS(int degree) {
        if (degree == 0) {
            throw new IllegalArgumentException("Degree = 0.");
        }
        if (degree <= 100) {
            List<BSGSElement> bsgs = CACHED_ANTISYMMETRIC_GROUPS[degree - 1];
            if (bsgs == null) {
                AlgorithmsBase.CACHED_ANTISYMMETRIC_GROUPS[degree - 1] = bsgs = AlgorithmsBase.convertToAntisymmetric(AlgorithmsBase.createSymmetricGroupBSGS(degree));
            }
            return bsgs;
        }
        return AlgorithmsBase.convertToAntisymmetric(AlgorithmsBase.createSymmetricGroupBSGS(degree));
    }

    private static ArrayList<BSGSElement> convertToAntisymmetric(ArrayList<BSGSElement> symmetricGroup) {
        ArrayList<BSGSCandidateElement> bsgs = AlgorithmsBase.asBSGSCandidatesList(symmetricGroup);
        for (BSGSCandidateElement c : bsgs) {
            ListIterator<Permutation> stabs = c.getStabilizerGeneratorsReference().listIterator();
            while (stabs.hasNext()) {
                Permutation p = stabs.next();
                if (p.parity() != 1) continue;
                stabs.set(Permutations.createPermutation(true, p.oneLine()));
            }
        }
        return AlgorithmsBase.asBSGSList(bsgs);
    }

    public static ArrayList<BSGSCandidateElement> asBSGSCandidatesList(List<? extends BSGSElement> BSGS) {
        ArrayList<BSGSCandidateElement> BSGSCandidates = new ArrayList<BSGSCandidateElement>(BSGS.size());
        for (BSGSElement bSGSElement : BSGS) {
            BSGSCandidates.add(bSGSElement.asBSGSCandidateElement());
        }
        return BSGSCandidates;
    }

    public static ArrayList<BSGSElement> asBSGSList(List<? extends BSGSElement> BSGSCandidate) {
        ArrayList<BSGSElement> BSGS = new ArrayList<BSGSElement>(BSGSCandidate.size());
        for (BSGSElement bSGSElement : BSGSCandidate) {
            BSGS.add(bSGSElement.asBSGSElement());
        }
        return BSGS;
    }

    public static int[] getBaseAsArray(List<? extends BSGSElement> BSGS) {
        return AlgorithmsBase.getBaseAsArray(BSGS, 0);
    }

    static int[] getBaseAsArray(List<? extends BSGSElement> BSGS, int from) {
        int[] base = new int[BSGS.size() - from];
        int size = BSGS.size();
        for (int i = from; i < size; ++i) {
            base[i - from] = BSGS.get((int)i).basePoint;
        }
        return base;
    }

    public static ArrayList<BSGSCandidateElement> clone(List<BSGSCandidateElement> BSGSCandidate) {
        ArrayList<BSGSCandidateElement> copy = new ArrayList<BSGSCandidateElement>(BSGSCandidate);
        ListIterator<BSGSCandidateElement> it = copy.listIterator();
        while (it.hasNext()) {
            it.set(it.next().clone());
        }
        return copy;
    }

    static {
        ArrayList<Permutation> gens = new ArrayList<Permutation>();
        gens.add(Permutations.getIdentityPermutation());
        TRIVIAL_BSGS.add(new BSGSCandidateElement(0, gens, 1).asBSGSElement());
        CACHED_SYMMETRIC_GROUPS = new ArrayList[100];
        CACHED_ANTISYMMETRIC_GROUPS = new ArrayList[100];
        CACHED_ALTERNATING_GROUPS = new ArrayList[100];
    }

    public static final class StripContainer {
        public final int terminationLevel;
        public final Permutation remainder;

        public StripContainer(int terminationLevel, Permutation remainder) {
            this.terminationLevel = terminationLevel;
            this.remainder = remainder;
        }
    }
}

