/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.graph;

import cc.redberry.core.graph.GraphType;
import cc.redberry.core.graph.PrimitiveSubgraph;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.ProductContent;
import cc.redberry.core.tensor.StructureOfContractions;
import cc.redberry.core.utils.BitArray;
import cc.redberry.core.utils.IntArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;

public final class PrimitiveSubgraphPartition {
    private final ProductContent pc;
    private final StructureOfContractions fcs;
    private final int size;
    private final IndexType type;
    private final PrimitiveSubgraph[] partition;
    private final BitArray used;
    private static final int BRANCHING = -3;
    private static final int NO_LINKS = -2;
    private static final int NOT_INITIALIZED = -4;
    private static final int DUMMY_PIVOT = -5;
    private static final int[] DUMMY = new int[]{-5, -5};

    public PrimitiveSubgraphPartition(ProductContent productContent, IndexType type) {
        this.pc = productContent;
        this.fcs = this.pc.getStructureOfContractions();
        this.size = this.pc.size();
        this.type = type;
        this.used = new BitArray(this.size);
        this.partition = this.calculatePartition();
    }

    public PrimitiveSubgraph[] getPartition() {
        return (PrimitiveSubgraph[])this.partition.clone();
    }

    public static PrimitiveSubgraph[] calculatePartition(Product p, IndexType type) {
        return new PrimitiveSubgraphPartition((ProductContent)p.getContent(), (IndexType)type).partition;
    }

    public static PrimitiveSubgraph[] calculatePartition(ProductContent p, IndexType type) {
        return new PrimitiveSubgraphPartition((ProductContent)p, (IndexType)type).partition;
    }

    private PrimitiveSubgraph[] calculatePartition() {
        ArrayList<PrimitiveSubgraph> subgraphs = new ArrayList<PrimitiveSubgraph>();
        for (int pivot = 0; pivot < this.size; ++pivot) {
            if (this.pc.get(pivot).getIndices().size(this.type) == 0 || this.used.get(pivot)) continue;
            subgraphs.add(this.calculateComponent(pivot));
        }
        return subgraphs.toArray(new PrimitiveSubgraph[subgraphs.size()]);
    }

    private PrimitiveSubgraph calculateComponent(int pivot) {
        int[] right;
        ArrayDeque<Integer> positions = new ArrayDeque<Integer>();
        positions.add(pivot);
        int[] left = right = this.getLinks(pivot);
        assert (left[0] != -2 || left[1] != -2);
        if (left[0] == -3 || left[1] == -3) {
            return this.processGraph(pivot);
        }
        if (left[0] == left[1] && left[0] == pivot) {
            this.used.set(pivot);
            return new PrimitiveSubgraph(GraphType.Cycle, new int[]{pivot});
        }
        int lastLeftPivot = -4;
        int lastRightPivot = -4;
        while (left != DUMMY || right != DUMMY) {
            if (left[0] == -3 || left[1] == -3 || right[0] == -3 || right[1] == -3) {
                return this.processGraph(pivot);
            }
            int leftPivot = left[0];
            int rightPivot = right[1];
            assert (leftPivot < 0 || !this.used.get(leftPivot));
            assert (rightPivot < 0 || !this.used.get(rightPivot));
            if (leftPivot == -2 || leftPivot == -1) {
                leftPivot = -5;
            }
            if (rightPivot == -2 || rightPivot == -1) {
                rightPivot = -5;
            }
            if (leftPivot >= 0 && leftPivot == lastRightPivot) {
                assert (rightPivot == lastLeftPivot);
                return new PrimitiveSubgraph(GraphType.Cycle, this.deque2array(positions));
            }
            if (leftPivot >= 0) {
                positions.addFirst(leftPivot);
            }
            if (leftPivot >= 0 && leftPivot == rightPivot) {
                left = this.getLinks(leftPivot);
                if (left[0] == -3 || left[1] == -3) {
                    return this.processGraph(pivot);
                }
                return new PrimitiveSubgraph(GraphType.Cycle, this.deque2array(positions));
            }
            if (rightPivot >= 0) {
                positions.addLast(rightPivot);
            }
            lastLeftPivot = leftPivot;
            lastRightPivot = rightPivot;
            left = this.getLinks(leftPivot);
            right = this.getLinks(rightPivot);
        }
        return new PrimitiveSubgraph(GraphType.Line, this.deque2array(positions));
    }

    private int[] deque2array(ArrayDeque<Integer> deque) {
        int[] arr = new int[deque.size()];
        int i = -1;
        for (Integer ii : deque) {
            arr[++i] = ii;
            this.used.set(ii);
        }
        return arr;
    }

    private int[] getLinks(int pivot) {
        if (pivot == -5) {
            return DUMMY;
        }
        assert (pivot >= 0);
        int[] links = new int[]{-4, -4};
        long[] contractions = this.fcs.contractions[pivot];
        Indices indices = this.pc.get(pivot).getIndices();
        for (int i = contractions.length - 1; i >= 0; --i) {
            int index = indices.get(i);
            if (IndicesUtils.getType(index) != this.type.getType()) continue;
            int toTensorIndex = StructureOfContractions.getToTensorIndex(contractions[i]);
            int state = 1 - IndicesUtils.getStateInt(index);
            if (links[state] >= -1 && links[state] != toTensorIndex) {
                links[state] = -3;
            }
            if (links[state] != -4) continue;
            links[state] = toTensorIndex;
        }
        if (links[0] == -4) {
            links[0] = -2;
        }
        if (links[1] == -4) {
            links[1] = -2;
        }
        return links;
    }

    private PrimitiveSubgraph processGraph(int pivot) {
        IntArrayList positions = new IntArrayList();
        positions.add(pivot);
        IntArrayList stack = new IntArrayList();
        stack.push(pivot);
        this.used.set(pivot);
        while (!stack.isEmpty()) {
            int currentPivot = stack.pop();
            Indices indices = this.pc.get(currentPivot).getIndices();
            long[] contractions = this.fcs.contractions[currentPivot];
            for (int i = contractions.length - 1; i >= 0; --i) {
                int toTensorIndex;
                int index = indices.get(i);
                if (IndicesUtils.getType(index) != this.type.getType() || (toTensorIndex = StructureOfContractions.getToTensorIndex(contractions[i])) == -1 || this.used.get(toTensorIndex)) continue;
                this.used.set(toTensorIndex);
                positions.add(toTensorIndex);
                stack.push(toTensorIndex);
            }
        }
        return new PrimitiveSubgraph(GraphType.Graph, positions.toArray());
    }
}

