/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.graph;

import cc.redberry.core.utils.ArraysUtils;
import java.util.ArrayDeque;
import java.util.Arrays;

public class GraphUtils {
    public static int[] calculateConnectedComponents(int[] _from, int[] _to, int vertices) {
        if (_from.length != _to.length) {
            throw new IllegalArgumentException();
        }
        if (_from.length == 0) {
            int[] result = new int[vertices + 1];
            for (int i = 0; i < vertices + 1; ++i) {
                result[i] = i;
            }
            return result;
        }
        int[] from = new int[_from.length << 1];
        int[] to = new int[_from.length << 1];
        System.arraycopy(_from, 0, from, 0, _from.length);
        System.arraycopy(_to, 0, to, 0, _from.length);
        System.arraycopy(_from, 0, to, _from.length, _from.length);
        System.arraycopy(_to, 0, from, _from.length, _from.length);
        ArraysUtils.quickSort(from, to);
        if (from[0] < 0 || from[from.length - 1] > vertices) {
            throw new IllegalArgumentException();
        }
        int[] fromIndex = new int[vertices];
        Arrays.fill(fromIndex, -1);
        int lastVertex = -1;
        for (int i = 0; i < from.length; ++i) {
            if (lastVertex == from[i]) continue;
            lastVertex = from[i];
            fromIndex[lastVertex] = i;
        }
        int[] components = new int[vertices + 1];
        Arrays.fill(components, -1);
        int currentComponent = -1;
        int m1 = 0;
        ArrayDeque<BreadthFirstPointer> stack = new ArrayDeque<BreadthFirstPointer>();
        do {
            components[m1] = ++currentComponent;
            if (fromIndex[m1] == -1) continue;
            stack.push(new BreadthFirstPointer(m1, fromIndex[m1]));
            while (!stack.isEmpty()) {
                BreadthFirstPointer pointer = (BreadthFirstPointer)stack.peek();
                if (pointer.edgePointer >= from.length || from[pointer.edgePointer++] != pointer.vertex) {
                    stack.pop();
                    continue;
                }
                int pointsTo = to[pointer.edgePointer - 1];
                if (components[pointsTo] == currentComponent) continue;
                assert (components[pointsTo] == -1);
                components[pointsTo] = currentComponent;
                if (fromIndex[pointsTo] == -1) continue;
                stack.push(new BreadthFirstPointer(pointsTo, fromIndex[pointsTo]));
            }
        } while ((m1 = GraphUtils.firstM1(components)) != vertices);
        components[vertices] = currentComponent + 1;
        return components;
    }

    private static int firstM1(int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != -1) continue;
            return i;
        }
        return -1;
    }

    public static int componentSize(int vertex, int[] components) {
        if (vertex > components.length - 1) {
            throw new IndexOutOfBoundsException();
        }
        int componentCount = components[vertex];
        int count = 0;
        for (int i = 0; i < components.length; ++i) {
            if (components[i] != componentCount) continue;
            ++count;
        }
        return count;
    }

    private static final class BreadthFirstPointer {
        final int vertex;
        int edgePointer;

        public BreadthFirstPointer(int node, int edgePointer) {
            this.vertex = node;
            this.edgePointer = edgePointer;
        }
    }
}

