/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context.defaults;

import cc.redberry.core.context.IndexConverterException;
import cc.redberry.core.context.IndexSymbolConverter;
import cc.redberry.core.context.OutputFormat;

public final class LatinUpperCaseConverter
implements IndexSymbolConverter {
    public static final byte TYPE = 1;
    public static final LatinUpperCaseConverter INSTANCE = new LatinUpperCaseConverter();

    private LatinUpperCaseConverter() {
    }

    @Override
    public boolean applicableToSymbol(String symbol) {
        char sym;
        return symbol.length() == 1 && (sym = symbol.charAt(0)) >= 'A' && sym <= 'Z';
    }

    @Override
    public int getCode(String symbol) {
        return symbol.charAt(0) - 65;
    }

    @Override
    public String getSymbol(int code, OutputFormat mode) throws IndexConverterException {
        int number = code + 65;
        if (number > 90) {
            throw new IndexConverterException();
        }
        return Character.toString((char)number);
    }

    @Override
    public byte getType() {
        return 1;
    }

    @Override
    public int maxNumberOfSymbols() {
        return 25;
    }
}

