/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context.defaults;

import cc.redberry.core.context.IndexConverterException;
import cc.redberry.core.context.IndexSymbolConverter;
import cc.redberry.core.context.OutputFormat;

public final class IndexWithStrokeConverter
implements IndexSymbolConverter {
    private final IndexSymbolConverter converter;
    private final byte numberOfStrokes;
    private final String strokesString;

    public IndexWithStrokeConverter(IndexSymbolConverter converter, byte numberOfStrokes) {
        if (numberOfStrokes + converter.getType() > 127) {
            throw new IllegalArgumentException("Too much strokes.");
        }
        this.converter = converter;
        this.numberOfStrokes = numberOfStrokes;
        StringBuilder sb = new StringBuilder();
        while (true) {
            byte by = numberOfStrokes;
            numberOfStrokes = (byte)(numberOfStrokes - 1);
            if (by <= 0) break;
            sb.append('\'');
        }
        this.strokesString = sb.toString();
    }

    private String getStrokes(String symbol) {
        return symbol.substring(symbol.length() - this.numberOfStrokes);
    }

    private String getBase(String symbol) {
        return symbol.substring(0, symbol.length() - this.numberOfStrokes);
    }

    @Override
    public boolean applicableToSymbol(String symbol) {
        if (symbol.length() <= this.strokesString.length()) {
            return false;
        }
        if (!this.strokesString.equals(this.getStrokes(symbol))) {
            return false;
        }
        return this.converter.applicableToSymbol(this.getBase(symbol));
    }

    @Override
    public String getSymbol(int code, OutputFormat mode) throws IndexConverterException {
        return this.converter.getSymbol(code, mode) + this.strokesString;
    }

    @Override
    public int getCode(String symbol) throws IndexConverterException {
        return this.converter.getCode(this.getBase(symbol));
    }

    @Override
    public int maxNumberOfSymbols() {
        return this.converter.maxNumberOfSymbols();
    }

    @Override
    public byte getType() {
        return (byte)(4 + this.numberOfStrokes * this.converter.getType());
    }
}

