/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context;

import cc.redberry.core.context.IndexConverterException;
import cc.redberry.core.context.IndexSymbolConverter;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.IndexType;
import gnu.trove.set.hash.TByteHashSet;

public final class IndexConverterManager {
    public static final IndexConverterManager DEFAULT = new IndexConverterManager(IndexType.getAllConverters());
    private final IndexSymbolConverter[] converters;

    public IndexConverterManager(IndexSymbolConverter[] converters) {
        TByteHashSet types = new TByteHashSet(converters.length);
        for (IndexSymbolConverter converter : converters) {
            if (types.contains(converter.getType())) {
                throw new IllegalArgumentException("Several converters for same type.");
            }
            types.add(converter.getType());
        }
        this.converters = converters;
    }

    public String getSymbol(int code, OutputFormat outputFormat) {
        byte typeId = (byte)(code >>> 24 & 0x7F);
        int number = code & 0xFFFF;
        try {
            for (IndexSymbolConverter converter : this.converters) {
                if (converter.getType() != typeId) continue;
                return converter.getSymbol(number, outputFormat);
            }
            throw new IllegalArgumentException("No appropriate converter for typeId 0x" + Integer.toHexString(typeId));
        }
        catch (IndexConverterException e) {
            throw new IllegalArgumentException("Index 0x" + Integer.toHexString(code) + " conversion error");
        }
    }

    public int getCode(String index) {
        try {
            for (IndexSymbolConverter converter : this.converters) {
                if (!converter.applicableToSymbol(index)) continue;
                return converter.getCode(index) & 0xFFFF | (converter.getType() & 0x7F) << 24;
            }
            throw new IllegalArgumentException("No available converters for such symbol : " + index);
        }
        catch (IndexConverterException e) {
            throw new IllegalArgumentException("No available converters for such symbol : " + index);
        }
    }
}

