/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context;

import cc.redberry.core.context.ContextManager;
import cc.redberry.core.context.ContextSettings;
import cc.redberry.core.context.IndexConverterManager;
import cc.redberry.core.context.NameDescriptor;
import cc.redberry.core.context.NameManager;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.indices.StructureOfIndices;
import cc.redberry.core.parser.ParseManager;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.utils.BitArray;
import cc.redberry.core.utils.OutputPort;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.math3.random.RandomGenerator;

public final class Context {
    private final NameManager nameManager;
    private OutputFormat defaultOutputFormat;
    private final IndexConverterManager converterManager;
    private final ParseManager parseManager;
    private final BitArray metricTypesBits = new BitArray(128);
    private final Set<IndexType> metricTypes;
    private final Set<IndexType> matrixTypes;
    private final GeneratedParameters defaultGeneratedParameters = new GeneratedParameters();

    public Context(ContextSettings contextSettings) {
        this.parseManager = new ParseManager(contextSettings.getParser());
        this.converterManager = contextSettings.getConverterManager();
        this.nameManager = new NameManager(contextSettings.getNameManagerSeed(), contextSettings.getKronecker(), contextSettings.getMetricName());
        this.defaultOutputFormat = contextSettings.getDefaultOutputFormat();
        EnumSet<IndexType> metricTypes = EnumSet.noneOf(IndexType.class);
        EnumSet<IndexType> matrixTypes = EnumSet.allOf(IndexType.class);
        for (IndexType type : contextSettings.getMetricTypes()) {
            matrixTypes.remove((Object)type);
            metricTypes.add(type);
            this.metricTypesBits.set(type.getType());
        }
        this.metricTypes = Collections.unmodifiableSet(metricTypes);
        this.matrixTypes = Collections.unmodifiableSet(matrixTypes);
    }

    public Set<IndexType> getMetricTypes() {
        return this.metricTypes;
    }

    public Set<IndexType> getMatrixTypes() {
        return this.matrixTypes;
    }

    public synchronized void resetTensorNames() {
        this.nameManager.reset();
    }

    public synchronized void resetTensorNames(long seed) {
        this.nameManager.reset(seed);
    }

    public void setDefaultOutputFormat(OutputFormat defaultOutputFormat) {
        this.defaultOutputFormat = defaultOutputFormat;
    }

    public OutputFormat getDefaultOutputFormat() {
        return this.defaultOutputFormat;
    }

    public IndexConverterManager getIndexConverterManager() {
        return this.converterManager;
    }

    public NameManager getNameManager() {
        return this.nameManager;
    }

    public NameDescriptor getNameDescriptor(int nameId) {
        return this.nameManager.getNameDescriptor(nameId);
    }

    public String getKroneckerName() {
        return this.nameManager.getKroneckerName();
    }

    public String getMetricName() {
        return this.nameManager.getMetricName();
    }

    public void setMetricName(String name) {
        this.nameManager.setMetricName(name);
    }

    public void setKroneckerName(String name) {
        this.nameManager.setKroneckerName(name);
    }

    public boolean isKronecker(SimpleTensor t) {
        return this.nameManager.isKroneckerOrMetric(t.getName()) && !IndicesUtils.haveEqualStates(t.getIndices().get(0), t.getIndices().get(1));
    }

    public boolean isMetric(SimpleTensor t) {
        return this.nameManager.isKroneckerOrMetric(t.getName()) && IndicesUtils.haveEqualStates(t.getIndices().get(0), t.getIndices().get(1));
    }

    public boolean isKroneckerOrMetric(SimpleTensor t) {
        return this.nameManager.isKroneckerOrMetric(t.getName());
    }

    public ParseManager getParseManager() {
        return this.parseManager;
    }

    public boolean isMetric(byte type) {
        return this.metricTypesBits.get(type);
    }

    public SimpleTensor createKronecker(int index1, int index2) {
        byte type = IndicesUtils.getType(index1);
        if (type != IndicesUtils.getType(index2) || IndicesUtils.getRawStateInt(index1) == IndicesUtils.getRawStateInt(index2)) {
            throw new IllegalArgumentException("This is not kronecker indices!");
        }
        if (!this.isMetric(type) && IndicesUtils.getState(index2)) {
            int t = index1;
            index1 = index2;
            index2 = t;
        }
        SimpleIndices indices = IndicesFactory.createSimple(null, index1, index2);
        NameDescriptor nd = this.nameManager.mapNameDescriptor(this.nameManager.getKroneckerName(), StructureOfIndices.create(indices));
        int name = nd.getId();
        return Tensors.simpleTensor(name, indices);
    }

    public SimpleTensor createMetric(int index1, int index2) {
        byte type = IndicesUtils.getType(index1);
        if (type != IndicesUtils.getType(index2) || !IndicesUtils.haveEqualStates(index1, index2) || !this.metricTypesBits.get(type)) {
            throw new IllegalArgumentException("Not metric indices.");
        }
        SimpleIndices indices = IndicesFactory.createSimple(null, index1, index2);
        NameDescriptor nd = this.nameManager.mapNameDescriptor(this.nameManager.getMetricName(), StructureOfIndices.create(indices));
        int name = nd.getId();
        return Tensors.simpleTensor(name, indices);
    }

    public SimpleTensor createMetricOrKronecker(int index1, int index2) {
        if (IndicesUtils.getRawStateInt(index1) == IndicesUtils.getRawStateInt(index2)) {
            return this.createMetric(index1, index2);
        }
        return this.createKronecker(index1, index2);
    }

    public SimpleTensor generateNewSymbol() {
        NameDescriptor nameDescriptor = this.nameManager.generateNewSymbolDescriptor();
        return Tensors.simpleTensor(nameDescriptor.getId(), IndicesFactory.EMPTY_SIMPLE_INDICES);
    }

    public OutputPort<SimpleTensor> getDefaultParametersGenerator() {
        return this.defaultGeneratedParameters;
    }

    public RandomGenerator getRandomGenerator() {
        return this.nameManager.getRandomGenerator();
    }

    public static Context get() {
        return ContextManager.getCurrentContext();
    }

    private final class GeneratedParameters
    implements OutputPort<SimpleTensor> {
        private GeneratedParameters() {
        }

        @Override
        public SimpleTensor take() {
            return Context.this.generateNewSymbol();
        }
    }
}

