/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.combinatorics;

import cc.redberry.core.combinatorics.IntCombinationsGenerator;
import cc.redberry.core.combinatorics.IntCombinatorialGenerator;
import cc.redberry.core.combinatorics.IntCombinatorialPort;
import cc.redberry.core.combinatorics.IntPermutationsGenerator;

public final class IntCombinationPermutationGenerator
extends IntCombinatorialGenerator
implements IntCombinatorialPort {
    private final int[] permutation;
    private final int[] combination;
    final int[] combinationPermutation;
    private final IntPermutationsGenerator permutationsGenerator;
    private final IntCombinationsGenerator combinationsGenerator;
    private final int k;

    public IntCombinationPermutationGenerator(int n, int k) {
        this.k = k;
        this.combinationsGenerator = new IntCombinationsGenerator(n, k);
        this.combination = this.combinationsGenerator.combination;
        this.permutationsGenerator = new IntPermutationsGenerator(k);
        this.permutation = this.permutationsGenerator.permutation;
        this.combinationPermutation = new int[k];
        this.combinationsGenerator.next();
        System.arraycopy(this.combination, 0, this.combinationPermutation, 0, k);
    }

    @Override
    public int[] take() {
        return this.hasNext() ? this.next() : null;
    }

    @Override
    public boolean hasNext() {
        return this.combinationsGenerator.hasNext() || this.permutationsGenerator.hasNext();
    }

    @Override
    public int[] next() {
        if (!this.permutationsGenerator.hasNext()) {
            this.permutationsGenerator.reset();
            this.combinationsGenerator.next();
        }
        this.permutationsGenerator.next();
        for (int i = 0; i < this.k; ++i) {
            this.combinationPermutation[i] = this.combination[this.permutation[i]];
        }
        return this.combinationPermutation;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void reset() {
        this.permutationsGenerator.reset();
        this.combinationsGenerator.reset();
        this.combinationsGenerator.next();
    }

    @Override
    public int[] getReference() {
        return this.combinationPermutation;
    }
}

