/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.worker.impl.mandel;

import org.homedns.dade.jcgrid.WorkRequest;

public class MandelWorkRequest
extends WorkRequest {
    private static final long serialVersionUID = 1L;
    private short maxIter;
    private double xOrig;
    private double yOrig;
    private double dx;
    private double dy;
    private int xOffset;
    private int yOffset;
    private int xStep;
    private int yStep;

    public MandelWorkRequest(String nameVal, int idVal, short maxIterVal, double xOrigVal, double yOrigVal, double dxVal, double dyVal, int xStepVal, int yStepVal) {
        super(nameVal, idVal);
        this.maxIter = maxIterVal;
        this.xOrig = xOrigVal;
        this.yOrig = yOrigVal;
        this.dx = dxVal;
        this.dy = dyVal;
        this.xStep = xStepVal;
        this.yStep = yStepVal;
    }

    public int fragmentPerFrame() {
        int xCount = (int)Math.ceil((double)this.xStep / 96.0);
        int yCount = (int)Math.ceil((double)this.yStep / 96.0);
        return xCount * yCount;
    }

    public MandelWorkRequest[] split() {
        int xCount = (int)Math.ceil((double)this.xStep / 96.0);
        int yCount = (int)Math.ceil((double)this.yStep / 96.0);
        int count = xCount * yCount;
        MandelWorkRequest[] mfs = new MandelWorkRequest[count];
        int i = 0;
        for (int y = 0; y < yCount; ++y) {
            int fh = y == yCount - 1 ? this.yStep - y * 96 : 96;
            for (int x = 0; x < xCount; ++x) {
                int fw = x == xCount - 1 ? this.xStep - x * 96 : 96;
                MandelWorkRequest mf = new MandelWorkRequest(this.getSessionName(), i, this.maxIter, this.xOrig + this.dx * (double)x * 96.0, this.yOrig + this.dy * (double)y * 96.0, this.dx, this.dy, fw, fh);
                mf.setXOffset(x * 96);
                mf.setYOffset(y * 96);
                mfs[i++] = mf;
            }
        }
        return mfs;
    }

    public String toString() {
        return "MandelWorkRequest[" + this.maxIter + "," + this.xOrig + "," + this.yOrig + "," + this.dx + "," + this.dy + "," + this.xOffset + "," + this.yOffset + "," + this.xStep + "," + this.yStep + "]";
    }

    public void setMaxIter(short i) {
        this.maxIter = i;
    }

    public short getMaxIter() {
        return this.maxIter;
    }

    public void setXOrig(double xo) {
        this.xOrig = xo;
    }

    public double getXOrig() {
        return this.xOrig;
    }

    public void setYOrig(double yo) {
        this.yOrig = yo;
    }

    public double getYOrig() {
        return this.yOrig;
    }

    public void setDX(double d) {
        this.dx = d;
    }

    public double getDX() {
        return this.dx;
    }

    public void setDY(double d) {
        this.dy = d;
    }

    public double getDY() {
        return this.dy;
    }

    public void setXStep(int xs) {
        this.xStep = xs;
    }

    public int getXStep() {
        return this.xStep;
    }

    public void setYStep(int ys) {
        this.yStep = ys;
    }

    public int getYStep() {
        return this.yStep;
    }

    public void setXOffset(int xo) {
        this.xOffset = xo;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setYOffset(int yo) {
        this.yOffset = yo;
    }

    public int getYOffset() {
        return this.yOffset;
    }
}

