/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.vfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.message.GridMessage;
import org.homedns.dade.jcgrid.message.GridMessageVFSSessionBegin;
import org.homedns.dade.jcgrid.message.GridMessageVFSSessionEnd;
import org.homedns.dade.jcgrid.message.GridMessageVFSSessionFileRequest;
import org.homedns.dade.jcgrid.message.GridMessageVFSSessionFileResult;
import org.homedns.dade.jcgrid.util.GridMessageChannel;
import org.homedns.dade.jcgrid.vfs.vfsNode;

public class vfsSession
implements Serializable {
    private static final String className = vfsSession.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private static final long serialVersionUID = 1L;
    private static final String[] hexMap = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    private String path;
    private Hashtable fileList;
    private long size;
    private boolean inUse;

    public vfsSession(String dir) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start vfsSession(" + dir + ")"));
        }
        this.path = dir;
        File pathDir = new File(this.path);
        if (!pathDir.exists()) {
            pathDir.mkdirs();
        }
        this.fileList = null;
        this.inUse = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)"End vfsSession()");
        }
    }

    private void deleteImpl(File root) throws IOException {
        boolean res;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start deleteImpl(" + root + ")"));
        }
        String[] l = root.list();
        for (int i = 0; i < l.length; ++i) {
            String p = root.getAbsolutePath() + File.separator + l[i];
            File f = new File(p);
            if (f.isDirectory()) {
                log.warn((Object)("VFS session removing directory: " + p));
                this.deleteImpl(f);
                f.delete();
                continue;
            }
            f.delete();
        }
        boolean bl = res = l.length == 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)"End deleteImpl()");
        }
    }

    public void delete() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start delete()");
        }
        File f = new File(this.path);
        this.deleteImpl(f);
        if (log.isDebugEnabled()) {
            log.debug((Object)"End delete()");
        }
    }

    private boolean deleteEmptyDirectoriesImpl(File root) throws IOException {
        boolean res;
        String[] l;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start deleteEmptyDirectoriesImpl(" + root + ")"));
        }
        if ((l = root.list()) == null) {
            return true;
        }
        for (int i = 0; i < l.length; ++i) {
            String p = root.getAbsolutePath() + File.separator + l[i];
            File f = new File(p);
            if (!f.isDirectory() || !this.deleteEmptyDirectoriesImpl(f)) continue;
            log.warn((Object)("VFS session removing empty directory: " + p));
            f.delete();
        }
        boolean bl = res = l.length == 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("End deleteEmptyDirectoriesImpl(" + res + ")"));
        }
        return res;
    }

    public void deleteEmptyDirectories() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start deleteEmptyDirectories()");
        }
        File f = new File(this.path);
        this.deleteEmptyDirectoriesImpl(f);
        if (log.isDebugEnabled()) {
            log.debug((Object)"End deleteEmptyDirectories()");
        }
    }

    public void removeNode(String name) {
        vfsNode n;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start removeNode(" + name + ")"));
        }
        if ((n = (vfsNode)this.fileList.get(name)) != null) {
            this.size -= n.getSize();
            this.fileList.remove(name);
        }
        File f = new File(this.path + name);
        f.delete();
        if (log.isDebugEnabled()) {
            log.debug((Object)"End removeNode()");
        }
    }

    private String toHexString(byte[] data) {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("Start toHexString(" + data + ")"));
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int l = (data[i] & 0xF0) >> 4;
            int r = data[i] & 0xF;
            result.append(hexMap[l] + hexMap[r]);
        }
        String res = result.toString();
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End toHexString(" + res + ")"));
        }
        return res;
    }

    private String generateUniqueID(File f) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
        int bytesRead;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start generateUniqueID(" + f + ")"));
        }
        byte[] buf = new byte[8192];
        FileInputStream fis = new FileInputStream(f);
        MessageDigest md5 = MessageDigest.getInstance("MD5", "SUN");
        while ((bytesRead = fis.read(buf)) != -1) {
            md5.update(buf, 0, bytesRead);
        }
        fis.close();
        String res = this.toHexString(md5.digest());
        if (log.isDebugEnabled()) {
            log.debug((Object)("End generateUniqueID(" + res + ")"));
        }
        return res;
    }

    public void addNode(String name) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start addNode(" + name + ")"));
        }
        File f = new File(this.path + name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("  Name: " + name));
        }
        String id = this.generateUniqueID(new File(this.path + name));
        if (log.isDebugEnabled()) {
            log.debug((Object)("  MD5: " + id));
        }
        long s = f.length();
        if (log.isDebugEnabled()) {
            log.debug((Object)("  Size: " + s));
        }
        this.fileList.put(name, new vfsNode(name, id, s));
        this.size += s;
        if (log.isDebugEnabled()) {
            log.debug((Object)"End addNode()");
        }
    }

    public Vector notIncludedNodes(vfsSession s) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start notIncludedNodes(" + s + ")"));
        }
        Vector<String> v = new Vector<String>();
        Iterator i = this.fileList.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            vfsNode n = (vfsNode)this.fileList.get(name);
            if (s.includes(n)) continue;
            v.add(name);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("End notIncludedNodes(" + v + ")"));
        }
        return v;
    }

    public boolean includes(vfsNode node) {
        vfsNode n;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start includes(" + node + ")"));
        }
        boolean res = (n = (vfsNode)this.fileList.get(node.getName())) == null ? false : n.equals(node);
        if (log.isDebugEnabled()) {
            log.debug((Object)("End includes(" + res + ")"));
        }
        return res;
    }

    public void syncVFSSession(GridMessageChannel serverChannel) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start syncVFSSession(" + serverChannel + ")"));
        }
        serverChannel.send(new GridMessageVFSSessionBegin(this));
        while (true) {
            GridMessage msg = serverChannel.recv();
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Received grid message: " + msg));
            }
            if (msg instanceof GridMessageVFSSessionEnd) {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"  Received VFS session end");
                break;
            }
            if (msg instanceof GridMessageVFSSessionFileRequest) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  Received VFS session file request");
                }
                String n = ((GridMessageVFSSessionFileRequest)msg).getName();
                log.warn((Object)("VFS session sending: " + n));
                File f = new File(this.path + n);
                long fsize = f.length();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  File size: " + fsize));
                }
                byte[] data = new byte[(int)fsize];
                FileInputStream fis = new FileInputStream(f);
                fis.read(data);
                fis.close();
                serverChannel.send(new GridMessageVFSSessionFileResult(data));
                continue;
            }
            log.warn((Object)("Unknown message in ClientHandlerThread.run()/vfsSession: " + msg));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End syncVFSSession()");
        }
    }

    private void scann(File root, int realRootPathIndex) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start scann(" + root + "," + realRootPathIndex + ")"));
        }
        String[] l = root.list();
        for (int i = 0; i < l.length; ++i) {
            String p = root.getAbsolutePath() + File.separator + l[i];
            log.warn((Object)("  VFS scanning: " + p));
            File f = new File(p);
            if (f.isDirectory()) {
                this.scann(f, realRootPathIndex);
                continue;
            }
            if (f.isFile()) {
                String name = p.substring(realRootPathIndex);
                this.addNode(name);
                continue;
            }
            log.warn((Object)("    VFS " + l[i] + " is not a normal file"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End scann()");
        }
    }

    public void start() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start start()");
        }
        this.fileList = new Hashtable();
        this.size = 0L;
        log.warn((Object)("VFS starting on path: " + this.path));
        File f = new File(this.path);
        if (!f.exists()) {
            throw new Exception("The path " + this.path + " doesn't exist");
        }
        this.scann(f, f.getAbsolutePath().length());
        if (log.isDebugEnabled()) {
            log.debug((Object)"End start()");
        }
    }

    public vfsNode getNode(String name) {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("Start getNode(" + name + ")"));
        }
        vfsNode n = (vfsNode)this.fileList.get(name);
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getNode(" + n + ")"));
        }
        return n;
    }

    public String getPath() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getPath()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getPath(" + this.path + ")"));
        }
        return this.path;
    }

    public long getSize() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getSize()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getSize(" + this.size + ")"));
        }
        return this.size;
    }

    public void setInUse(boolean use) {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("Start setInUse(" + use + ")"));
        }
        this.inUse = use;
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"End setInUse()");
        }
    }

    public boolean getInUse() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getInUse()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getInUse(" + this.inUse + ")"));
        }
        return this.inUse;
    }
}

