/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.message.GridMessage;
import org.homedns.dade.jcgrid.util.GridMessageChannel;

public class GridMessageGZIPChannel
implements GridMessageChannel {
    private static final String className = GridMessageGZIPChannel.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private Socket socket;
    private InputStream is;
    private OutputStream os;

    public GridMessageGZIPChannel(Socket s) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start GridMessageGZIPChannel(" + s + ")"));
        }
        this.socket = s;
        this.is = this.socket.getInputStream();
        this.os = this.socket.getOutputStream();
        if (log.isDebugEnabled()) {
            log.debug((Object)"End GridMessageGZIPChannel()");
        }
    }

    private int readPacket(byte[] buf) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start readPacket(" + buf + ")"));
        }
        int base = 0;
        while (buf.length - base > 0) {
            int res = this.is.read(buf, base, buf.length - base);
            if (res == -1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"End readPacket(-1)");
                }
                return -1;
            }
            base += res;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("End readPacket(" + buf.length + ")"));
        }
        return buf.length;
    }

    public GridMessage recv() throws Exception {
        byte[] bufData;
        byte[] bufSize;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start recv()");
        }
        if (this.readPacket(bufSize = new byte[4]) != 4) {
            throw new Exception("Error reading a message header (size field)");
        }
        int size = bufSize[0] & 0xFF | (bufSize[1] & 0xFF) << 8 | (bufSize[2] & 0xFF) << 16 | (bufSize[3] & 0xFF) << 24;
        if (log.isDebugEnabled()) {
            log.debug((Object)("  Packet size: " + size));
        }
        if (this.readPacket(bufData = new byte[size]) != size) {
            throw new Exception("Error reading a message (payload field)");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bufData);
        GZIPInputStream gis = new GZIPInputStream(bis);
        ObjectInputStream ois = new ObjectInputStream(gis);
        GridMessage msg = (GridMessage)ois.readObject();
        if (log.isDebugEnabled()) {
            log.debug((Object)("End recv(" + msg + ")"));
        }
        return msg;
    }

    public GridMessage recv(int timeout) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start recv(" + timeout + ")"));
        }
        this.socket.setSoTimeout(timeout);
        GridMessage msg = this.recv();
        this.socket.setSoTimeout(0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("End recv(" + msg + ")"));
        }
        return msg;
    }

    public void send(GridMessage msg) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start send(" + msg + ")"));
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(msg);
        oos.close();
        byte[] obj = bos.toByteArray();
        if (log.isDebugEnabled()) {
            log.debug((Object)("  Array size: " + obj.length));
        }
        bos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(bos);
        gos.write(obj);
        gos.close();
        obj = bos.toByteArray();
        if (log.isDebugEnabled()) {
            log.debug((Object)("  Array compressed size: " + obj.length));
        }
        byte[] buf = new byte[]{(byte)(obj.length & 0xFF), (byte)((obj.length & 0xFF00) >> 8), (byte)((obj.length & 0xFF0000) >> 16), (byte)((obj.length & 0xFF000000) >> 24)};
        this.os.write(buf);
        this.os.write(obj);
        this.os.flush();
        if (log.isDebugEnabled()) {
            log.debug((Object)"End send()");
        }
    }

    public void close() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start close()");
        }
        this.is.close();
        this.os.close();
        this.socket.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)"End close()");
        }
    }
}

