/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.util.ByteVector;

public class ConsoleCmd {
    private static final String className = ConsoleCmd.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private String[] cmd;
    private Process proc;
    private byte[] stdin;
    private byte[] stdout;
    private byte[] stderr;
    private File curDir;

    public ConsoleCmd(String[] cmdVal, byte[] stdinVal, String dir) {
        this.stdin = stdinVal;
        this.cmd = cmdVal;
        this.proc = null;
        this.curDir = dir == null ? null : new File(dir);
    }

    public ConsoleCmd(String[] cmdVal, byte[] stdinVal) {
        this(cmdVal, stdinVal, null);
    }

    public ConsoleCmd(String[] cmdVal) {
        this(cmdVal, null, null);
    }

    public String getCmdLine() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < this.cmd.length; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(this.cmd[i]);
        }
        return sb.toString();
    }

    public byte[] getStdOut() {
        return this.stdout;
    }

    public byte[] getStdErr() {
        return this.stderr;
    }

    public int run() throws IOException, InterruptedException {
        this.proc = this.curDir == null ? Runtime.getRuntime().exec(this.cmd) : Runtime.getRuntime().exec(this.cmd, null, this.curDir);
        OutputStream si = this.proc.getOutputStream();
        InputStream so = this.proc.getInputStream();
        InputStream se = this.proc.getErrorStream();
        WritterThread it = new WritterThread(si, this.stdin);
        it.start();
        ReaderThread ot = new ReaderThread(so);
        ot.start();
        ReaderThread et = new ReaderThread(se);
        et.start();
        int exitVal = this.proc.waitFor();
        it.join();
        ot.join();
        et.join();
        this.stdout = ot.getData();
        this.stderr = et.getData();
        return exitVal;
    }

    private class ReaderThread
    extends Thread {
        private InputStream is;
        private byte[] data;

        public ReaderThread(InputStream isVal) {
            this.is = new BufferedInputStream(isVal);
        }

        public void run() {
            try {
                this.data = ByteVector.readAll(this.is);
            }
            catch (Throwable ex) {
                log.warn((Object)"Exception in ConsoleCmd.ReaderThread.run()", ex);
            }
        }

        public byte[] getData() {
            return this.data;
        }
    }

    private class WritterThread
    extends Thread {
        private OutputStream os;
        private byte[] data;

        public WritterThread(OutputStream osVal, byte[] dataVal) {
            this.os = osVal;
            this.data = dataVal;
        }

        public void run() {
            try {
                if (this.data != null) {
                    this.os.write(this.data);
                    this.os.flush();
                }
                this.os.close();
            }
            catch (Throwable ex) {
                log.warn((Object)"Exception in ConsoleCmd.WritterThread.run()", ex);
            }
        }
    }
}

