/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.server;

import java.io.IOException;
import java.net.Socket;
import java.util.Iterator;
import org.homedns.dade.jcgrid.GridStats;
import org.homedns.dade.jcgrid.WorkerStats;
import org.homedns.dade.jcgrid.message.GridMessage;
import org.homedns.dade.jcgrid.message.GridMessageAdminGetGridStats;
import org.homedns.dade.jcgrid.message.GridMessageAdminGetWorkerStats;
import org.homedns.dade.jcgrid.message.GridMessageAdminGridStats;
import org.homedns.dade.jcgrid.message.GridMessageAdminWorkerStats;
import org.homedns.dade.jcgrid.server.GridServer;
import org.homedns.dade.jcgrid.server.HandlerThread;
import org.homedns.dade.jcgrid.server.HandlerThreads;
import org.homedns.dade.jcgrid.server.WorkerHandlerThread;

public class AdminHandlerThread
extends HandlerThread {
    public AdminHandlerThread(GridServer server, Socket socket) throws IOException {
        super("ADMIN", server, socket);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start AdminHandlerThread(" + server + "," + socket + ")"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End AdminHandlerThread()");
        }
    }

    protected void handleMsg(GridMessage msg) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start handleMsg()");
        }
        if (msg instanceof GridMessageAdminGetWorkerStats) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Received work request AdminGetWorkerStats");
            }
            HandlerThreads whs = this.gridServer.getWorkerHandlers();
            GridMessageAdminWorkerStats ws = new GridMessageAdminWorkerStats();
            Iterator i = whs.getSessionNames().iterator();
            while (i.hasNext()) {
                WorkerStats wstat;
                String name = (String)i.next();
                WorkerHandlerThread wht = (WorkerHandlerThread)whs.getConnectedHandler(name);
                if (wht == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("    Session name: " + wht.getSessionName()));
                }
                if ((wstat = wht.getStats()) == null) continue;
                ws.addStats(wstat);
            }
            this.handlerChannel.send(ws);
        } else if (msg instanceof GridMessageAdminGetGridStats) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Received work request AdminGetGridStats");
            }
            int workerCount = this.gridServer.getWorkerHandlers().getConnectedHandlerCount();
            int queueSize = this.gridServer.getRequestQueueSize();
            GridStats s = new GridStats(workerCount, queueSize);
            GridMessageAdminGridStats gs = new GridMessageAdminGridStats(s);
            this.handlerChannel.send(gs);
        } else {
            log.warn((Object)("Unknown message in AdminHandlerThread.handleMsg(): " + msg));
        }
    }
}

