/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.cmd.povray;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.Version;
import org.homedns.dade.jcgrid.client.GridNodeClientConfig;
import org.homedns.dade.jcgrid.cmd.MainCmd;
import org.homedns.dade.jcgrid.cmd.povray.RenderingWindow;
import org.homedns.dade.jcgrid.worker.impl.povray.POVRenderingClient;
import org.homedns.dade.jcgrid.worker.impl.povray.POVRenderingClientFeedback;
import org.homedns.dade.jcgrid.worker.impl.povray.POVRenderingFrame;
import org.homedns.dade.jcgrid.worker.impl.povray.POVWorkRequest;
import org.homedns.dade.jcgrid.worker.impl.povray.POVWorkResult;

public class JCGridClient {
    private static final String className = JCGridClient.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    public String iniFile = "jcgrid.ini";
    public String outputFile = "jcgrid-output.png";
    public int width = 320;
    public int height = 240;
    public int step = 64;
    public boolean hasAnimation = false;
    public int startFrame = -1;
    public int endFrame = -1;
    public String outputFormat = "png";
    public boolean hasRenderingWindow = true;

    public void doRendering(GridNodeClientConfig config, POVWorkRequest povwr) throws Exception {
        RenderingFeedback rfback = new RenderingFeedback();
        POVRenderingClient rc = this.hasAnimation ? new POVRenderingClient(config, rfback, povwr, this.step, this.startFrame, this.endFrame) : new POVRenderingClient(config, rfback, povwr, this.step);
        rc.start();
        rc.join();
    }

    public static void main(String[] args) {
        try {
            MainCmd.setUpLog4J("client", true);
            log.warn((Object)"-----------------------------------------------");
            log.warn((Object)("-- JCGridClient POVRay v" + Version.RELEASE));
            log.warn((Object)"-----------------------------------------------");
            JCGridClient client = new JCGridClient();
            GridNodeClientConfig config = new GridNodeClientConfig();
            Options options = new Options();
            options.addOption("f", true, "set the povray ini file");
            options.addOption("o", true, "set the povray output file");
            options.addOption("t", true, "set the povray output file format [i.e. png, ppm, jpg, etc.]");
            options.addOption("x", true, "set the povray output file width");
            options.addOption("y", true, "set the povray output file height");
            options.addOption("g", true, "set the povray image fragment size");
            options.addOption("r", false, "disable rendering window");
            options.addOption("b", true, "set the povray animation start frame");
            options.addOption("h", true, "set the povray animation end frame");
            try {
                CommandLine cmd = MainCmd.parseCommonOptions(options, config, args);
                if (cmd.hasOption("f")) {
                    client.iniFile = cmd.getOptionValue("f");
                }
                if (cmd.hasOption("o")) {
                    client.outputFile = cmd.getOptionValue("o");
                }
                if (cmd.hasOption("t")) {
                    client.outputFormat = cmd.getOptionValue("t");
                }
                if (cmd.hasOption("x")) {
                    client.width = Integer.parseInt(cmd.getOptionValue("x"));
                }
                if (cmd.hasOption("y")) {
                    client.height = Integer.parseInt(cmd.getOptionValue("y"));
                }
                if (cmd.hasOption("g")) {
                    client.step = Integer.parseInt(cmd.getOptionValue("g"));
                }
                if (cmd.hasOption("r")) {
                    client.hasRenderingWindow = false;
                }
                if (cmd.hasOption("b")) {
                    client.startFrame = Integer.parseInt(cmd.getOptionValue("b"));
                }
                if (cmd.hasOption("h")) {
                    client.endFrame = Integer.parseInt(cmd.getOptionValue("h"));
                }
                if (cmd.getArgs().length > 0) {
                    throw new Exception("Unknown command line option");
                }
                if (client.startFrame == -1 && client.endFrame != -1 || client.endFrame == -1 && client.startFrame != -1) {
                    throw new Exception("Both start and end animation frame must be set");
                }
                if (client.startFrame != -1 && client.endFrame != -1) {
                    client.hasAnimation = true;
                    if (client.endFrame < client.startFrame) {
                        throw new Exception("End animation frame must be greater than end animation frame");
                    }
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Error while parsing command line", (Throwable)ex);
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("JCGridClient", options);
                System.exit(0);
            }
            POVWorkRequest povwr = new POVWorkRequest(config.getSessionName(), 0, client.iniFile, client.width, client.height, 0, client.width - 1, 0, client.height - 1);
            povwr.setAnimationEnabled(client.hasAnimation);
            client.doRendering(config, povwr);
            log.warn((Object)"Done.");
        }
        catch (Exception ex) {
            log.warn((Object)"Error", (Throwable)ex);
            System.exit(0);
        }
    }

    public class RenderingFeedback
    implements POVRenderingClientFeedback {
        private RenderingWindow rWin = null;
        private BufferedImage renderingFrameBuffer = null;
        private Graphics2D renderingFrameBufferG2D = null;
        private DecimalFormat numberFormat = new DecimalFormat("00000");

        public void error(String msg, Exception ex) {
            log.warn((Object)msg, (Throwable)ex);
        }

        public void sendingFrgamentRequest(POVWorkRequest req) {
            log.warn((Object)("Sending fragment[" + req.getFrame() + "," + req.getWidth() + "x" + req.getHeight() + "," + "(" + req.getStartCol() + "," + req.getEndCol() + ")," + "(" + req.getStartRow() + "," + req.getEndRow() + ")]"));
        }

        public void receivedFragmentResult(POVWorkRequest req, POVWorkResult res, int idx, POVRenderingFrame frame) {
            log.warn((Object)("Receiving fragment[" + req.getFrame() + "," + req.getWidth() + "x" + req.getHeight() + "," + "(" + req.getStartCol() + "," + req.getEndCol() + ")," + "(" + req.getStartRow() + "," + req.getEndRow() + ")]"));
            if (JCGridClient.this.hasRenderingWindow) {
                this.renderingFrameBufferG2D.drawImage(frame.getBufferedImage(), null, 0, 0);
                this.rWin.update();
            }
        }

        public void renderingBegin() {
            if (JCGridClient.this.hasRenderingWindow) {
                this.renderingFrameBuffer = new BufferedImage(JCGridClient.this.width, JCGridClient.this.height, 5);
                this.renderingFrameBufferG2D = this.renderingFrameBuffer.createGraphics();
                this.rWin = new RenderingWindow(this.renderingFrameBuffer);
                this.rWin.setVisible(true);
                this.rWin.update();
            } else {
                this.rWin = null;
            }
        }

        public void renderingEnd() {
            if (JCGridClient.this.hasRenderingWindow) {
                this.rWin.dispose();
            }
        }

        public void setProgressMaximum(int max) {
        }

        public void setProgressMinimum(int min) {
        }

        public void setProgressValue(int val) {
        }

        public void setRenderingTime(POVWorkRequest req, long dt) {
            double totTime = (double)dt / 60000.0;
            if ((double)dt > 1.0E-4) {
                long pixSec = JCGridClient.this.hasAnimation ? (long)(1000 * (JCGridClient.this.endFrame - JCGridClient.this.startFrame + 1) * req.getWidth() * req.getHeight()) / dt : (long)(1000 * req.getWidth() * req.getHeight()) / dt;
                log.warn((Object)("Total rendering time: " + totTime + "min (" + pixSec + "pixel/sec)"));
            } else {
                log.warn((Object)"Total rendering time: N/A");
            }
        }

        public void completeFrame(int idx, POVRenderingFrame frame) {
            try {
                String fileName = JCGridClient.this.hasAnimation ? this.numberFormat.format(idx) + "-" + JCGridClient.this.outputFile : JCGridClient.this.outputFile;
                log.warn((Object)("Complete frame: " + fileName + " [" + idx + "]"));
                File f = new File(fileName);
                ImageIO.write((RenderedImage)frame.getBufferedImage(), JCGridClient.this.outputFormat, f);
            }
            catch (Exception ex) {
                log.warn((Object)("Error while saving file: " + JCGridClient.this.outputFile), (Throwable)ex);
                System.exit(0);
            }
        }
    }
}

