/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.cmd.mandel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.client.GridClient;
import org.homedns.dade.jcgrid.client.GridNodeClientConfig;
import org.homedns.dade.jcgrid.cmd.mandel.guiMandelRenderingPannel;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelRenderingClient;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelRenderingClientFeedback;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelRenderingFrame;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelWorkRequest;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelWorkResult;

public class guiRenderingSetting
extends JDialog {
    private static final String className = guiRenderingSetting.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private static final long serialVersionUID = 1L;
    private GridNodeClientConfig clientConfig;
    private guiMandelRenderingPannel pPic;
    private short maxIteration;
    private double zoomFactor;
    private double xOrigin;
    private double yOrigin;
    private int imgWidth;
    private int imgHeight;
    private MandelRenderingClient rendThread;
    private MandelWorkRequest lastRequest;
    private JButton bCursor;
    private JButton bStartStop;
    private JButton bZoomIn;
    private JButton bZoomOut;
    private JComboBox cColors;
    private JLabel jLabel10;
    private JLabel jLabel13;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JButton lDown;
    private JLabel lImgHeight;
    private JLabel lImgWidth;
    private JButton lLeft;
    private JLabel lMaxIteration;
    private JLabel lRenderTime;
    private JButton lRight;
    private JButton lUp;
    private JLabel lXOrig;
    private JLabel lYOrig;
    private JLabel lZoomFactor;
    private JPanel pCfg;
    private JPanel pRendering;
    private JProgressBar pbStatus;
    private JSlider sMaxIteration;

    public guiRenderingSetting(GridNodeClientConfig cfg, Frame parent, boolean modal, guiMandelRenderingPannel rendPannel) {
        super(parent, modal);
        this.clientConfig = cfg;
        this.pPic = rendPannel;
        this.rendThread = null;
        this.lastRequest = null;
        this.initComponents();
        this.resetView(false);
    }

    public void resetView(boolean doRendering) {
        this.maxIteration = (short)512;
        this.sMaxIteration.setValue(this.maxIteration);
        this.lMaxIteration.setText(Short.toString(this.maxIteration));
        this.zoomFactor = 1.0;
        this.lZoomFactor.setText(Double.toString(this.zoomFactor));
        this.xOrigin = 0.0;
        this.lXOrig.setText(Double.toString(this.xOrigin));
        this.yOrigin = 0.0;
        this.lYOrig.setText(Double.toString(this.yOrigin));
        if (doRendering) {
            this.startRendering();
        }
    }

    public void startRendering() {
        this.pPic.initImage();
        int colorType = 0;
        if (this.cColors.getSelectedIndex() == 1) {
            colorType = 1;
        }
        short mi = this.maxIteration;
        double zf = this.zoomFactor;
        double xo = this.xOrigin;
        double yo = this.yOrigin;
        int w = this.pPic.getWidth();
        int h = this.pPic.getHeight();
        if (w <= 0 || h <= 0) {
            return;
        }
        this.lImgWidth.setText(Integer.toString(w));
        this.lImgHeight.setText(Integer.toString(h));
        float ratio = (float)h / (float)w;
        if (this.rendThread != null) {
            try {
                this.rendThread.interrupt();
                this.rendThread.join();
            }
            catch (Exception ex) {
                log.warn((Object)"Error stopping the rendering", (Throwable)ex);
                JOptionPane.showMessageDialog(this, "Error stopping the rendering.", "Rendering error", 0);
                this.rendThread = null;
            }
        }
        GridClient gc = new GridClient();
        gc.setNodeConfig(this.clientConfig);
        GridNodeClientConfig config = (GridNodeClientConfig)gc.getNodeConfig();
        try {
            this.lastRequest = new MandelWorkRequest(config.getSessionName(), 0, mi, xo - 2.0 * zf, yo - 2.0 * zf * (double)ratio, 4.0 * zf / (double)w, 4.0 * zf * (double)ratio / (double)h, w, h);
            this.rendThread = new MandelRenderingClient(config, new RenderingThreadFeedback(), this.lastRequest);
            this.rendThread.getFrame().setColorTableType(colorType);
            this.rendThread.getFrame().setMaxIter(mi);
            this.rendThread.start();
        }
        catch (Exception ex) {
            log.warn((Object)"Error starting the rendering", (Throwable)ex);
            JOptionPane.showMessageDialog(this, "Error starting the rendering.", "Rendering error", 0);
            this.rendThread = null;
        }
    }

    private void initComponents() {
        this.pCfg = new JPanel();
        this.jLabel4 = new JLabel();
        this.lMaxIteration = new JLabel();
        this.sMaxIteration = new JSlider();
        this.jLabel5 = new JLabel();
        this.lZoomFactor = new JLabel();
        this.bZoomIn = new JButton();
        this.bZoomOut = new JButton();
        this.jLabel6 = new JLabel();
        this.lXOrig = new JLabel();
        this.lLeft = new JButton();
        this.lRight = new JButton();
        this.jLabel7 = new JLabel();
        this.lYOrig = new JLabel();
        this.lUp = new JButton();
        this.lDown = new JButton();
        this.bCursor = new JButton();
        this.jLabel9 = new JLabel();
        this.lImgWidth = new JLabel();
        this.jLabel8 = new JLabel();
        this.lImgHeight = new JLabel();
        this.jLabel10 = new JLabel();
        this.cColors = new JComboBox();
        this.pRendering = new JPanel();
        this.bStartStop = new JButton();
        this.pbStatus = new JProgressBar();
        this.jLabel13 = new JLabel();
        this.lRenderTime = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Rendering settings");
        this.setDefaultCloseOperation(0);
        this.setName("dSetting");
        this.pCfg.setLayout(new GridBagLayout());
        this.pCfg.setBorder(new TitledBorder("Configuration"));
        this.jLabel4.setText("Max. iterations:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.jLabel4, gridBagConstraints);
        this.lMaxIteration.setText("...");
        this.lMaxIteration.setForeground(Color.blue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.lMaxIteration, gridBagConstraints);
        this.sMaxIteration.setMinimum(512);
        this.sMaxIteration.setMaximum(30000);
        this.sMaxIteration.setSnapToTicks(true);
        this.sMaxIteration.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                guiRenderingSetting.this.sMaxIterationStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.sMaxIteration, gridBagConstraints);
        this.jLabel5.setText("Zoom factor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.jLabel5, gridBagConstraints);
        this.lZoomFactor.setText("...");
        this.lZoomFactor.setForeground(Color.blue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.lZoomFactor, gridBagConstraints);
        this.bZoomIn.setText("Zoom In");
        this.bZoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiRenderingSetting.this.bZoomInActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.bZoomIn, gridBagConstraints);
        this.bZoomOut.setText("Zoom Out");
        this.bZoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiRenderingSetting.this.bZoomOutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.bZoomOut, gridBagConstraints);
        this.jLabel6.setText("X origin:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.jLabel6, gridBagConstraints);
        this.lXOrig.setText("...");
        this.lXOrig.setForeground(Color.blue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.lXOrig, gridBagConstraints);
        this.lLeft.setText("Move left");
        this.lLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiRenderingSetting.this.lLeftActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.lLeft, gridBagConstraints);
        this.lRight.setText("Move right");
        this.lRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiRenderingSetting.this.lRightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.lRight, gridBagConstraints);
        this.jLabel7.setText("Y origin:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.jLabel7, gridBagConstraints);
        this.lYOrig.setText("...");
        this.lYOrig.setForeground(Color.blue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.lYOrig, gridBagConstraints);
        this.lUp.setText("Move up");
        this.lUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiRenderingSetting.this.lUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.lUp, gridBagConstraints);
        this.lDown.setText("Move down");
        this.lDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiRenderingSetting.this.lDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.lDown, gridBagConstraints);
        this.bCursor.setText("Move to cursor");
        this.bCursor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiRenderingSetting.this.bCursorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.bCursor, gridBagConstraints);
        this.jLabel9.setText("Image width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.jLabel9, gridBagConstraints);
        this.lImgWidth.setText("...");
        this.lImgWidth.setForeground(Color.blue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.lImgWidth, gridBagConstraints);
        this.jLabel8.setText("Image height:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.jLabel8, gridBagConstraints);
        this.lImgHeight.setText("...");
        this.lImgHeight.setForeground(Color.blue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.lImgHeight, gridBagConstraints);
        this.jLabel10.setText("Image colors:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.jLabel10, gridBagConstraints);
        this.cColors.setModel(new DefaultComboBoxModel<String>(new String[]{"Red", "Misc"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pCfg.add((Component)this.cColors, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pCfg, gridBagConstraints);
        this.pRendering.setLayout(new GridBagLayout());
        this.pRendering.setBorder(new TitledBorder("Rendering"));
        this.bStartStop.setText("Start rendering");
        this.bStartStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                guiRenderingSetting.this.bStartStopActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pRendering.add((Component)this.bStartStop, gridBagConstraints);
        this.pbStatus.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pRendering.add((Component)this.pbStatus, gridBagConstraints);
        this.jLabel13.setHorizontalAlignment(4);
        this.jLabel13.setText("Last rendering time:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pRendering.add((Component)this.jLabel13, gridBagConstraints);
        this.lRenderTime.setHorizontalAlignment(2);
        this.lRenderTime.setForeground(SystemColor.activeCaption);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pRendering.add((Component)this.lRenderTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pRendering, gridBagConstraints);
        this.setBounds(50, 50, 600, 320);
    }

    private void bCursorActionPerformed(ActionEvent evt) {
        if (this.lastRequest != null) {
            this.xOrigin = this.lastRequest.getXOrig() + this.pPic.getCursorX() * this.lastRequest.getDX() * (double)this.lastRequest.getXStep();
            this.lXOrig.setText(Double.toString(this.xOrigin));
            this.yOrigin = this.lastRequest.getYOrig() + this.pPic.getCursorY() * this.lastRequest.getDY() * (double)this.lastRequest.getYStep();
            this.lYOrig.setText(Double.toString(this.yOrigin));
        }
    }

    private void lDownActionPerformed(ActionEvent evt) {
        this.yOrigin -= 0.1 * this.zoomFactor;
        this.lYOrig.setText(Double.toString(this.yOrigin));
    }

    private void lUpActionPerformed(ActionEvent evt) {
        this.yOrigin += 0.1 * this.zoomFactor;
        this.lYOrig.setText(Double.toString(this.yOrigin));
    }

    private void lRightActionPerformed(ActionEvent evt) {
        this.xOrigin += 0.1 * this.zoomFactor;
        this.lXOrig.setText(Double.toString(this.xOrigin));
    }

    private void lLeftActionPerformed(ActionEvent evt) {
        this.xOrigin -= 0.1 * this.zoomFactor;
        this.lXOrig.setText(Double.toString(this.xOrigin));
    }

    private void bZoomOutActionPerformed(ActionEvent evt) {
        this.zoomFactor *= 1.081081081081081;
        this.lZoomFactor.setText(Double.toString(this.zoomFactor));
    }

    private void bZoomInActionPerformed(ActionEvent evt) {
        this.zoomFactor *= 0.925;
        this.lZoomFactor.setText(Double.toString(this.zoomFactor));
    }

    private void sMaxIterationStateChanged(ChangeEvent evt) {
        this.maxIteration = (short)this.sMaxIteration.getValue();
        this.lMaxIteration.setText(Short.toString(this.maxIteration));
    }

    private void bStartStopActionPerformed(ActionEvent evt) {
        if (this.rendThread == null) {
            this.startRendering();
        } else {
            try {
                this.rendThread.interrupt();
                this.rendThread.join();
            }
            catch (Exception ex) {
                log.warn((Object)"Error stopping the rendering", (Throwable)ex);
                JOptionPane.showMessageDialog(this, "Error stopping the rendering.", "Rendering error", 0);
                this.rendThread = null;
            }
        }
        if (this.rendThread == null) {
            this.bStartStop.setText("Start rendering");
        } else {
            this.bStartStop.setText("Stop rendering");
        }
    }

    private class RenderingThreadFeedback
    implements MandelRenderingClientFeedback {
        public void error(String msg, Exception ex) {
            log.warn((Object)msg, (Throwable)ex);
            JOptionPane.showMessageDialog(guiRenderingSetting.this, msg, "Rendering error", 0);
        }

        public void receivedFragmentResult(MandelWorkRequest req, MandelWorkResult res, MandelRenderingFrame frame) {
            guiRenderingSetting.this.pPic.updateImage(frame);
        }

        public void renderingBegin() {
            guiRenderingSetting.this.pbStatus.setValue(guiRenderingSetting.this.pbStatus.getMinimum());
        }

        public void renderingEnd() {
            guiRenderingSetting.this.rendThread = null;
            guiRenderingSetting.this.bStartStop.setText("Start rendering");
        }

        public void sendingFrgamentRequest(MandelWorkRequest req) {
        }

        public void setProgressMaximum(int max) {
            guiRenderingSetting.this.pbStatus.setMaximum(max);
        }

        public void setProgressMinimum(int min) {
            guiRenderingSetting.this.pbStatus.setMinimum(min);
        }

        public void setProgressValue(int val) {
            guiRenderingSetting.this.pbStatus.setValue(val);
        }

        public void setRenderingTime(MandelWorkRequest req, long msdt) {
            double dt = (double)msdt / 1000.0;
            double pixsec = (double)(req.getXStep() * req.getYStep()) / dt;
            DecimalFormat df = new DecimalFormat("0.00");
            if (dt > 0.0) {
                guiRenderingSetting.this.lRenderTime.setText(df.format(dt / 60.0) + " min (" + df.format(pixsec) + "pixel/sec)");
            } else {
                guiRenderingSetting.this.lRenderTime.setText("N/A");
            }
        }

        public void completeFrame(int idx, MandelRenderingFrame frame) {
            guiRenderingSetting.this.pPic.updateImage(frame);
        }
    }
}

