/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid;

import java.util.Properties;
import java.util.Random;
import org.homedns.dade.jcgrid.GridNodeConfig;

public abstract class GridNodeGenericConfig
extends GridNodeConfig
implements Cloneable {
    private static Random rndGenerator = new Random();
    private String sessionName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateSessionID() {
        String[] alphabet = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        StringBuffer sb = new StringBuffer();
        Random random = rndGenerator;
        synchronized (random) {
            for (int i = 0; i < 8; ++i) {
                sb.append(alphabet[rndGenerator.nextInt(alphabet.length)]);
            }
        }
        return sb.toString();
    }

    public GridNodeGenericConfig(Properties prop) {
        super(prop);
        this.sessionName = prop.getProperty("grid.node.session.name", "none");
    }

    public GridNodeGenericConfig(String type) {
        super(type);
        this.sessionName = "none";
    }

    public Object clone() {
        GridNodeGenericConfig cfg = (GridNodeGenericConfig)super.clone();
        cfg.sessionName = this.sessionName;
        return cfg;
    }

    public Properties toProperties() {
        Properties prop = super.toProperties();
        prop.put("grid.node.session.name", this.sessionName);
        return prop;
    }

    public void autoSessioName() {
        String s = System.getProperty("user.name", "noname") + "_" + this.generateSessionID();
        this.sessionName = s.replaceAll("[^a-zA-Z0-9_]+", "_");
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String name) throws Exception {
        if (!name.matches("[a-zA-Z0-9_]+")) {
            throw new Exception("Invalid session name");
        }
        this.sessionName = name;
    }
}

