/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid;

import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.GridConfig;
import org.homedns.dade.jcgrid.GridNodeConfig;
import org.homedns.dade.jcgrid.GridNodeGenericConfig;

public abstract class GridNode {
    private static final String className = GridNode.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private GridNodeConfig config;

    public GridNode(GridNodeConfig cfg) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start GridNode(" + cfg + ")"));
        }
        this.config = cfg;
        if (log.isDebugEnabled()) {
            log.debug((Object)"End GridNode()");
        }
    }

    public void start() throws Exception {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start start()");
        }
        log.warn((Object)"Starting JCGrid Node...");
        GridConfig gCfg = this.config.getGridConfig();
        log.warn((Object)("  Server address: " + gCfg.getServerAddress()));
        log.warn((Object)("  Server client port: " + gCfg.getServerClientPort()));
        log.warn((Object)("  Server worker port: " + gCfg.getServerWorkerPort()));
        log.warn((Object)("  Server admin. port: " + gCfg.getServerAdminPort()));
        log.warn((Object)("  Working dir.: " + this.config.getWorkingDir()));
        log.warn((Object)("  Use secure connection: " + (gCfg.getUseSecureConnection() ? "yes" : "no")));
        log.warn((Object)("  Node type: " + this.config.getType()));
        log.warn((Object)("  Use compressed connection: " + (gCfg.getUseCompression() ? "yes" : "no")));
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"End start()");
        }
    }

    public void stop() throws Exception {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start stop()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"End stop()");
        }
    }

    public GridNodeConfig getNodeConfig() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getNodeConfig()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getNodeConfig(" + this.config + ")"));
        }
        return this.config;
    }

    public void setNodeConfig(GridNodeGenericConfig cfg) {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("Start setNodeConfig(" + cfg + ")"));
        }
        this.config = cfg;
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"End setNodeConfig()");
        }
    }
}

