/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.tests;

import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.models.SimpleExponentialSmoothingModel;
import net.sourceforge.openforecast.tests.OpenForecastTestCase;

public class SimpleExponentialSmoothingTest
extends OpenForecastTestCase {
    private static double TOLERANCE = 0.005;
    private static double MSE_TOLERANCE = 0.1;

    public SimpleExponentialSmoothingTest(String name) {
        super(name);
    }

    public void testConstantSimpleExponentialSmoothing() {
        Observation dp;
        int NUMBER_OF_OBSERVATIONS = 25;
        DataSet observedData = new DataSet();
        for (int t = 0; t < 25; ++t) {
            dp = new Observation(5.0);
            dp.setIndependentValue("t", t + 1);
            observedData.add(dp);
        }
        double[] expectedResult = new double[]{5.0, 5.0};
        for (double smoothingConstant = 0.1; smoothingConstant < 0.95; smoothingConstant += 0.1) {
            SimpleExponentialSmoothingModel model = new SimpleExponentialSmoothingModel(smoothingConstant);
            model.init(observedData);
            DataSet fcValues = new DataSet();
            dp = new Observation(0.0);
            dp.setIndependentValue("t", 24.0);
            fcValues.add(dp);
            dp = new Observation(0.0);
            dp.setIndependentValue("t", 25.0);
            fcValues.add(dp);
            DataSet results = model.forecast(fcValues);
            this.checkResults(results, expectedResult);
        }
    }

    public void testSimpleExponentialSmoothing() {
        Observation dp;
        DataSet observedData = new DataSet();
        double[] observations = new double[]{71.0, 70.0, 69.0, 68.0, 64.0, 65.0, 72.0, 78.0, 75.0, 75.0, 75.0, 70.0};
        for (int t = 0; t < observations.length; ++t) {
            dp = new Observation(observations[t]);
            dp.setIndependentValue("t", t + 1);
            observedData.add(dp);
        }
        SimpleExponentialSmoothingModel model = new SimpleExponentialSmoothingModel(0.1);
        model.init(observedData);
        SimpleExponentialSmoothingTest.assertEquals((String)"Checking the accuracy of the model", (double)18.98349, (double)model.getMSE(), (double)MSE_TOLERANCE);
        DataSet fcValues = new DataSet();
        for (int t = 2; t <= 12; ++t) {
            dp = new Observation(0.0);
            dp.setIndependentValue("t", t);
            fcValues.add(dp);
        }
        DataSet results = model.forecast(fcValues);
        double[] expectedResult = new double[]{71.0, 70.9, 70.71, 70.44, 69.8, 69.32, 69.58, 70.43, 70.88, 71.29, 71.67};
        this.checkResults(results, expectedResult, TOLERANCE);
    }

    public void testMusicStoreExample() {
        Observation dp;
        DataSet observedData = new DataSet();
        double[] observations = new double[]{74.0, 69.0, 80.0, 91.0, 76.0, 83.0, 79.0, 87.0, 89.0, 92.0};
        for (int t = 0; t < observations.length; ++t) {
            dp = new Observation(observations[t]);
            dp.setIndependentValue("t", t + 1);
            observedData.add(dp);
        }
        SimpleExponentialSmoothingModel model = new SimpleExponentialSmoothingModel(0.3, 2);
        model.init(observedData);
        SimpleExponentialSmoothingTest.assertEquals((String)"Checking the accuracy of the model", (double)29.9132, (double)model.getMSE(), (double)MSE_TOLERANCE);
        DataSet fcValues = new DataSet();
        for (int t = 1; t < observations.length; ++t) {
            dp = new Observation(0.0);
            dp.setIndependentValue("t", t + 1);
            fcValues.add(dp);
        }
        DataSet results = model.forecast(fcValues);
        double[] expectedResult = new double[]{72.5, 74.75, 79.62, 78.5375, 79.87625, 79.613375, 81.8293625, 83.98055375, 86.38638762};
        this.checkResults(results, expectedResult, TOLERANCE);
    }
}

