/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.tests;

import java.util.Iterator;
import junit.framework.TestCase;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;

public abstract class OpenForecastTestCase
extends TestCase {
    private static double TOLERANCE = 1.0E-5;

    public OpenForecastTestCase(String name) {
        super(name);
    }

    protected void checkResults(DataSet actualResults, double[] expectedResults) {
        this.checkResults(actualResults, expectedResults, TOLERANCE);
    }

    protected void checkResults(DataSet actualResults, double[] expectedResults, double tolerance) {
        OpenForecastTestCase.assertNotNull((String)"Checking expected results is not null", (Object)expectedResults);
        OpenForecastTestCase.assertTrue((String)"Checking there are some expected results", (expectedResults.length > 0 ? 1 : 0) != 0);
        OpenForecastTestCase.assertEquals((String)"Checking the correct number of results returned", (int)expectedResults.length, (int)actualResults.size());
        Iterator<DataPoint> it = actualResults.iterator();
        int i = 0;
        while (it.hasNext()) {
            DataPoint fc = it.next();
            double fcValue = fc.getDependentValue();
            OpenForecastTestCase.assertEquals((String)"Checking result", (double)expectedResults[i], (double)fcValue, (double)tolerance);
            ++i;
        }
    }
}

