/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.tests;

import java.util.Hashtable;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Forecaster;
import net.sourceforge.openforecast.ForecastingModel;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.models.MultipleLinearRegressionModel;
import net.sourceforge.openforecast.tests.OpenForecastTestCase;

public class MultipleLinearRegressionTest
extends OpenForecastTestCase {
    private DataSet observedData;

    protected void setUp() {
        this.observedData = new DataSet();
        Observation dp = new Observation(5.0);
        dp.setIndependentValue("x1", 0.0);
        dp.setIndependentValue("x2", 0.0);
        dp.setIndependentValue("x3", 0.0);
        this.observedData.add(dp);
        dp = new Observation(10.0);
        dp.setIndependentValue("x1", 2.0);
        dp.setIndependentValue("x2", 1.0);
        dp.setIndependentValue("x3", 1.0);
        this.observedData.add(dp);
        dp = new Observation(9.0);
        dp.setIndependentValue("x1", 2.5);
        dp.setIndependentValue("x2", 2.0);
        dp.setIndependentValue("x3", 2.0);
        this.observedData.add(dp);
        dp = new Observation(0.0);
        dp.setIndependentValue("x1", 1.0);
        dp.setIndependentValue("x2", 3.0);
        dp.setIndependentValue("x3", 3.0);
        this.observedData.add(dp);
        dp = new Observation(3.0);
        dp.setIndependentValue("x1", 4.0);
        dp.setIndependentValue("x2", 6.0);
        dp.setIndependentValue("x3", 4.0);
        this.observedData.add(dp);
        dp = new Observation(27.0);
        dp.setIndependentValue("x1", 7.0);
        dp.setIndependentValue("x2", 2.0);
        dp.setIndependentValue("x3", 5.0);
        this.observedData.add(dp);
    }

    public void testMultipleLinearRegression() {
        String[] independentVars = new String[]{"x1", "x2", "x3"};
        MultipleLinearRegressionModel forecaster = new MultipleLinearRegressionModel(independentVars);
        forecaster.init(this.observedData);
        DataSet fcValues = new DataSet();
        Observation dp = new Observation(0.0);
        dp.setIndependentValue("x1", 5.0);
        dp.setIndependentValue("x2", 5.0);
        dp.setIndependentValue("x3", 5.0);
        fcValues.add(dp);
        dp = new Observation(0.0);
        dp.setIndependentValue("x1", 2.0);
        dp.setIndependentValue("x2", 5.0);
        dp.setIndependentValue("x3", 7.0);
        fcValues.add(dp);
        dp = new Observation(0.0);
        dp.setIndependentValue("x1", 8.0);
        dp.setIndependentValue("x2", 16.0);
        dp.setIndependentValue("x3", 22.0);
        fcValues.add(dp);
        DataSet results = forecaster.forecast(fcValues);
        MultipleLinearRegressionTest.assertTrue((fcValues.size() == results.size() ? 1 : 0) != 0);
        double[] expectedResult = new double[]{10.0, -2.0, -11.0};
        this.checkResults(results, expectedResult);
    }

    public void testForecaster() {
        ForecastingModel forecaster = Forecaster.getBestForecast(this.observedData);
        MultipleLinearRegressionTest.assertTrue((boolean)forecaster.getClass().getName().equals("net.sourceforge.openforecast.models.MultipleLinearRegressionModel"));
        DataSet fcValues = new DataSet();
        Observation dp = new Observation(0.0);
        dp.setIndependentValue("x1", 5.0);
        dp.setIndependentValue("x2", 5.0);
        dp.setIndependentValue("x3", 5.0);
        fcValues.add(dp);
        dp = new Observation(0.0);
        dp.setIndependentValue("x1", 2.0);
        dp.setIndependentValue("x2", 5.0);
        dp.setIndependentValue("x3", 7.0);
        fcValues.add(dp);
        dp = new Observation(0.0);
        dp.setIndependentValue("x1", 8.0);
        dp.setIndependentValue("x2", 16.0);
        dp.setIndependentValue("x3", 22.0);
        fcValues.add(dp);
        DataSet results = forecaster.forecast(fcValues);
        MultipleLinearRegressionTest.assertTrue((fcValues.size() == results.size() ? 1 : 0) != 0);
        double[] expectedResult = new double[]{10.0, -2.0, -11.0};
        this.checkResults(results, expectedResult);
    }

    public void testUserDefinedCoefficientsWithNamedVars() {
        this.observedData.clear();
        this.observedData = null;
        int NUMBER_OF_COEFFS = 5;
        double intercept = 0.12345;
        Hashtable<String, Double> coeffs = new Hashtable<String, Double>();
        String[] varNames = new String[5];
        for (int c = 0; c < 5; ++c) {
            varNames[c] = new String("param" + (c + 1));
            coeffs.put(varNames[c], new Double(Math.pow(10.0, c)));
        }
        DataSet fcValues = new DataSet();
        for (int count = 0; count < 10; ++count) {
            Observation dp = new Observation(0.0);
            dp.setIndependentValue("param1", count + 4);
            dp.setIndependentValue("param2", count + 3);
            dp.setIndependentValue("param3", count + 2);
            dp.setIndependentValue("param4", count + 1);
            dp.setIndependentValue("param5", count);
            fcValues.add(dp);
        }
        MultipleLinearRegressionModel model = new MultipleLinearRegressionModel(varNames);
        model.init(intercept, coeffs);
        DataSet results = model.forecast(fcValues);
        MultipleLinearRegressionTest.assertTrue((fcValues.size() == results.size() ? 1 : 0) != 0);
        double[] expectedResult = new double[]{1234.12345, 12345.12345, 23456.12345, 34567.12345, 45678.12345, 56789.12345, 67900.12345, 79011.12345, 90122.12345, 101233.12345};
        this.checkResults(results, expectedResult);
    }

    public void testUserDefinedCoefficients() {
        this.observedData.clear();
        this.observedData = null;
        int NUMBER_OF_COEFFS = 5;
        double intercept = 0.12345;
        Hashtable<String, Double> coeffs = new Hashtable<String, Double>();
        String[] varNames = new String[5];
        for (int c = 0; c < 5; ++c) {
            varNames[c] = new String("param" + (c + 1));
            coeffs.put(varNames[c], new Double(Math.pow(10.0, c)));
        }
        DataSet fcValues = new DataSet();
        for (int count = 0; count < 10; ++count) {
            Observation dp = new Observation(0.0);
            dp.setIndependentValue("param1", count + 4);
            dp.setIndependentValue("param2", count + 3);
            dp.setIndependentValue("param3", count + 2);
            dp.setIndependentValue("param4", count + 1);
            dp.setIndependentValue("param5", count);
            fcValues.add(dp);
        }
        MultipleLinearRegressionModel model = new MultipleLinearRegressionModel();
        model.init(intercept, coeffs);
        DataSet results = model.forecast(fcValues);
        MultipleLinearRegressionTest.assertTrue((fcValues.size() == results.size() ? 1 : 0) != 0);
        double[] expectedResult = new double[]{1234.12345, 12345.12345, 23456.12345, 34567.12345, 45678.12345, 56789.12345, 67900.12345, 79011.12345, 90122.12345, 101233.12345};
        this.checkResults(results, expectedResult);
    }

    public MultipleLinearRegressionTest(String name) {
        super(name);
    }
}

