/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.tests;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.input.CSVBuilder;
import net.sourceforge.openforecast.output.DelimitedTextOutputter;
import net.sourceforge.openforecast.tests.OpenForecastTestCase;

public class DelimitedTextOutputterTest
extends OpenForecastTestCase {
    private DataSet expectedDataSet;

    public DelimitedTextOutputterTest(String name) {
        super(name);
    }

    public void setUp() {
        int MAX_X1 = 10;
        int MAX_X2 = 10;
        this.expectedDataSet = new DataSet();
        int numberOfDataPoints = 0;
        for (int x1 = 0; x1 < MAX_X1; ++x1) {
            for (int x2 = 0; x2 < MAX_X2; ++x2) {
                double expectedValue = (double)(x1 + 2 * x2) + 3.14;
                Observation dp = new Observation(expectedValue);
                dp.setIndependentValue("x1", x1);
                dp.setIndependentValue("x2", x2);
                this.expectedDataSet.add(dp);
                ++numberOfDataPoints;
            }
        }
        DelimitedTextOutputterTest.assertEquals((String)"Checking correct number of data points created", (int)numberOfDataPoints, (int)this.expectedDataSet.size());
    }

    public void tearDown() {
        this.expectedDataSet.clear();
        this.expectedDataSet = null;
    }

    public void testCSVOutput() throws FileNotFoundException, IOException {
        File testFile = File.createTempFile("test", ".csv");
        DelimitedTextOutputter outputter = new DelimitedTextOutputter(testFile.getAbsolutePath());
        outputter.output(this.expectedDataSet);
        CSVBuilder builder = new CSVBuilder(testFile.getAbsolutePath());
        DataSet writtenDataSet = builder.build();
        DelimitedTextOutputterTest.assertEquals((String)"Comparing data set written with data set written then read back", (Object)this.expectedDataSet, (Object)writtenDataSet);
        testFile.delete();
    }

    public void testAltCSVOutput() throws FileNotFoundException, IOException {
        String DELIMITER = ", ";
        File testFile = File.createTempFile("test", ".csv");
        DelimitedTextOutputter outputter = new DelimitedTextOutputter(testFile.getAbsolutePath());
        outputter.setDelimiter(", ");
        outputter.setOutputHeaderRow(true);
        outputter.output(this.expectedDataSet);
        CSVBuilder builder = new CSVBuilder(testFile.getAbsolutePath(), true);
        DataSet writtenDataSet = builder.build();
        DelimitedTextOutputterTest.assertEquals((String)"Comparing data set written with data set written then read back", (Object)this.expectedDataSet, (Object)writtenDataSet);
        testFile.delete();
    }
}

