/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.tests;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.input.CSVBuilder;
import net.sourceforge.openforecast.tests.OpenForecastTestCase;

public class CSVBuilderTest
extends OpenForecastTestCase {
    private double TOLERANCE = 1.0E-6;

    public void testExtremeCSVBuilder() throws FileNotFoundException, IOException {
        double[] expectedValue = new double[]{4.0, 5.0, 6.0, 7.0, 8.0};
        int numberOfDataPoints = expectedValue.length;
        File testFile = File.createTempFile("test", ".csv");
        PrintStream out = new PrintStream(new FileOutputStream(testFile));
        out.println("# This is a test CSV file with various 'peculiarities'");
        out.println(" # thrown in to try and trip it up");
        out.println("Field1, Field2, \"Field, 3\", Observation");
        out.println("-1, -2 ,-3,4");
        out.println(",,,5");
        out.println(" 1 , 2 , 3 , 6 ");
        out.println(" 2, 4, 6, 7");
        out.println("3 ,6 ,9 ,8");
        out.close();
        CSVBuilder builder = new CSVBuilder(testFile, true);
        DataSet dataSet = builder.build();
        CSVBuilderTest.assertEquals((String)"DataSet created is of the wrong size", (int)numberOfDataPoints, (int)dataSet.size());
        String[] independentVariables = dataSet.getIndependentVariables();
        CSVBuilderTest.assertEquals((String)"Checking the correct number of independent variables", (int)3, (int)independentVariables.length);
        CSVBuilderTest.assertTrue((String)"Checking variable 0 name is as expected", (independentVariables[0].compareTo("Field, 3") == 0 ? 1 : 0) != 0);
        CSVBuilderTest.assertTrue((String)"Checking variable 1 name is as expected", (independentVariables[1].compareTo("Field1") == 0 ? 1 : 0) != 0);
        CSVBuilderTest.assertTrue((String)"Checking variable 2 name is as expected", (independentVariables[2].compareTo("Field2") == 0 ? 1 : 0) != 0);
        for (DataPoint dataPoint : dataSet) {
            double field1 = dataPoint.getIndependentValue("Field1");
            double field2 = dataPoint.getIndependentValue("Field2");
            double field3 = dataPoint.getIndependentValue("Field, 3");
            CSVBuilderTest.assertTrue((String)"Checking independent values are correct", (field2 == 2.0 * field1 && field3 == 3.0 * field1 ? 1 : 0) != 0);
            double expectedResult = 5.0 + field1;
            CSVBuilderTest.assertEquals((String)("Checking data point " + dataPoint), (double)expectedResult, (double)dataPoint.getDependentValue(), (double)this.TOLERANCE);
        }
        testFile.delete();
    }

    public void testCSVBuilder() throws FileNotFoundException, IOException {
        int MAX_X1 = 10;
        int MAX_X2 = 10;
        double TOLERANCE = 1.0E-6;
        double[] expectedValue = new double[MAX_X1 * MAX_X2];
        File testFile = File.createTempFile("test", ".csv");
        PrintStream out = new PrintStream(new FileOutputStream(testFile));
        out.println("# This is a test CSV file");
        int numberOfDataPoints = 0;
        for (int x1 = 0; x1 < MAX_X1; ++x1) {
            for (int x2 = 0; x2 < MAX_X2; ++x2) {
                expectedValue[numberOfDataPoints] = (double)(x1 + 2 * x2) + 3.14;
                out.println(x1 + ", " + x2 + ", " + expectedValue[numberOfDataPoints]);
                ++numberOfDataPoints;
            }
        }
        out.close();
        CSVBuilder builder = new CSVBuilder(testFile);
        DataSet dataSet = builder.build();
        CSVBuilderTest.assertEquals((String)"DataSet created is of the wrong size", (int)numberOfDataPoints, (int)dataSet.size());
        String[] independentVariables = dataSet.getIndependentVariables();
        CSVBuilderTest.assertTrue((independentVariables.length == 2 ? 1 : 0) != 0);
        CSVBuilderTest.assertTrue((boolean)independentVariables[0].equals("x1"));
        CSVBuilderTest.assertTrue((boolean)independentVariables[1].equals("x2"));
        this.checkResults(dataSet, expectedValue);
        for (DataPoint dataPoint : dataSet) {
            double x1 = dataPoint.getIndependentValue("x1");
            double x2 = dataPoint.getIndependentValue("x2");
            double expectedResult = x1 + 2.0 * x2 + 3.14;
            CSVBuilderTest.assertEquals((String)("Checking data point " + dataPoint), (double)expectedResult, (double)dataPoint.getDependentValue(), (double)TOLERANCE);
        }
        testFile.delete();
    }

    public void testUnknownHeaderWithHeader() throws FileNotFoundException, IOException {
        int MAX_X1 = 3;
        int MAX_X2 = 3;
        double TOLERANCE = 1.0E-6;
        double[] expectedValue = new double[MAX_X1 * MAX_X2];
        File testFile = File.createTempFile("test", ".csv");
        PrintStream out = new PrintStream(new FileOutputStream(testFile));
        out.println("# This is a test CSV file");
        for (int x1 = 0; x1 < MAX_X1 - 1; ++x1) {
            out.print("Col" + (x1 + 1) + ", ");
        }
        out.println("Col" + MAX_X1);
        int numberOfDataPoints = 0;
        for (int x1 = 0; x1 < MAX_X1; ++x1) {
            for (int x2 = 0; x2 < MAX_X2; ++x2) {
                expectedValue[numberOfDataPoints] = (double)(x1 + 2 * x2) + 3.14;
                out.println(x1 + ", " + x2 + ", " + expectedValue[numberOfDataPoints]);
                ++numberOfDataPoints;
            }
        }
        out.close();
        CSVBuilder builder = new CSVBuilder(testFile);
        DataSet dataSet = builder.build();
        CSVBuilderTest.assertEquals((String)"DataSet created is of the wrong size", (int)numberOfDataPoints, (int)dataSet.size());
        String[] independentVariables = dataSet.getIndependentVariables();
        CSVBuilderTest.assertTrue((independentVariables.length == 2 ? 1 : 0) != 0);
        CSVBuilderTest.assertTrue((independentVariables[0].compareTo("Col1") == 0 ? 1 : 0) != 0);
        CSVBuilderTest.assertTrue((independentVariables[1].compareTo("Col2") == 0 ? 1 : 0) != 0);
        this.checkResults(dataSet, expectedValue);
        for (DataPoint dataPoint : dataSet) {
            double x1 = dataPoint.getIndependentValue("Col1");
            double x2 = dataPoint.getIndependentValue("Col2");
            double expectedResult = x1 + 2.0 * x2 + 3.14;
            CSVBuilderTest.assertEquals((String)("Checking data point " + dataPoint), (double)expectedResult, (double)dataPoint.getDependentValue(), (double)TOLERANCE);
        }
        testFile.delete();
    }

    public void testUnknownHeaderWithoutHeader() throws FileNotFoundException, IOException {
        int MAX_X1 = 3;
        int MAX_X2 = 3;
        double TOLERANCE = 1.0E-6;
        double[] expectedValue = new double[MAX_X1 * MAX_X2];
        File testFile = File.createTempFile("test", ".csv");
        PrintStream out = new PrintStream(new FileOutputStream(testFile));
        out.println("# This is a test CSV file");
        int numberOfDataPoints = 0;
        for (int x1 = 0; x1 < MAX_X1; ++x1) {
            for (int x2 = 0; x2 < MAX_X2; ++x2) {
                expectedValue[numberOfDataPoints] = (double)(x1 + 2 * x2) + 3.14;
                out.println(x1 + ", " + x2 + ", " + expectedValue[numberOfDataPoints]);
                ++numberOfDataPoints;
            }
        }
        out.close();
        CSVBuilder builder = new CSVBuilder(testFile);
        DataSet dataSet = builder.build();
        CSVBuilderTest.assertEquals((String)"DataSet created is of the wrong size", (int)numberOfDataPoints, (int)dataSet.size());
        String[] independentVariables = dataSet.getIndependentVariables();
        CSVBuilderTest.assertTrue((independentVariables.length == 2 ? 1 : 0) != 0);
        CSVBuilderTest.assertTrue((independentVariables[0].compareTo("x1") == 0 ? 1 : 0) != 0);
        CSVBuilderTest.assertTrue((independentVariables[1].compareTo("x2") == 0 ? 1 : 0) != 0);
        this.checkResults(dataSet, expectedValue);
        for (DataPoint dataPoint : dataSet) {
            double x1 = dataPoint.getIndependentValue("x1");
            double x2 = dataPoint.getIndependentValue("x2");
            double expectedResult = x1 + 2.0 * x2 + 3.14;
            CSVBuilderTest.assertEquals((String)("Checking data point " + dataPoint), (double)expectedResult, (double)dataPoint.getDependentValue(), (double)TOLERANCE);
        }
        testFile.delete();
    }

    public CSVBuilderTest(String name) {
        super(name);
    }
}

