/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.models.AbstractForecastingModel;
import net.sourceforge.openforecast.models.ModelNotInitializedException;

public class RegressionModel
extends AbstractForecastingModel {
    private String independentVariable;
    private double intercept = 0.0;
    private double slope = 0.0;

    public RegressionModel(String independentVariable) {
        this.independentVariable = independentVariable;
    }

    @Override
    public void init(DataSet dataSet) {
        int n = dataSet.size();
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumXY = 0.0;
        for (DataPoint dp : dataSet) {
            double x = dp.getIndependentValue(this.independentVariable);
            double y = dp.getDependentValue();
            sumX += x;
            sumY += y;
            sumXX += x * x;
            sumXY += x * y;
        }
        double xMean = sumX / (double)n;
        double yMean = sumY / (double)n;
        this.slope = ((double)n * sumXY - sumX * sumY) / ((double)n * sumXX - sumX * sumX);
        this.intercept = yMean - this.slope * xMean;
        this.calculateAccuracyIndicators(dataSet);
    }

    @Override
    public double forecast(DataPoint dataPoint) throws ModelNotInitializedException {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        double x = dataPoint.getIndependentValue(this.independentVariable);
        double forecastValue = this.intercept + this.slope * x;
        dataPoint.setDependentValue(forecastValue);
        return forecastValue;
    }

    @Override
    public String getForecastType() {
        return "Single variable regression";
    }

    @Override
    public int getNumberOfPredictors() {
        return 1;
    }

    @Override
    public String toString() {
        return "Single variable regression model with a slope of " + this.slope + " and an intercept of " + this.intercept + ". That is, y=" + this.intercept + (this.slope > 0.0 ? "+" : "") + this.slope + "*" + this.independentVariable + ".";
    }
}

