/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.models.AbstractForecastingModel;
import net.sourceforge.openforecast.models.ModelNotInitializedException;
import net.sourceforge.openforecast.models.Utils;

public class PolynomialRegressionModel
extends AbstractForecastingModel {
    private String independentVariable;
    private int order = 0;
    private double[] coefficient;

    public PolynomialRegressionModel(String independentVariable) {
        this(independentVariable, 10);
    }

    public PolynomialRegressionModel(String independentVariable, int order) {
        this.independentVariable = independentVariable;
        this.order = order;
    }

    @Override
    public void init(DataSet dataSet) {
        double[][] a = new double[this.order][this.order + 1];
        for (int i = 0; i < this.order; ++i) {
            for (int j = 0; j < this.order; ++j) {
                int k = i + j;
                for (DataPoint dp : dataSet) {
                    double x = dp.getIndependentValue(this.independentVariable);
                    a[i][j] = a[i][j] + Math.pow(x, k);
                }
            }
            for (DataPoint dp : dataSet) {
                double x = dp.getIndependentValue(this.independentVariable);
                double y = dp.getDependentValue();
                double[] dArray = a[i];
                int n = this.order;
                dArray[n] = dArray[n] + y * Math.pow(x, i);
            }
        }
        this.coefficient = Utils.GaussElimination(this.order, a);
        this.calculateAccuracyIndicators(dataSet);
    }

    @Override
    public double forecast(DataPoint dataPoint) {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        double x = dataPoint.getIndependentValue(this.independentVariable);
        double forecastValue = 0.0;
        for (int i = 0; i < this.order; ++i) {
            forecastValue += this.coefficient[i] * Math.pow(x, i);
        }
        dataPoint.setDependentValue(forecastValue);
        return forecastValue;
    }

    @Override
    public int getNumberOfPredictors() {
        return 1;
    }

    @Override
    public String getForecastType() {
        return "Single variable polynomial regression";
    }

    @Override
    public String toString() {
        String description = "Single variable polynomial regression model";
        if (!this.initialized) {
            return description + " (uninitialized)";
        }
        description = description + " with an equation of: y = " + this.coefficient[0];
        for (int i = 1; i < this.coefficient.length; ++i) {
            if (!(Math.abs(this.coefficient[i]) > 0.001)) continue;
            description = description + (this.coefficient[i] < 0.0 ? "" : "+") + this.coefficient[i] + "*" + this.independentVariable + (i > 1 ? "^" + i : "");
        }
        return description;
    }
}

