/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import org.mapdb.CC;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.Engine;
import org.mapdb.Fun;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.Volume;

public class StoreAppend
extends Store {
    protected static final int STORE_VERSION = 100;
    protected static final int HEADER = -1422065564;
    protected static final int I_UPDATE = 1;
    protected static final int I_INSERT = 3;
    protected static final int I_DELETE = 2;
    protected static final int I_PREALLOC = 4;
    protected static final int I_SKIP_SINGLE_BYTE = 6;
    protected static final int I_SKIP_MULTI_BYTE = 7;
    protected static final int I_TX_VALID = 8;
    protected static final int I_TX_ROLLBACK = 9;
    protected static final long headerSize = 16L;
    protected static final StoreAppend[] STORE_APPENDS_ZERO_ARRAY = new StoreAppend[0];
    protected Volume vol;
    protected Volume indexTable;
    protected long eof = 0L;
    protected final AtomicLong highestRecid = new AtomicLong(0L);
    protected final boolean tx;
    protected final Store.LongLongMap[] modified;
    protected final ScheduledExecutorService compactionExecutor;
    protected final Set<StoreAppend> snapshots;
    protected final boolean isSnapshot;
    protected final long startSize;
    protected final long sizeIncrement;
    protected final int sliceShift;

    protected StoreAppend(String fileName, Volume.VolumeFactory volumeFactory, Store.Cache cache, int lockScale, int lockingStrategy, boolean checksum, boolean compress, byte[] password, boolean readonly, boolean snapshotEnable, boolean fileLockDisable, DataIO.HeartbeatFileLock fileLockHeartbeat, boolean txDisabled, ScheduledExecutorService compactionExecutor, long startSize, long sizeIncrement) {
        super(fileName, volumeFactory, cache, lockScale, lockingStrategy, checksum, compress, password, readonly, snapshotEnable, fileLockDisable, fileLockHeartbeat);
        boolean bl = this.tx = !txDisabled;
        if (this.tx) {
            this.modified = new Store.LongLongMap[this.lockScale];
            for (int i = 0; i < this.modified.length; ++i) {
                this.modified[i] = new Store.LongLongMap();
            }
        } else {
            this.modified = null;
        }
        this.compactionExecutor = compactionExecutor;
        this.snapshots = Collections.synchronizedSet(new HashSet());
        this.isSnapshot = false;
        this.sizeIncrement = Math.max(0x100000L, DataIO.nextPowTwo(sizeIncrement));
        this.startSize = Fun.roundUp(Math.max(0x100000L, startSize), this.sizeIncrement);
        this.sliceShift = Volume.sliceShiftFromSize(this.sizeIncrement);
    }

    public StoreAppend(String fileName) {
        this(fileName, fileName == null ? CC.DEFAULT_MEMORY_VOLUME_FACTORY : CC.DEFAULT_FILE_VOLUME_FACTORY, null, 16, 0, false, false, null, false, false, false, null, false, null, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StoreAppend(StoreAppend host, Store.LongLongMap[] uncommitedData) {
        super(null, null, null, host.lockScale, 2, host.checksum, host.compress, null, true, false, false, null);
        int i;
        this.indexTable = host.indexTable;
        this.vol = host.vol;
        for (i = 0; i < this.locks.length; ++i) {
            this.locks[i] = host.locks[i];
        }
        this.tx = true;
        this.modified = new Store.LongLongMap[this.lockScale];
        if (uncommitedData == null) {
            for (i = 0; i < this.modified.length; ++i) {
                this.modified[i] = new Store.LongLongMap();
            }
        } else {
            for (i = 0; i < this.modified.length; ++i) {
                Lock lock = this.locks[i].writeLock();
                lock.lock();
                try {
                    this.modified[i] = uncommitedData[i].clone();
                    continue;
                }
                finally {
                    lock.unlock();
                }
            }
        }
        this.compactionExecutor = null;
        this.snapshots = host.snapshots;
        this.isSnapshot = true;
        host.snapshots.add(this);
        this.startSize = host.startSize;
        this.sizeIncrement = host.sizeIncrement;
        this.sliceShift = host.sliceShift;
    }

    @Override
    public void init() {
        super.init();
        this.structuralLock.lock();
        try {
            boolean empty = Volume.isEmptyFile(this.fileName);
            this.vol = this.volumeFactory.makeVolume(this.fileName, this.readonly, this.fileLockDisable, this.sliceShift, this.startSize, false);
            this.indexTable = new Volume.ByteArrayVol(20, 0L);
            this.indexTable.ensureAvailable(56L);
            this.eof = 16L;
            int i = 0;
            while ((long)i <= 7L) {
                this.indexTable.ensureAvailable(i * 8);
                this.indexTable.putLong(i * 8, -3L);
                ++i;
            }
            if (empty) {
                this.initCreate();
            } else {
                this.initOpen();
            }
        }
        finally {
            this.structuralLock.unlock();
        }
    }

    protected void initCreate() {
        this.vol.ensureAvailable(16L);
        this.highestRecid.set(7L);
        this.vol.putInt(0L, -1422065564);
        long feat = this.makeFeaturesBitmap();
        this.vol.putLong(8L, feat);
        this.vol.sync();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initOpen() {
        if (!this.readonly) {
            this.vol.ensureAvailable(16L);
        }
        this.checkFeaturesBitmap(this.vol.getLong(8L));
        long pos = 16L;
        long volumeSize = this.vol.length();
        long lastValidPos = pos;
        long lastValidCommitOffset = 0L;
        long highestRecid2 = 7L;
        Store.LongLongMap commitData = this.tx ? new Store.LongLongMap() : null;
        try {
            while (true) {
                int inst;
                lastValidPos = pos;
                if (pos >= volumeSize) break;
                long instPos = pos;
                if ((inst = this.vol.getUnsignedByte(pos++)) == 3 || inst == 1) {
                    long recid = this.vol.getPackedLong(pos);
                    pos += recid >>> 60;
                    recid = this.longParityGet(recid & 0xFFFFFFFFFFFFFFL);
                    highestRecid2 = Math.max(highestRecid2, recid);
                    commitData.put(recid, instPos);
                    long size = this.vol.getPackedLong(pos);
                    long dataLen = this.longParityGet(size & 0xFFFFFFFFFFFFFFL) - 1L;
                    dataLen = Math.max(0L, dataLen);
                    pos = pos + (size >>> 60) + dataLen;
                    continue;
                }
                if (inst == 2) {
                    long recid = this.vol.getPackedLong(pos);
                    pos += recid >>> 60;
                    recid = this.longParityGet(recid & 0xFFFFFFFFFFFFFFL);
                    highestRecid2 = Math.max(highestRecid2, recid);
                    commitData.put(recid, -1L);
                    continue;
                }
                if (inst == 2) {
                    long recid = this.vol.getPackedLong(pos);
                    pos += recid >>> 60;
                    recid = this.longParityGet(recid & 0xFFFFFFFFFFFFFFL);
                    highestRecid2 = Math.max(highestRecid2, recid);
                    commitData.put(recid, -2L);
                    continue;
                }
                if (inst == 6) continue;
                if (inst == 7) {
                    long size = this.vol.getPackedLong(pos);
                    pos += (size >>> 60) + this.longParityGet(size & 0xFFFFFFFFFFFFFFL);
                    continue;
                }
                if (inst == 8) {
                    if (!this.tx) continue;
                    lastValidCommitOffset = pos;
                } else {
                    if (inst == 9) {
                        if (!this.tx) continue;
                        commitData.clear();
                        continue;
                    }
                    if (inst == 0) {
                        if (this.tx) {
                            commitData.clear();
                        }
                        break;
                    }
                    LOG.warning("Unknown instruction " + inst);
                    break;
                }
                for (int i = 0; i < commitData.table.length; i += 2) {
                    long recidOffset = commitData.table[i] * 8L;
                    if (recidOffset == 0L) continue;
                    this.indexTable.ensureAvailable(recidOffset + 8L);
                    this.indexTable.putLong(recidOffset, commitData.table[i + 1]);
                }
                commitData.clear();
            }
        }
        catch (RuntimeException e) {
            if (!this.tx) {
                LOG.warning("AppendStore has transactions disabled, which means no crash protection. Data corruption at offset: " + pos);
                throw e;
            }
            LOG.log(Level.WARNING, "Log corrupted, most likely last TX was not committed. Rolling back to last valid commit at offset: " + lastValidCommitOffset, e);
            commitData.clear();
        }
        this.eof = lastValidPos;
        this.highestRecid.set(highestRecid2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long alloc(int headSize, int totalSize) {
        this.structuralLock.lock();
        try {
            while (this.eof / 0x100000L != (this.eof + (long)headSize) / 0x100000L) {
                this.vol.ensureAvailable(this.eof + 1L);
                this.vol.putUnsignedByte(this.eof++, 6);
            }
            long ret = this.eof;
            this.eof += (long)totalSize;
            long l = ret;
            return l;
        }
        finally {
            this.structuralLock.unlock();
        }
    }

    @Override
    protected <A> A get2(long recid, Serializer<A> serializer) {
        long offset;
        this.assertReadLocked(recid);
        long l = offset = this.tx ? this.modified[this.lockPos(recid)].get(recid) : 0L;
        if (offset == 0L) {
            try {
                offset = this.indexTable.getLong(recid * 8L);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new DBException.EngineGetVoid();
            }
        }
        if (offset == -3L || offset == -1L) {
            return null;
        }
        if (offset == 0L) {
            throw new DBException.EngineGetVoid();
        }
        if (offset == -2L) {
            return this.deserialize(serializer, 0, new DataIO.DataInputByteArray(new byte[0]));
        }
        long packedRecidSize = DataIO.packLongSize(this.longParitySet(recid));
        int instruction = this.vol.getUnsignedByte(offset);
        if (instruction != 1 && instruction != 3) {
            throw new DBException.DataCorruption("wrong instruction " + instruction);
        }
        long recid2 = this.vol.getPackedLong(offset + 1L);
        if (packedRecidSize != recid2 >>> 60) {
            throw new DBException.DataCorruption("inconsistent recid len");
        }
        if (recid != (recid2 = this.longParityGet(recid2 & 0xFFFFFFFFFFFFFFL))) {
            throw new DBException.DataCorruption("recid does not match");
        }
        long size = this.vol.getPackedLong(offset += 1L + packedRecidSize);
        offset += size >>> 60;
        size = this.longParityGet(size & 0xFFFFFFFFFFFFFFL);
        if (--size <= 0L) {
            throw new DBException.DataCorruption("wrong size");
        }
        DataInput input = this.vol.getDataInputOverlap(offset, (int)size);
        return this.deserialize(serializer, (int)size, input);
    }

    @Override
    protected void update2(long recid, DataIO.DataOutputByteArray out) {
        this.insertOrUpdate(recid, out, false);
    }

    private void insertOrUpdate(long recid, DataIO.DataOutputByteArray out, boolean isInsert) {
        long offset;
        this.assertWriteLocked(this.lockPos(recid));
        int realSize = out == null ? 0 : out.pos;
        int shiftedSize = out == null ? 0 : realSize + 1;
        int headSize = 1 + DataIO.packLongSize(this.longParitySet(recid)) + DataIO.packLongSize(this.longParitySet(shiftedSize));
        long origOffset = offset = this.alloc(headSize, headSize + realSize);
        this.vol.ensureAvailable(offset + (long)headSize + (long)realSize);
        this.vol.putUnsignedByte(offset, isInsert ? 3 : 1);
        ++offset;
        offset += (long)this.vol.putPackedLong(offset, this.longParitySet(recid));
        offset += (long)this.vol.putPackedLong(offset, this.longParitySet(shiftedSize));
        if (realSize != 0) {
            this.vol.putDataOverlap(offset, out.buf, 0, out.pos);
        }
        this.indexTablePut(recid, out == null ? -3L : (realSize == 0 ? -2L : origOffset));
    }

    @Override
    protected <A> void delete2(long recid, Serializer<A> serializer) {
        this.assertWriteLocked(this.lockPos(recid));
        int headSize = 1 + DataIO.packLongSize(this.longParitySet(recid));
        long offset = this.alloc(headSize, headSize);
        this.vol.ensureAvailable(offset + (long)headSize);
        this.vol.putUnsignedByte(offset, 2);
        this.vol.putPackedLong(++offset, this.longParitySet(recid));
        this.indexTablePut(recid, -1L);
    }

    @Override
    public long getCurrSize() {
        return 0L;
    }

    @Override
    public long getFreeSize() {
        return 0L;
    }

    @Override
    public boolean fileLoad() {
        return this.vol.fileLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long preallocate() {
        long recid = this.highestRecid.incrementAndGet();
        Lock lock = this.locks[this.lockPos(recid)].writeLock();
        lock.lock();
        try {
            int headSize = 1 + DataIO.packLongSize(this.longParitySet(recid));
            long offset = this.alloc(headSize, headSize);
            this.vol.ensureAvailable(offset + (long)headSize);
            this.vol.putUnsignedByte(offset, 4);
            this.vol.putPackedLong(++offset, this.longParitySet(recid));
            this.indexTablePut(recid, -3L);
        }
        finally {
            lock.unlock();
        }
        return recid;
    }

    protected void indexTablePut(long recid, long offset) {
        if (this.tx) {
            this.modified[this.lockPos(recid)].put(recid, offset);
        } else {
            this.indexTable.ensureAvailable(recid * 8L + 8L);
            this.indexTable.putLong(recid * 8L, offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        DataIO.DataOutputByteArray out = this.serialize(value, serializer);
        long recid = this.highestRecid.incrementAndGet();
        int lockPos = this.lockPos(recid);
        Store.Cache cache = this.caches == null ? null : this.caches[lockPos];
        Lock lock = this.locks[lockPos].writeLock();
        lock.lock();
        try {
            if (cache != null) {
                cache.put(recid, value);
            }
            this.insertOrUpdate(recid, out, true);
        }
        finally {
            lock.unlock();
        }
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.commitLock.lock();
        try {
            if (this.closed) {
                return;
            }
            if (this.isSnapshot) {
                this.snapshots.remove(this);
                return;
            }
            this.vol.sync();
            this.vol.close();
            this.indexTable.close();
            if (this.caches != null) {
                for (Store.Cache c : this.caches) {
                    c.close();
                }
                Arrays.fill(this.caches, null);
            }
            if (this.fileLockHeartbeat != null) {
                this.fileLockHeartbeat.unlock();
                this.fileLockHeartbeat = null;
            }
            this.closed = true;
        }
        finally {
            this.commitLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        if (this.isSnapshot) {
            return;
        }
        if (!this.tx) {
            this.vol.sync();
            return;
        }
        this.commitLock.lock();
        try {
            StoreAppend[] snaps = this.snapshots == null ? STORE_APPENDS_ZERO_ARRAY : this.snapshots.toArray(STORE_APPENDS_ZERO_ARRAY);
            for (int i = 0; i < this.locks.length; ++i) {
                Lock lock = this.locks[i].writeLock();
                lock.lock();
                try {
                    long[] m = this.modified[i].table;
                    for (int j = 0; j < m.length; j += 2) {
                        long recid = m[j];
                        long recidOffset = recid * 8L;
                        if (recidOffset == 0L) continue;
                        this.indexTable.ensureAvailable(recidOffset + 8L);
                        long oldVal = this.indexTable.getLong(recidOffset);
                        this.indexTable.putLong(recidOffset, m[j + 1]);
                        for (StoreAppend snap : snaps) {
                            Store.LongLongMap m2 = snap.modified[i];
                            if (m2.get(recid) != 0L) continue;
                            m2.put(recid, oldVal);
                        }
                    }
                    this.modified[i].clear();
                    continue;
                }
                finally {
                    lock.unlock();
                }
            }
            long offset = this.alloc(1, 1);
            this.vol.putUnsignedByte(offset, 8);
            this.vol.sync();
        }
        finally {
            this.commitLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws UnsupportedOperationException {
        if (!this.tx || this.readonly || this.isSnapshot) {
            throw new UnsupportedOperationException();
        }
        this.commitLock.lock();
        try {
            for (int i = 0; i < this.locks.length; ++i) {
                Lock lock = this.locks[i].writeLock();
                lock.lock();
                try {
                    this.modified[i].clear();
                    continue;
                }
                finally {
                    lock.unlock();
                }
            }
            long offset = this.alloc(1, 1);
            this.vol.putUnsignedByte(offset, 9);
            this.vol.sync();
        }
        finally {
            this.commitLock.unlock();
        }
    }

    @Override
    public boolean canRollback() {
        return this.tx;
    }

    @Override
    public boolean canSnapshot() {
        return true;
    }

    @Override
    public Engine snapshot() throws UnsupportedOperationException {
        this.commitLock.lock();
        try {
            StoreAppend storeAppend = new StoreAppend(this, this.modified);
            return storeAppend;
        }
        finally {
            this.commitLock.unlock();
        }
    }

    @Override
    public void compact() {
        if (this.isSnapshot) {
            return;
        }
    }

    @Override
    public void backup(OutputStream out, boolean incremental) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public void backupRestore(InputStream[] in) {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

