/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.DataInput2;
import org.mapdb.Engine;
import org.mapdb.Serializer;
import org.mapdb.Volume;

public abstract class Storage
implements Engine {
    static final long PHYS_OFFSET_MASK = 0xFFFFFFFFFFFFL;
    static final long HEADER = 5646556656456456L;
    static final int RECID_CURRENT_PHYS_FILE_SIZE = 1;
    static final int RECID_CURRENT_INDEX_FILE_SIZE = 2;
    static final int RECID_FREE_INDEX_SLOTS = 3;
    static final int RECID_SERIALIZER = 4;
    static final int RECID_NAME_DIR = 19;
    static final int RECID_FREE_PHYS_RECORDS_START = 20;
    static final int NUMBER_OF_PHYS_FREE_SLOT = 2535;
    static final int MAX_RECORD_SIZE = 65535;
    static final byte LONG_STACK_NUM_OF_RECORDS_PER_PAGE = 100;
    static final int LONG_STACK_PAGE_SIZE = 808;
    static final int INDEX_OFFSET_START = 2555;
    public static final String DATA_FILE_EXT = ".p";
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected final boolean appendOnly;
    protected final boolean deleteFilesOnExit;
    protected final boolean failOnWrongHeader;
    protected final boolean readOnly;
    protected Volume phys;
    protected Volume index;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Storage(Volume.Factory volFac, boolean appendOnly, boolean deleteFilesOnExit, boolean failOnWrongHeader, boolean readOnly) {
        this.appendOnly = appendOnly;
        this.deleteFilesOnExit = deleteFilesOnExit;
        this.failOnWrongHeader = failOnWrongHeader;
        this.readOnly = readOnly;
        try {
            long header;
            this.lock.writeLock().lock();
            this.phys = volFac.createPhysVolume();
            this.index = volFac.createIndexVolume();
            this.phys.ensureAvailable(8L);
            this.index.ensureAvailable(20440L);
            long l = header = this.index.isEmpty() ? 0L : this.index.getLong(0L);
            if (header != 5646556656456456L) {
                if (failOnWrongHeader) {
                    throw new IOError(new IOException("Wrong file header"));
                }
                this.writeInitValues();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void writeInitValues() {
        this.writeLock_checkLocked();
        for (int i = 1; i < 2555; ++i) {
            this.index.putLong(i * 8, 0L);
        }
        this.phys.putLong(0L, 5646556656456456L);
        this.index.putLong(0L, 5646556656456456L);
        if (this.index.getLong(0L) != 5646556656456456L) {
            throw new InternalError();
        }
        this.index.putLong(8L, 8L);
        this.index.putLong(16L, 20440L);
        this.index.putLong(152L, 0L);
    }

    protected void writeLock_checkLocked() {
        if (!this.lock.writeLock().isHeldByCurrentThread()) {
            throw new IllegalAccessError("no write lock");
        }
    }

    final int freePhysRecSize2FreeSlot(int size) {
        if (size > 65535) {
            throw new IllegalArgumentException("too big record");
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size");
        }
        if (size < 1535) {
            return size - 1;
        }
        if (size == 65535) {
            return 2534;
        }
        return 1534 + (size - 1535) / 64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.lock.writeLock().lock();
            this.phys.close();
            this.index.close();
            if (this.deleteFilesOnExit) {
                this.phys.deleteFile();
                this.index.deleteFile();
            }
            this.phys = null;
            this.index = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isClosed() {
        return this.index == null;
    }

    protected <A> A recordGet2(long indexValue, Volume data, Serializer<A> serializer) throws IOException {
        long dataPos = indexValue & 0xFFFFFFFFFFFFL;
        int dataSize = (int)(indexValue >>> 48);
        if (dataPos == 0L) {
            return null;
        }
        if (dataSize < 65535) {
            DataInput in = data.getDataInput(dataPos, dataSize);
            A value = serializer.deserialize(in, dataSize);
            if ((long)((DataInput2)in).pos != (long)dataSize + (data.isSliced() ? dataPos % 0x40000000L : 0L)) {
                throw new InternalError("Data were not fully read.");
            }
            return value;
        }
        ArrayList<DataInput> ins = new ArrayList<DataInput>();
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        int recSize = 0;
        long nextLink = indexValue;
        while (nextLink != 0L) {
            int currentSize = (int)(nextLink >>> 48);
            recSize += currentSize - 8;
            DataInput in = data.getDataInput(nextLink & 0xFFFFFFFFFFFFL, currentSize);
            nextLink = ((DataInput2)in).readLong();
            ins.add(in);
            sizes.add(currentSize - 8);
        }
        byte[] b = new byte[recSize];
        int pos = 0;
        for (int i = 0; i < ins.size(); ++i) {
            DataInput2 in = ins.set(i, null);
            int size = (Integer)sizes.get(i);
            in.readFully(b, pos, size);
            pos += size;
        }
        DataInput2 in = new DataInput2(b);
        A value = serializer.deserialize(in, recSize);
        if (in.pos != recSize) {
            throw new InternalError("Data were not fully read.");
        }
        return value;
    }

    protected abstract long longStackTake(long var1) throws IOException;

    protected abstract void longStackPut(long var1, long var3) throws IOException;

    protected abstract long freePhysRecTake(int var1) throws IOException;

    protected void freePhysRecPut(long indexValue) throws IOException {
        if ((indexValue & 0xFFFFFFFFFFFFL) == 0L) {
            throw new InternalError("zero indexValue: ");
        }
        int size = (int)(indexValue >>> 48);
        long listRecid = 20 + this.freePhysRecSize2FreeSlot(size);
        this.longStackPut(listRecid, indexValue);
    }

    protected long findFreePhysSlot(int requiredSize) throws IOException {
        int slot = this.freePhysRecSize2FreeSlot(requiredSize);
        if (requiredSize > 1 && slot == this.freePhysRecSize2FreeSlot(requiredSize - 1)) {
            ++slot;
        }
        while (slot < 2535) {
            long v = this.longStackTake(20 + slot);
            if (v != 0L) {
                int foundRecSize = (int)(v >>> 48);
                if (foundRecSize != requiredSize) {
                    long newIndexValue = (long)(foundRecSize - requiredSize) << 48 | (v & 0xFFFFFFFFFFFFL) + (long)requiredSize;
                    this.freePhysRecPut(newIndexValue);
                }
                return v & 0xFFFFFFFFFFFFL | (long)requiredSize << 48;
            }
            ++slot;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        try {
            this.lock.writeLock().lock();
            A oldVal = this.get(recid, serializer);
            if (oldVal == null && expectedOldValue == null || oldVal != null && oldVal.equals(expectedOldValue)) {
                this.update(recid, newValue, serializer);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public long serializerRecid() {
        return 4L;
    }

    public long nameDirRecid() {
        return 19L;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void unlinkPhysRecord(long indexVal) throws IOException {
        int size = (int)(indexVal >>> 48);
        if (size == 0) {
            return;
        }
        if (size < 65535) {
            this.freePhysRecPut(indexVal);
        } else {
            while (indexVal != 0L) {
                long nextIndexVal = this.phys.getLong(indexVal & 0xFFFFFFFFFFFFL);
                this.freePhysRecPut(indexVal);
                indexVal = nextIndexVal;
            }
        }
    }
}

