/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.Locks;
import org.mapdb.Serializer;
import org.mapdb.Utils;

public class CacheHashTable
extends EngineWrapper
implements Engine {
    protected final Locks.RecidLocks locks = new Locks.SegmentedRecidLocks(16);
    protected HashItem[] items;
    protected final int cacheMaxSize;

    public CacheHashTable(Engine engine, int cacheMaxSize) {
        super(engine);
        this.items = new HashItem[cacheMaxSize];
        this.cacheMaxSize = cacheMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        long recid = this.engine.put(value, serializer);
        int pos = this.position(recid);
        try {
            this.locks.lock(pos);
            this.items[this.position((long)recid)] = new HashItem(recid, value);
        }
        finally {
            this.locks.unlock(pos);
        }
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        int pos = this.position(recid);
        HashItem item = this.items[pos];
        if (item != null && recid == item.key) {
            return (A)item.val;
        }
        try {
            this.locks.lock(pos);
            A value = this.engine.get(recid, serializer);
            if (value != null) {
                this.items[pos] = new HashItem(recid, value);
            }
            A a = value;
            return a;
        }
        finally {
            this.locks.unlock(pos);
        }
    }

    private int position(long recid) {
        return Math.abs(Utils.longHash(recid)) % this.cacheMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        int pos = this.position(recid);
        try {
            this.locks.lock(pos);
            this.items[pos] = new HashItem(recid, value);
            this.engine.update(recid, value, serializer);
        }
        finally {
            this.locks.unlock(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        int pos = this.position(recid);
        try {
            this.locks.lock(pos);
            HashItem item = this.items[pos];
            if (item != null && item.key == recid) {
                if (item.val == null && expectedOldValue != null) {
                    boolean bl = false;
                    return bl;
                }
                if (item.val == expectedOldValue || item.val.equals(expectedOldValue)) {
                    this.items[pos] = new HashItem(recid, newValue);
                    this.engine.update(recid, newValue, serializer);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean ret = this.engine.compareAndSwap(recid, expectedOldValue, newValue, serializer);
            if (ret) {
                this.items[pos] = new HashItem(recid, newValue);
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.locks.unlock(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(long recid) {
        int pos = this.position(recid);
        try {
            this.locks.lock(recid);
            this.engine.delete(recid);
            HashItem item = this.items[pos];
            if (item != null && recid == item.key) {
                this.items[pos] = null;
            }
        }
        finally {
            this.locks.unlock(recid);
        }
    }

    @Override
    public void close() {
        this.engine.close();
        this.engine = null;
        this.items = null;
    }

    @Override
    public void rollback() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = null;
        }
        this.engine.rollback();
    }

    private static class HashItem {
        final long key;
        final Object val;

        private HashItem(long key, Object val) {
            this.key = key;
            this.val = val;
        }
    }
}

