/*
 * Decompiled with CFR 0.152.
 */
package medusa.stringconnection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Iterator;
import medusa.graph.Graph;
import medusa.graph.Node;

public class Annotator
implements Runnable {
    private Thread me;
    private boolean done;
    private String url;
    private int port;
    private Graph selection;
    private StringBuffer sb;
    private float cutoff;
    int progress = 0;

    public Annotator(String url, int port, Graph selection) {
        this.url = url;
        this.port = port;
        this.selection = selection;
        this.cutoff = this.cutoff;
    }

    public int getMax() {
        return this.selection.getNodeSize();
    }

    public StringBuffer getAnnotation() {
        return this.sb;
    }

    public void start() {
        if (this.me == null) {
            this.me = new Thread(this);
        }
        this.me.start();
    }

    public void stop() {
        if (this.me != null) {
            this.me = null;
        }
    }

    @Override
    public void run() {
        Thread myThread = Thread.currentThread();
        this.done = false;
        if (this.me == myThread) {
            try {
                this.getAnnotationFromString();
            }
            catch (IOException ie) {
                this.sb = new StringBuffer();
            }
            this.done = true;
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean isDone() {
        return this.done;
    }

    public void getAnnotationFromString() throws IOException {
        String inLine;
        Node node;
        this.sb = new StringBuffer();
        Socket stringSocket = new Socket(this.url, this.port);
        PrintWriter out = new PrintWriter(stringSocket.getOutputStream(), true);
        BufferedReader in = new BufferedReader(new InputStreamReader(stringSocket.getInputStream()));
        StringBuffer transferSB = new StringBuffer();
        Iterator<Node> i = this.selection.nodesIterator();
        while (i.hasNext()) {
            node = i.next();
            transferSB.append("NODE:");
            transferSB.append(node.getLabel());
            transferSB.append("\n");
        }
        transferSB.append("bye");
        out.println(transferSB);
        while (!in.ready()) {
        }
        while ((inLine = in.readLine()) != null) {
            String[] parts;
            if (inLine.length() > 10 && (node = this.selection.getNode((parts = inLine.split("\t"))[0])) != null) {
                node.setAnnotation(parts[1]);
            }
            ++this.progress;
        }
        out.close();
        in.close();
        stringSocket.close();
    }
}

