/*
 * Decompiled with CFR 0.152.
 */
package medusa.stringconnection;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import medusa.MedusaSimplerFrame;

public class AnimPanel
extends JPanel
implements Runnable {
    BufferedImage image = null;
    int anchorX;
    int anchorY;
    String text;
    Font nodeFont = new Font("TimesNewRoman", 2, 28);
    double rotation = 0.0;
    Thread spinThread;

    public AnimPanel() {
        this("/medusa/images/logo_still_p.gif");
    }

    public AnimPanel(String imageName, String greeting) {
        this.setImage(imageName);
        this.text = greeting;
        this.init();
    }

    public AnimPanel(String imageName) {
        System.out.println("sending " + imageName);
        this.setImage(imageName);
        this.init();
    }

    private void init() {
        this.setBackground(MedusaSimplerFrame.STRINGCOLOR);
        this.setOpaque(true);
        this.anchorX = this.image.getWidth(this) / 2;
        this.anchorY = this.image.getHeight(this) / 2;
        this.setPreferredSize(new Dimension(this.image.getWidth(this), this.image.getHeight(this)));
    }

    private void setImage(String imageURL) {
        try {
            System.out.println(imageURL);
            this.image = ImageIO.read(this.getClass().getResource(imageURL));
        }
        catch (Exception ex) {
            this.image = null;
            ex.printStackTrace();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.clear(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform rotate45 = AffineTransform.getRotateInstance(Math.PI * Math.sin(this.rotation), this.anchorX, this.anchorY);
        if (this.image != null) {
            g2d.drawImage(this.image, rotate45, this);
        }
        g2d.setColor(Color.yellow);
        g2d.setFont(this.nodeFont);
        if (this.text != null) {
            g2d.drawString(this.text, 5, this.image.getHeight(this));
        }
    }

    protected void clear(Graphics g) {
        super.paintComponent(g);
    }

    public void start() {
        if (this.spinThread == null) {
            this.spinThread = new Thread(this);
        }
        this.spinThread.start();
    }

    @Override
    public void run() {
        Thread myThread = Thread.currentThread();
        while (this.spinThread == myThread) {
            this.rotation += 0.02;
            this.repaint();
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void stop() {
        this.rotation = 0.0;
        if (this.spinThread != null) {
            this.spinThread = null;
        }
    }
}

