/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.ClusteringAlgorithms;

import medusa.georgios.ClusteringAlgorithms.Clustering_NJ_UPGMA;
import medusa.georgios.ClusteringAlgorithms.UPCluster;

public class UPGMA {
    int K;
    UPCluster[] cluster;
    public StringBuffer NHX = new StringBuffer("");

    public UPGMA(float[][] ds) {
        int N = ds.length;
        this.cluster = new UPCluster[2 * N - 1];
        for (int i = 0; i < N; ++i) {
            this.cluster[i] = new UPCluster(i, ds[i]);
        }
        this.K = N;
        while (this.K < 2 * N - 1) {
            this.findAndJoin();
        }
    }

    public UPCluster getRoot() {
        return this.cluster[this.K - 1];
    }

    public float d(int i, int j) {
        return this.cluster[Math.max((int)i, (int)j)].dmat[Math.min(i, j)];
    }

    void findAndJoin() {
        int mini = -1;
        int minj = -1;
        float mind = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.K; ++i) {
            if (!this.cluster[i].live()) continue;
            for (int j = 0; j < i; ++j) {
                float d;
                if (!this.cluster[j].live() || !((d = this.d(i, j)) < mind)) continue;
                mind = d;
                mini = i;
                minj = j;
            }
        }
        this.join(mini, minj);
    }

    public void join(int i, int j) {
        float[] dmat = new float[this.K];
        for (int m = 0; m < this.K; ++m) {
            if (!this.cluster[m].live() || m == i || m == j) continue;
            dmat[m] = (this.d(i, m) * (float)this.cluster[i].card + this.d(j, m) * (float)this.cluster[j].card) / (float)(this.cluster[i].card + this.cluster[j].card);
        }
        this.cluster[this.K] = new UPCluster(this.K, this.cluster[i], this.cluster[j], this.d(i, j) / 2.0f, dmat);
        this.cluster[i].kill();
        this.cluster[j].kill();
        ++this.K;
    }

    public boolean is_internal(UPCluster cluster2) {
        return cluster2.left != null || cluster2.right != null;
    }

    public String NewickFormat(UPCluster cluster2) {
        if (this.is_internal(cluster2)) {
            this.NHX.append("(");
            this.NewickFormat(cluster2.left);
        }
        if (this.is_internal(cluster2)) {
            this.NHX.append(",");
        } else {
            this.NHX.append(Clustering_NJ_UPGMA.labels.get(cluster2.lab - 1));
        }
        if (this.is_internal(cluster2)) {
            this.NewickFormat(cluster2.right);
            this.NHX.append(")");
        }
        return this.NHX.toString() + ";";
    }
}

