/*
 * Decompiled with CFR 0.152.
 */
package medusa.example;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Animation {
    private ArrayList<AnimFrame> frames = new ArrayList();
    private int currentFrameIndex;
    private long animTime;
    private long totalDuration = 0L;

    public Animation() {
        this.start();
    }

    public synchronized void addShape(Shape shape, long duration) {
        this.totalDuration += duration;
        this.frames.add(new AnimFrame(shape, this.totalDuration));
    }

    public synchronized void start() {
        this.animTime = 0L;
        this.currentFrameIndex = 0;
    }

    public synchronized void update(long elapsedTime) {
        if (this.frames.size() > 1) {
            this.animTime += elapsedTime;
            if (this.animTime >= this.totalDuration) {
                this.animTime %= this.totalDuration;
                this.currentFrameIndex = 0;
            }
            while (this.animTime > this.getFrame((int)this.currentFrameIndex).endTime) {
                ++this.currentFrameIndex;
            }
        }
    }

    public synchronized Shape getShape() {
        if (this.frames.size() == 0) {
            return null;
        }
        return this.getFrame((int)this.currentFrameIndex).shape;
    }

    private AnimFrame getFrame(int i) {
        return this.frames.get(i);
    }

    public void initDefault() {
        int i;
        int w = 10;
        int h = 10;
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, w, h);
        for (i = 0; i < 10; ++i) {
            this.addShape(new Rectangle2D.Double(0.0, 0.0, w, h - i), 200L);
        }
        for (i = 0; i < 10; ++i) {
            this.addShape(new Rectangle2D.Double(0.0, 0.0, w, i), 200L);
        }
    }

    private class AnimFrame {
        Shape shape;
        long endTime;

        public AnimFrame(Shape shape, long endTime) {
            this.shape = shape;
            this.endTime = endTime;
        }
    }
}

