/*
 * Decompiled with CFR 0.152.
 */
package medusa.display;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import medusa.graph.Node;

public class PaintTools {
    private static void drawArrow(Graphics2D g, int x1, int y1, int x2, int y2, double orientation, double offset) {
        int headLength = 9;
        int headWidth = 6;
        double theta2 = PaintTools.getTheta(x1, x2, y1, y2);
        int lengthdeltaX = -((int)(Math.cos(theta2 -= orientation * offset) * (double)headLength));
        int lengthdeltaY = -((int)(Math.sin(theta2) * (double)headLength));
        int widthdeltaX = (int)(Math.sin(theta2) * (double)headWidth);
        int widthdeltaY = (int)(Math.cos(theta2) * (double)headWidth);
        int[] xpoints = new int[]{(x2 -= (int)(Math.cos(theta2) * (double)headLength)) + lengthdeltaX + widthdeltaX, x2, x2 + lengthdeltaX - widthdeltaX};
        int[] ypoints = new int[]{(y2 -= (int)(Math.sin(theta2) * (double)headLength)) + lengthdeltaY - widthdeltaY, y2, y2 + lengthdeltaY + widthdeltaY};
        int npoints = 3;
        g.fillPolygon(xpoints, ypoints, npoints);
    }

    public static double getTheta(int x1, int x2, int y1, int y2) {
        int deltaX = x2 - x1;
        int deltaY = y2 - y1;
        double theta = Math.atan((double)deltaY / (double)deltaX);
        if ((double)deltaX < 0.0) {
            theta += Math.PI;
        }
        return theta;
    }

    private static void drawStop(Graphics2D g, int x1, int y1, int x2, int y2, double orientation, double offset) {
        int headLength = 9;
        int headWidth = 6;
        double theta2 = PaintTools.getTheta(x1, x2, y1, y2);
        int lengthdeltaX = -((int)(Math.cos(theta2 -= orientation * offset) * (double)headLength));
        int lengthdeltaY = -((int)(Math.sin(theta2) * (double)headLength));
        int widthdeltaX = (int)(Math.sin(theta2) * (double)headWidth);
        int widthdeltaY = (int)(Math.cos(theta2) * (double)headWidth);
        g.drawLine((x2 -= (int)(Math.cos(theta2) * (double)headLength)) + lengthdeltaX + widthdeltaX, (y2 -= (int)(Math.sin(theta2) * (double)headLength)) + lengthdeltaY - widthdeltaY, x2 + lengthdeltaX - widthdeltaX, y2 + lengthdeltaY + widthdeltaY);
    }

    public static Polygon rhomb(int x, int y, int nodeSize) {
        int offset = 2;
        int x1 = x + nodeSize / 2;
        int x2 = x + nodeSize + offset;
        int y1 = y + nodeSize / 2;
        int y2 = y + nodeSize;
        int[] xpoints = new int[]{x - offset, x1, x2, x1};
        int[] ypoints = new int[]{y1, y2, y1, y};
        int npoints = 4;
        return new Polygon(xpoints, ypoints, npoints);
    }

    public static Polygon triangle(int x, int y, int nodeSize) {
        int x1 = x + nodeSize / 2;
        int x2 = x + nodeSize;
        int y2 = y + nodeSize;
        int[] xpoints = new int[]{x, x2, x1};
        int[] ypoints = new int[]{y2, y2, y};
        int npoints = 3;
        return new Polygon(xpoints, ypoints, npoints);
    }

    public static Shape getShape(int i, int x, int y, int nodeSize) {
        switch (i) {
            case 0: {
                return new Ellipse2D.Double(x, y, nodeSize, nodeSize);
            }
            case 1: {
                return new Rectangle2D.Double(x, y, nodeSize, nodeSize);
            }
            case 2: {
                return PaintTools.triangle(x, y, nodeSize);
            }
            case 3: {
                return PaintTools.rhomb(x, y, nodeSize);
            }
        }
        return new Ellipse2D.Double(x, y, nodeSize, nodeSize);
    }

    public static void drawCompositeNode(Graphics2D g2d, Node n, int nodeSize) {
        int corr = (int)((double)nodeSize / 2.0);
        int x = (int)n.getX();
        int y = (int)n.getY();
        Color c2 = n.getColor2();
        Color c3 = n.getColor3();
        Rectangle2D.Double nodeR = new Rectangle2D.Double(x - corr, y - corr, nodeSize, nodeSize);
        g2d.setColor(n.getColor());
        g2d.fill(nodeR);
        if (c2 != null) {
            g2d.setColor(c2);
            g2d.fill(new Rectangle2D.Double(x, y - corr, nodeSize - corr, nodeSize));
        }
        if (c3 != null) {
            g2d.setColor(c3);
            g2d.fill(new Rectangle2D.Double(x - corr, y, nodeSize, nodeSize - corr));
        }
        if (n.isFixed()) {
            g2d.setColor(Color.yellow);
        } else {
            g2d.setColor(Color.black);
        }
        g2d.draw(nodeR);
    }

    private static void drawCircle(Graphics2D g, int x1, int y1, int x2, int y2, double orientation, double offset) {
        int headLength = 12;
        int headWidth = 6;
        int circleWidth = 6;
        double theta2 = PaintTools.getTheta(x1, x2, y1, y2);
        int lengthdeltaX = -((int)(Math.cos(theta2 -= orientation * offset) * (double)headLength));
        int lengthdeltaY = -((int)(Math.sin(theta2) * (double)headLength));
        x2 -= (int)(Math.cos(theta2) * (double)headLength);
        y2 -= (int)(Math.sin(theta2) * (double)headLength);
        Ellipse2D.Double circle = new Ellipse2D.Double(x2 -= circleWidth / 2, y2 -= circleWidth / 2, circleWidth, circleWidth);
        g.fill(circle);
    }

    public static void paintPath(Graphics2D g2d, int x1, int y1, int x2, int y2, double orientation, double offset, boolean arrow) {
        PaintTools.paintPath(g2d, x1, y1, x2, y2, orientation, offset, arrow, false);
    }

    public static void paintPath(Graphics2D g2d, int x1, int y1, int x2, int y2, double orientation, double offset, boolean arrow, boolean label) {
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        double len = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        double radius = len / 4.0;
        if (orientation != 0.0) {
            double[] cPoints = PaintTools.controlPoints(x1, y1, x2, y2, orientation, offset);
            CubicCurve2D.Double path = new CubicCurve2D.Double(x1, y1, cPoints[0], cPoints[1], cPoints[2], cPoints[3], x2, y2);
            g2d.draw(path);
        } else {
            g2d.drawLine(x1, y1, x2, y2);
        }
        if (arrow) {
            PaintTools.drawArrow(g2d, x1, y1, x2, y2, orientation, offset);
        }
    }

    public static void PaintPathWithConfLabel(Graphics2D g2d, int x1, int y1, int x2, int y2, double orientation, double offset, boolean arrow, boolean label) {
        g2d.drawLine(x1, y1, x2, y2);
        int halfx = (x1 + x2) / 2;
        int halfy = (y1 + y2) / 2;
        g2d.setColor(Color.WHITE);
        g2d.drawRect(halfx, halfy, 10, 10);
    }

    public static double[] controlPoints(int x1, int y1, int x2, int y2, double orientation, double offset) {
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        double len = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        double radius = len / 4.0;
        double theta = Math.atan(deltaY / deltaX);
        if (deltaX < 0.0) {
            theta += Math.PI;
        }
        double theta2 = theta + Math.PI;
        double[] result = new double[4];
        result[2] = (double)x2 + Math.cos(theta2 -= orientation * offset) * radius;
        result[3] = (double)y2 + Math.sin(theta2) * radius;
        result[0] = (double)x1 + Math.cos(theta += orientation * offset) * radius;
        result[1] = (double)y1 + Math.sin(theta) * radius;
        return result;
    }

    public static int[] intControlPoints(int x1, int y1, int x2, int y2, double orientation, double offset) {
        double[] db = PaintTools.controlPoints(x1, y1, x2, y2, orientation, offset);
        int[] ib = new int[]{(int)db[0], (int)db[1], (int)db[2], (int)db[3]};
        return ib;
    }

    public static void paintRegulatoryPath(Graphics2D g2d, int x1, int y1, int x2, int y2, double orientation, double offset, int shape) {
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        double len = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        double radius = len / 4.0;
        if (orientation != 0.0) {
            double theta = Math.atan(deltaY / deltaX);
            if (deltaX < 0.0) {
                theta += Math.PI;
            }
            double theta2 = theta + Math.PI;
            double cx2 = (double)x2 + Math.cos(theta2 -= orientation * offset) * radius;
            double cy2 = (double)y2 + Math.sin(theta2) * radius;
            double cx1 = (double)x1 + Math.cos(theta += orientation * offset) * radius;
            double cy1 = (double)y1 + Math.sin(theta) * radius;
            CubicCurve2D.Double path = new CubicCurve2D.Double(x1, y1, cx1, cy1, cx2, cy2, x2, y2);
            g2d.draw(path);
        } else {
            g2d.drawLine(x1, y1, x2, y2);
        }
        switch (shape) {
            case 1: {
                PaintTools.drawArrow(g2d, x1, y1, x2, y2, orientation, offset);
                break;
            }
            case 2: {
                PaintTools.drawStop(g2d, x1, y1, x2, y2, orientation, offset);
                break;
            }
            case 3: {
                PaintTools.drawCircle(g2d, x1, y1, x2, y2, orientation, offset);
            }
        }
    }

    public static String psRhomb(int x, int y, int nodeSize) {
        int correct = (int)((double)nodeSize / 2.0);
        StringBuffer sb = new StringBuffer();
        int offset = 2;
        int x1 = x - correct;
        int x2 = x;
        int x3 = x + correct;
        int y1 = y;
        int y2 = y + correct;
        int y3 = y - correct;
        sb.append("newpath\n");
        sb.append(x1 + " " + y1 + " moveto\n");
        sb.append(x2 + " " + y2 + " lineto\n");
        sb.append(x3 + " " + y1 + " lineto\n");
        sb.append(x2 + " " + y3 + " lineto\n");
        sb.append("closepath\n");
        sb.append("gsave\n");
        sb.append("fill\n");
        sb.append("grestore\n");
        sb.append("0 0 0 setrgbcolor\n");
        sb.append("1 setlinewidth\n");
        sb.append("stroke\n");
        return sb.toString();
    }

    public static String psTriangle(int x, int y, int nodeSize) {
        StringBuffer sb = new StringBuffer();
        int correct = (int)((double)nodeSize / 2.0);
        int x1 = x - correct;
        int x2 = x;
        int x3 = x + correct;
        int y1 = y - correct;
        int y2 = y + correct;
        sb.append("newpath\n");
        sb.append(x1 + " " + y1 + " moveto\n");
        sb.append(x2 + " " + y2 + " lineto\n");
        sb.append(x3 + " " + y1 + " lineto\n");
        sb.append("closepath\n");
        sb.append("gsave\n");
        sb.append("fill\n");
        sb.append("grestore\n");
        sb.append("1 setlinewidth\n");
        sb.append("0 0 0 setrgbcolor\n");
        sb.append("stroke\n");
        return sb.toString();
    }

    public static String psRectangle(int x, int y, int nodeSize) {
        StringBuffer sb = new StringBuffer();
        int correct = (int)((double)nodeSize / 2.0);
        int x1 = x - correct;
        int x2 = x + correct;
        int y1 = y - correct;
        int y2 = y + correct;
        sb.append("newpath\n");
        sb.append(x1 + " " + y1 + " moveto\n");
        sb.append(x1 + " " + y2 + " lineto\n");
        sb.append(x2 + " " + y2 + " lineto\n");
        sb.append(x2 + " " + y1 + " lineto\n");
        sb.append("closepath\n");
        sb.append("gsave\n");
        sb.append("fill\n");
        sb.append("grestore\n");
        sb.append("1 setlinewidth\n");
        sb.append("0 0 0 setrgbcolor\n");
        sb.append("stroke\n");
        return sb.toString();
    }

    public static String psCircle(int x, int y, int nodeSize) {
        StringBuffer sb = new StringBuffer();
        int correct = (int)((double)nodeSize / 2.0);
        sb.append("newpath\n");
        sb.append(x + " " + y + " " + correct + " 0 360 arc closepath fill stroke\n");
        sb.append("0 0 0 setrgbcolor\n");
        sb.append("1 setlinewidth\n");
        sb.append(x + " " + y + " " + correct + " 0 360 arc closepath stroke\n");
        return sb.toString();
    }
}

