/*
 * Decompiled with CFR 0.152.
 */
package medusa.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import medusa.DataFormatException;
import medusa.MedusaSettings;
import medusa.dataio.DataLoader;
import medusa.display.BasicGraphPanel;
import medusa.display.EdgeDialog;
import medusa.display.PaintTools;
import medusa.graph.Edge;
import medusa.graph.Graph;
import medusa.graph.Node;

public class DisplayPanel
extends BasicGraphPanel {
    BufferedImage image = null;
    Image tempImage = null;
    public boolean showBorder = true;
    protected boolean showName = true;
    Frame f = new Frame();
    int startx;
    int starty;
    int endx;
    int endy;
    boolean drawTempLine = false;
    Node temp1 = null;
    Node temp2 = null;
    boolean[] showEdges;
    int border = 10;
    JPopupMenu popup;
    JMenuItem removeItem;
    JMenuItem editColorItem;
    JMenuItem editShapeItem;
    JMenuItem setAnnotationItem;
    JMenuItem getPositionItem;
    DataLoader dl = new DataLoader(this.getPanelWidth(), this.getPanelHeight());

    public DisplayPanel(MedusaSettings stringSettings) {
        super(stringSettings);
        this.initPopup();
        this.tryImage();
        this.initShow();
    }

    public DisplayPanel() {
        this.initPopup();
        this.tryImage();
        this.initShow();
    }

    private void tryImage() {
        try {
            this.setImage();
            this.tempImage = this.image;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setImage() throws IOException {
        this.setImage("netview_default.png");
    }

    public void setImage(String imageURL) throws IOException {
        File imageFile = new File(imageURL);
        this.image = ImageIO.read(imageFile);
    }

    public void setImage(BufferedImage myImage) throws InterruptedException {
        this.image = myImage;
    }

    public void clearImage() {
        this.image = null;
    }

    public void drawBackgroundImage(Graphics2D g2d) {
        if (this.image == null) {
            return;
        }
        g2d.drawImage(this.image, 0, 0, this.getPanelWidth(), this.getPanelHeight(), null);
    }

    @Override
    public void paintEdge(Graphics2D g, Edge e) {
        if (!this.showEdges[e.getType() - 1]) {
            return;
        }
        Node from = this.getGraph().getNode(e.getFromName());
        Node to = this.getGraph().getNode(e.n2);
        int x1 = (int)from.getX();
        int y1 = (int)from.getY();
        int x2 = (int)to.getX();
        int y2 = (int)to.getY();
        if (this.showConfidence) {
            if (this.alpha) {
                g.setComposite(this.makeComposite(e.getConf()));
            } else {
                g.setStroke(this.getStroke(e.getConf()));
            }
        }
        g.setPaint(this.basicEdgeColor);
        if (this.pretty) {
            g.setPaint(this.getColor(new Integer(e.getType())));
            PaintTools.paintPath(g, x1, y1, x2, y2, e.getOrientation(), 0.3, this.arrow);
        } else {
            g.drawLine(x1, y1, x2, y2);
        }
    }

    public void setShowBorder(boolean show) {
        this.showBorder = show;
    }

    @Override
    public void paintNet(Graphics2D g2d) {
        this.drawBackgroundImage(g2d);
        if (this.showBorder) {
            Rectangle2D.Double border = new Rectangle2D.Double(2.0, 2.0, this.getPanelWidth(), this.getPanelHeight());
            g2d.draw(border);
        }
        Iterator<Edge> edges = this.graph.edgesIterator();
        while (edges.hasNext()) {
            Edge e = edges.next();
            int col = e.getType();
            if (!this.showEdges[col - 1]) continue;
            this.paintEdge(g2d, e);
        }
        g2d.setComposite(this.makeComposite(1.0f));
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            this.paintNode(g2d, node);
        }
    }

    @Override
    public void saveImage(String path, int param) {
        this.setShowBorder(false);
        super.saveImage(path, param);
        this.setShowBorder(true);
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(new BasicStroke(1.0f));
        this.clear(g2d);
        if (this.hideWhenMove) {
            if (!this.running & this.pick != null) {
                this.paintPick(g2d);
            } else {
                this.paintNet(g2d);
            }
        } else {
            this.paintNet(g2d);
        }
        this.drawBox(g2d);
        if (this.drawTempLine) {
            float[] dashPattern = new float[]{2.0f, 3.0f, 2.0f, 3.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f));
            g2d.drawLine(this.startx, this.starty, this.endx, this.endy);
        }
        g2d.setStroke(new BasicStroke(1.0f));
    }

    protected void drawBox(Graphics2D g2d) {
        if (this.getCurrentRect() != null) {
            g2d.setXORMode(Color.red);
            float[] dashPattern = new float[]{2.0f, 3.0f, 2.0f, 3.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f));
            g2d.drawRect(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width - 1, this.rectToDraw.height - 1);
        }
    }

    public void setShowName(boolean b) {
        this.showName = b;
        this.showAnnotation = !b;
    }

    @Override
    public void paintNode(Graphics2D g, Node n) {
        g.setStroke(new BasicStroke(1.0f));
        g.setPaint(n.getColor());
        int x = (int)n.getX() - this.correct;
        int y = (int)n.getY() - this.correct;
        Shape shape = PaintTools.getShape(n.getShape(), x, y, this.nodeSize);
        g.fill(shape);
        g.setPaint(Color.black);
        if (n.isFixed()) {
            g.setPaint(Color.yellow);
        }
        g.draw(shape);
        g.setPaint(this.fontColor);
        g.setFont(this.nodeFont);
        if (this.label) {
            if (this.showName) {
                g.drawString(n.getLabel(), x - 2, y - 2);
            } else {
                g.drawString(n.getAnnotation(), x - 2, y - 2);
            }
        }
    }

    private void handleRightMouseDragged(MouseEvent e) {
        if ((e.getModifiers() & 4) != 0) {
            this.drawTempLine = true;
            this.endx = e.getX();
            this.endy = e.getY();
            this.repaint();
        }
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.handleLeftMouseDragged(e);
        this.handleRightMouseDragged(e);
    }

    public void handleReleaseRightButton(MouseEvent e) {
        if (e.getButton() != 3) {
            return;
        }
        this.removeMouseMotionListener(this);
        Node node = this.getClosest(e);
        this.temp2 = node != null ? node : new Node("unnamed", e.getX(), e.getY());
        this.drawTempLine = false;
        this.endx = e.getX();
        this.endy = e.getY();
        if (this.temp1 != this.temp2) {
            this.addEdge();
            this.repaint();
            this.temp1 = null;
            this.temp2 = null;
        } else {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handleReleaseLeftButton(e);
        this.handleReleaseRightButton(e);
    }

    private void handlePressRightButton(MouseEvent e) {
        if (e.getButton() == 3) {
            this.addMouseMotionListener(this);
            Node node = this.getClosest(e);
            if (node != null) {
                this.temp1 = node;
                this.startx = (int)this.temp1.getX();
                this.starty = (int)this.temp1.getY();
            } else {
                this.startx = e.getX();
                this.starty = e.getY();
                this.temp1 = new Node("unnamed", this.startx, this.starty);
            }
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handlePressLeftButton(e);
        this.handlePressRightButton(e);
    }

    protected void addEdge() {
        Edge e = EdgeDialog.showDialog(this.f, null, this.temp1, this.temp2, this.getStringSettings());
        if (e != null) {
            this.temp1.setLabel(e.getFromName());
            this.temp2.setLabel(e.getToName());
            this.graph.addEdge(e);
            this.graph.setNode(this.temp1);
            this.graph.setNode(this.temp2);
            this.updateNodes();
        }
    }

    public void initShow() {
        int max = 20;
        this.showEdges = new boolean[20];
        for (int i = 0; i < 20; ++i) {
            this.showEdges[i] = true;
        }
    }

    public void setShowEdge(int i, boolean b) {
        this.showEdges[i] = b;
    }

    public void setHideEdge(int i, boolean b) {
        this.showEdges[i] = !b;
    }

    public void setShape(int shape) {
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            if (!node.isFixed()) continue;
            node.setShape(shape);
        }
    }

    private void initPopup() {
        this.popup = new JPopupMenu("Edit data");
        this.removeItem = new JMenuItem("Delete");
        this.editColorItem = new JMenuItem("Color");
        this.editShapeItem = new JMenuItem("Shape");
        this.setAnnotationItem = new JMenuItem("Annotation");
        this.getPositionItem = new JMenuItem("Position");
        this.removeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DisplayPanel.this.temp1 != null) {
                    DisplayPanel.this.removeEdgeByLabel(DisplayPanel.this.temp1.getLabel());
                    DisplayPanel.this.temp1 = null;
                    DisplayPanel.this.temp2 = null;
                    DisplayPanel.this.repaint();
                } else {
                    System.out.println("node is null, for some strange reason");
                }
            }
        });
        this.editColorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(DisplayPanel.this.getRootPane(), "Choose node color", DisplayPanel.this.temp1.getColor());
                if (newColor != null) {
                    DisplayPanel.this.temp1.setColor(newColor);
                }
                DisplayPanel.this.repaint();
            }
        });
        this.editShapeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayPanel.this.temp1.setShape(DisplayPanel.this.chooseShape());
                DisplayPanel.this.repaint();
            }
        });
        this.setAnnotationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayPanel.this.setAnnotation(DisplayPanel.this.temp1);
            }
        });
        this.getPositionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayPanel.this.getPosition(DisplayPanel.this.temp1);
            }
        });
        this.popup.add(this.removeItem);
        this.popup.addSeparator();
        this.popup.add(this.editColorItem);
        this.popup.add(this.editShapeItem);
        this.popup.add(this.setAnnotationItem);
        this.popup.add(this.getPositionItem);
    }

    private void getPosition(Node temp) {
        JOptionPane.showMessageDialog(this, "x: " + temp.getX() + " y:" + temp.getY());
    }

    private void setAnnotation(Node temp) {
        String s = JOptionPane.showInputDialog("View or edit node annotation:\n", (Object)temp.getAnnotation());
        if (s != null && s.length() > 0) {
            temp.setAnnotation(s);
        }
    }

    private int chooseShape() {
        Object[] shapes = new Object[]{"circle", "rectangle", "triangle", "diamond"};
        int s = JOptionPane.showOptionDialog(this, "Choose a node shape", "Shape", 1, 3, null, shapes, "circle");
        return s;
    }

    @Override
    public void updateStringSettings(MedusaSettings ss) {
        this.setStringSettings(ss);
    }

    private void showPopup(MouseEvent e) {
        this.popup.show(e.getComponent(), e.getX(), e.getY());
        e.consume();
    }

    public ArrayList getFixed() {
        return this.graph.getFixed();
    }

    public void copyNodeSettings(Graph g) {
        this.graph.copyNodeSettings(g);
    }

    public void removeEdgeByLabel(String label) {
        this.graph.removeEdgeByLabel(label);
    }

    public void removeFixedNodes() {
        this.graph.removeFixed();
    }

    public void crop(double confidence) {
        this.graph.cropEdges(confidence);
        this.calculateEdgeLength();
    }

    @Override
    public boolean findLabel(String expression) {
        Pattern labelPattern = Pattern.compile(expression);
        if (expression.compareTo("") == 0) {
            return false;
        }
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            Matcher matcher = labelPattern.matcher(node.getLabel());
            node.setFixed(false);
            if (!matcher.find()) continue;
            node.setFixed(true);
        }
        return true;
    }

    public void markNode(Graphics2D g2d, Node markedNode) {
        if (markedNode == null) {
            return;
        }
        int refX = this.getPanelWidth() / 2;
        int refY = this.getPanelHeight() / 2;
        double r45 = 0.4487989505128276;
        double deltaLength = 15.0;
        double headLength = 13.0;
        double x = markedNode.getX();
        double y = markedNode.getY();
        double deltaX = x - (double)refX;
        double deltaY = -(y - (double)refY);
        double theta = Math.atan(deltaY / deltaX);
        if (deltaX < 0.0) {
            theta += Math.PI;
        }
        int xh = (int)(x - deltaLength * Math.cos(theta));
        int yh = (int)(y + deltaLength * Math.sin(theta));
        int xc = (int)((double)xh - headLength * Math.cos(theta - r45));
        int yc = (int)((double)yh + headLength * Math.sin(theta - r45));
        int xa = (int)((double)xh - headLength * Math.cos(theta + r45));
        int ya = (int)((double)yh + headLength * Math.sin(theta + r45));
        int shad = 3;
        int[] xpoints = new int[]{xc, xh, xa};
        int[] ypoints = new int[]{yc, yh, ya};
        int[] shadowX = new int[]{xc + shad, xh + shad, xa + shad};
        int[] shadowY = new int[]{yc + shad, yh + shad, ya + shad};
        int npoints = 3;
        g2d.setColor(Color.black);
        g2d.fillPolygon(shadowX, shadowY, npoints);
        g2d.setColor(Color.orange);
        g2d.fillPolygon(xpoints, ypoints, npoints);
        g2d.setColor(Color.black);
    }

    public int selectNodeByRegExp(String regexp) {
        int matches = 0;
        Pattern labelPattern = Pattern.compile(regexp);
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            Matcher matcher = labelPattern.matcher(node.getLabel());
            if (!matcher.find()) continue;
            node.setFixed(true);
            ++matches;
        }
        return matches;
    }

    public int selectNodeFromFile(String fileName) throws IOException {
        String inLine;
        int matches = 0;
        File loadFile = new File(fileName);
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(loadFile)));
        while ((inLine = in.readLine()) != null) {
            Iterator<Node> it = this.graph.nodesIterator();
            while (it.hasNext()) {
                Node node = it.next();
                if (node.getLabel().compareTo(inLine) != 0) continue;
                ++matches;
                node.setFixed(true);
            }
        }
        in.close();
        return matches;
    }

    public void manipulateColor(int a, int b, boolean doSwitch) {
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            if (!node.isFixed()) continue;
            node.manipulateColorElement(a, b, doSwitch);
        }
    }

    public void addGradientX(int channel) {
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            if (!node.isFixed()) continue;
            int value = (int)(node.getX() / (double)this.getPanelWidth() * 255.0);
            node.manipulateChannel(channel, value);
        }
    }

    public void addGradientY(int channel) {
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            if (!node.isFixed()) continue;
            int value = (int)(node.getY() / (double)this.getPanelWidth() * 255.0);
            node.manipulateChannel(channel, value);
        }
    }

    public void clearGraph() {
        this.graph.clear();
        this.updateNodes();
    }

    public void loadGraph(String fileName) throws IOException, DataFormatException {
        this.graph = this.dl.load(fileName);
        this.updateNodes();
    }

    public void saveGraph(String fileName) throws IOException {
        this.dl.save(this.graph, fileName, this.scale);
        this.updateNodes();
    }

    public void writePajek(String fileName) throws IOException {
        this.dl.saveAsPajek(this.graph, fileName);
    }

    public void writePS(String fileName) throws IOException {
        this.dl.saveAsPS(this.graph, fileName, this.getStringSettings(), this.nodeSize, this.fontSize);
    }

    public void writeEPS(String fileName) throws IOException {
        this.dl.saveAsEPS(this.graph, fileName, this.getStringSettings(), this.nodeSize, this.fontSize);
    }

    public void appendGraph(String fileName) throws IOException, DataFormatException {
        Graph temp = this.dl.load(fileName);
        this.graph.addGraph(temp);
        this.copyNodeSettings(temp);
        this.calculateEdgeLength();
        this.updateNodes();
    }

    public void addGraph(Graph g) {
        if (g == null) {
            return;
        }
        g.rescaleNodes(600);
        this.graph.addGraph(g);
        this.copyNodeSettings(g);
    }
}

