/*
 * Decompiled with CFR 0.152.
 */
package medusa.display;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.Iterator;
import javax.swing.JPanel;
import medusa.MedusaSettings;
import medusa.display.PaintTools;
import medusa.graph.Edge;
import medusa.graph.Graph;
import medusa.graph.Node;

public class BasicGraphRenderer
extends JPanel {
    public boolean alpha = true;
    public boolean arrow = true;
    public Color basicEdgeColor = Color.gray;
    public int nodeSize = 10;
    protected int correct = (int)((double)this.nodeSize / 2.0);
    public Color fontColor = Color.black;
    public int fontSize = 10;
    public Graph graph;
    public boolean hideWhenMove = true;
    public boolean label = true;
    public Font nodeFont = new Font("TimesNewRoman", 0, 10);
    public boolean showAnnotation = false;
    public boolean showConfidence = true;
    private MedusaSettings stringSettings;
    final int defaultSize = 600;
    protected int panelWidth = 600;
    protected int panelHeight = 600;
    public Dimension dims = new Dimension(600, 600);
    public boolean pretty = false;
    private int currentNodeColorSet = 1;

    public void clear(Graphics g) {
        super.paintComponent(g);
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public String[] getGraphData() {
        String[] result = new String[]{new Integer(this.graph.getNodeSize()).toString(), new Integer(this.graph.getEdgeSize()).toString(), new Integer(this.graph.getUniqueEdgeSize()).toString()};
        return result;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.dims;
    }

    public int getPanelHeight() {
        return this.panelHeight;
    }

    public int getPanelWidth() {
        return this.panelWidth;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.dims;
    }

    protected BasicStroke getStroke(float conf) {
        float[] dashPattern1 = new float[]{3.0f, 2.0f, 3.0f, 2.0f};
        float[] dashPattern2 = new float[]{1.0f, 4.0f, 1.0f, 4.0f};
        if ((double)conf > 0.67) {
            return new BasicStroke();
        }
        if ((double)conf > 0.33) {
            return new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern1, 0.0f);
        }
        return new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern2, 0.0f);
    }

    public void setPanelWidth(int panelWidth) {
        this.panelWidth = panelWidth;
    }

    public void setPanelHeight(int panelHeight) {
        this.panelHeight = panelHeight;
    }

    protected AlphaComposite makeComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        Graphics2D g2d = this.prePaint(g);
        this.paintNet(g2d);
    }

    protected Graphics2D prePaint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(new BasicStroke(1.0f));
        this.clear(g2d);
        return g2d;
    }

    public void paintEdge(Graphics2D g, Edge e) {
        Node from = this.graph.getNode(e.getFromName());
        Node to = this.graph.getNode(e.n2);
        int x1 = (int)from.getX();
        int y1 = (int)from.getY();
        int x2 = (int)to.getX();
        int y2 = (int)to.getY();
        if (this.showConfidence) {
            if (this.alpha) {
                g.setComposite(this.makeComposite(e.getConf()));
            } else {
                g.setStroke(this.getStroke(e.getConf()));
            }
        }
        g.setPaint(this.basicEdgeColor);
        if (this.pretty) {
            Integer iii = new Integer(e.getType());
            Color c = this.getStringSettings().getColor(iii);
            g.setPaint(c);
            PaintTools.paintPath(g, x1, y1, x2, y2, e.getOrientation(), 0.3, this.arrow);
        } else {
            g.drawLine(x1, y1, x2, y2);
        }
    }

    public void paintNet(Graphics2D g2d) {
        Iterator<Edge> edges = this.graph.edgesIterator();
        while (edges.hasNext()) {
            Edge e = edges.next();
            this.paintEdge(g2d, e);
        }
        g2d.setComposite(this.makeComposite(1.0f));
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            this.paintNode(g2d, node);
        }
    }

    public void setNodeColorSet(int i) {
        this.currentNodeColorSet = i;
    }

    public int getNodeColorSet() {
        return this.currentNodeColorSet;
    }

    public void paintNode(Graphics2D g, Node n) {
        g.setStroke(new BasicStroke(1.0f));
        g.setPaint(n.getColor(this.currentNodeColorSet));
        int x = (int)n.getX() - this.correct;
        int y = (int)n.getY() - this.correct;
        Shape shape = PaintTools.getShape(n.getShape(), x, y, this.nodeSize);
        g.fill(shape);
        g.setPaint(Color.black);
        if (n.isFixed()) {
            g.setPaint(Color.yellow);
        }
        g.draw(shape);
        g.setPaint(this.fontColor);
        g.setFont(this.nodeFont);
        if (this.label) {
            if (this.showAnnotation) {
                g.drawString(n.getAnnotation(), x - 2, y - 2);
            } else {
                g.drawString(n.getLabel(), x - 2, y - 2);
            }
        }
    }

    public int getCurrentNodeColorSet() {
        return this.currentNodeColorSet;
    }

    public void setCurrentNodeColorSet(int currentNodeColorSet) {
        this.currentNodeColorSet = currentNodeColorSet;
    }

    public MedusaSettings getStringSettings() {
        return this.stringSettings;
    }

    public void setStringSettings(MedusaSettings stringSettings) {
        this.stringSettings = stringSettings;
    }
}

