/*
 * Decompiled with CFR 0.152.
 */
package medusa.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import medusa.DemoTools;
import medusa.MedusaSettings;
import medusa.display.BasicGraphRenderer;
import medusa.display.FRspring;
import medusa.display.PaintTools;
import medusa.graph.Graph;
import medusa.graph.Node;
import medusa.graph.UniqueEdge;

public class BasicGraphPanel
extends BasicGraphRenderer
implements MouseListener,
MouseMotionListener,
Runnable {
    protected Thread relaxThread;
    public boolean running = false;
    Node marked = null;
    ProgressMonitor energyBar;
    ActionListener updateEnergyBar;
    Timer timer;
    public static final double offset = 0.3;
    double edgeLen;
    protected double scale = 1.0;
    protected double absoluteScale = 1.0;
    protected FRspring frSpring;
    protected ActionListener runFR = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            BasicGraphPanel.this.energyBar.setProgress(BasicGraphPanel.this.frSpring.getCurrent());
            if (BasicGraphPanel.this.energyBar.isCanceled() || BasicGraphPanel.this.frSpring.isDone()) {
                BasicGraphPanel.this.timer.stop();
                BasicGraphPanel.this.frSpring.stop();
                BasicGraphPanel.this.energyBar.close();
                BasicGraphPanel.this.setCursor(null);
                BasicGraphPanel.this.repaint();
            }
        }
    };
    static final double INITIAL_TEMP = 1.0;
    double temperature = 1.0;
    boolean cool = true;
    boolean coolToggle = false;
    Node pick;
    boolean pickfixed;
    double oldX = 0.0;
    double oldY = 0.0;
    private Rectangle currentRect = null;
    Rectangle rectToDraw = null;
    Rectangle previousRectDrawn = new Rectangle();
    private boolean box;
    private Graph visibleGraph = null;

    public void setGraph(Graph g) {
        this.graph = g;
        this.updateNodes();
    }

    public void updateNodes() {
        this.calculateEdgeLength();
    }

    public Node getPick() {
        return this.pick;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setHideWhenMove(boolean trueOrFalse) {
        this.hideWhenMove = trueOrFalse;
    }

    public void setAlpha(boolean trueOrFalse) {
        this.alpha = trueOrFalse;
    }

    public void changeFont(int size) {
        this.nodeFont = new Font("TimesNewRoman", 0, size);
        this.fontSize = size;
    }

    public void setNodeSize(int nodeSize) {
        if (nodeSize < 1) {
            nodeSize = 10;
        }
        this.nodeSize = nodeSize;
        this.correct = (int)((double)nodeSize / 2.0);
    }

    public void setBackgroundColor(Color c) {
        this.setBackground(c);
    }

    public String colorToString(Color color) {
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    public void setPretty(boolean trueOrFalse) {
        this.pretty = trueOrFalse;
    }

    public void setArrows(boolean trueOrFalse) {
        this.arrow = trueOrFalse;
    }

    public void setLabel(boolean trueOrFalse) {
        this.label = trueOrFalse;
    }

    public void setConfidence(boolean trueOrFalse) {
        this.showConfidence = trueOrFalse;
    }

    public void setAnnotation(boolean trueOrFalse) {
        this.showAnnotation = trueOrFalse;
    }

    public void setBasicEdgeColor(Color color) {
        this.basicEdgeColor = color;
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public Color getColor(Integer i) {
        return this.getStringSettings().getColor(i);
    }

    public void setColor(Integer i, Color color) {
        this.getStringSettings().setColor(i, color);
    }

    public double getEdgeLen() {
        return this.edgeLen;
    }

    public void calculateEdgeLength() {
        int nnodes = this.graph.getNodeSize();
        if (nnodes > 0) {
            this.edgeLen = Math.sqrt(this.getPanelWidth() * this.getPanelHeight() / nnodes);
        }
    }

    public void setEdgeLen(double newEdgeLen) {
        if (newEdgeLen > 0.0) {
            this.edgeLen = newEdgeLen;
        } else {
            this.calculateEdgeLength();
        }
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setAbsoluteScale(double scale) {
        this.absoluteScale = scale;
    }

    public void setTimeFrameXY(int x, int y) {
        this.setTimeFrameXY(new Dimension(x, y));
    }

    public void setTimeFrameXY(Dimension d) {
        this.dims = d;
        this.setPanelWidth((int)((double)this.getPanelWidth() * this.scale));
        this.setPanelHeight((int)((double)this.getPanelHeight() * this.scale));
        this.panelWidth = (int)(d.getWidth() * this.scale);
        this.panelHeight = (int)(d.getHeight() * this.scale);
        this.rescaleNodes();
        this.calculateEdgeLength();
        this.dims = new Dimension(this.panelWidth, this.panelHeight);
        this.setPreferredSize(new Dimension(this.panelWidth, this.panelHeight));
        this.setSize(new Dimension(this.panelWidth, this.panelHeight));
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Node node = this.getClosest(e);
        if (node == null) {
            return null;
        }
        if (this.showAnnotation) {
            return node.getLabel();
        }
        return node.getAnnotation();
    }

    public void initEdges() {
        this.autoFixOrientation();
        this.calculateEdgeLength();
    }

    private void rescaleNodes() {
        this.graph.rescaleNodes(this.scale);
    }

    public void updateStringSettings(MedusaSettings ss) {
        this.setStringSettings(ss);
    }

    public BasicGraphPanel(MedusaSettings stringSettings) {
        this.graph = new Graph();
        this.setBackground(Color.white);
        this.setOpaque(true);
        this.edgeLen = 100.0;
        this.setPreferredSize(new Dimension(this.getPanelWidth(), this.getPanelHeight()));
        this.addMouseListener(this);
        this.setStringSettings(stringSettings);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(1000000);
        this.setToolTipText("");
    }

    public BasicGraphPanel() {
        this(new MedusaSettings());
    }

    @Override
    public void run() {
        Thread myThread = Thread.currentThread();
        this.temperature = 1.0;
        this.resetDelta();
        this.running = true;
        while (this.relaxThread == myThread) {
            this.relax2();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                this.running = false;
                break;
            }
        }
        this.running = false;
    }

    public void start() {
        if (this.relaxThread == null) {
            this.relaxThread = new Thread(this);
        }
        this.running = true;
        this.relaxThread.start();
    }

    public void stop() {
        if (this.relaxThread != null) {
            this.running = false;
            this.relaxThread = null;
        }
    }

    public synchronized void energy() {
        this.energyBar = new ProgressMonitor(this, "Fruchterman Rheingold Algorithm", "", 0, 200);
        this.frSpring = new FRspring(this.graph, this.getPanelWidth(), this.getPanelHeight());
        this.timer = new Timer(500, this.runFR);
        this.energyBar.setProgress(0);
        this.energyBar.setMillisToDecideToPopup(1000);
        this.frSpring.start();
        this.timer.start();
    }

    public void setFix(boolean trueOrFalse) {
        Iterator<Node> nodes = this.graph.nodesIterator();
        while (nodes.hasNext()) {
            Node n = nodes.next();
            n.setFixed(trueOrFalse);
        }
        this.repaint();
    }

    public void invertFix() {
        Iterator<Node> nodes = this.graph.nodesIterator();
        while (nodes.hasNext()) {
            Node n;
            n.setFixed(!(n = nodes.next()).isFixed());
        }
        this.repaint();
    }

    protected void edgeAttract() {
        Iterator<UniqueEdge> uniqueEdges = this.graph.uniqueEdgesIterator();
        while (uniqueEdges.hasNext()) {
            double vy;
            UniqueEdge e = uniqueEdges.next();
            Node n1 = this.graph.getNode(e.getFromName());
            Node n2 = this.graph.getNode(e.getToName());
            double vx = n2.getX() - n1.getX();
            double len = Math.sqrt(vx * vx + (vy = n2.getY() - n1.getY()) * vy);
            len = len == 0.0 ? 1.0E-4 : len;
            double f = (this.edgeLen - len) / (len * 3.0);
            double dx = f * vx;
            double dy = f * vy;
            n2.setDX(n2.getDX() + dx);
            n2.setDY(n2.getDY() + dy);
            n1.setDX(n1.getDX() + -dx);
            n1.setDY(n1.getDY() + -dy);
        }
    }

    protected void edgeAttract2() {
        Iterator<UniqueEdge> uniqueEdges = this.graph.uniqueEdgesIterator();
        while (uniqueEdges.hasNext()) {
            double vy;
            UniqueEdge e = uniqueEdges.next();
            Node n1 = this.graph.getNode(e.getFromName());
            Node n2 = this.graph.getNode(e.getToName());
            double vx = n2.getX() - n1.getX();
            double len = Math.sqrt(vx * vx + (vy = n2.getY() - n1.getY()) * vy);
            len = len == 0.0 ? 1.0E-5 : len;
            double dx = -len * vx;
            double dy = -len * vy;
            n2.setDX(n2.getDX() + dx);
            n2.setDY(n2.getDY() + dy);
            n1.setDX(n1.getDX() + -dx);
            n1.setDY(n1.getDY() + -dy);
        }
    }

    protected void nodesRepel2(double critXDistance, double critYDistance) {
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            double dx = 0.0;
            double dy = 0.0;
            Iterator<Node> it2 = this.graph.nodesIterator();
            while (it2.hasNext()) {
                double len;
                Node node2 = it2.next();
                if (node.equals(node2)) continue;
                double vx = node.getX() - node2.getX();
                double vy = node.getY() - node2.getY();
                if (vx > critXDistance) {
                    vx = node.getX() - node2.getX();
                }
                if (vx < -critXDistance) {
                    vx = node.getX() - node2.getX();
                }
                if (vy > critYDistance) {
                    vy = node.getY() - node2.getY();
                }
                if (vy < -critYDistance) {
                    vy = node.getY() - node2.getY();
                }
                if ((len = Math.sqrt(vx * vx + vy * vy)) == 0.0) {
                    dx += Math.random() / 100.0;
                    dy += Math.random() / 100.0;
                    continue;
                }
                if (!(len < 0.1)) continue;
                dx += vx / len;
                dy += vy / len;
            }
            node.setDX(node.getDX() + dx);
            node.setDY(node.getDY() + dy);
        }
    }

    protected void nodesRepel(double critXDistance, double critYDistance) {
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            double dx = 0.0;
            double dy = 0.0;
            Iterator<Node> it2 = this.graph.nodesIterator();
            while (it2.hasNext()) {
                double len;
                Node node2 = it2.next();
                if (node.equals(node2)) continue;
                double vx = node.getX() - node2.getX();
                double vy = node.getY() - node2.getY();
                if (vx > critXDistance) {
                    vx = node.getX() - node2.getX() - (double)this.getPanelWidth();
                }
                if (vx < -critXDistance) {
                    vx = node.getX() - node2.getX() + (double)this.getPanelWidth();
                }
                if (vy > critYDistance) {
                    vy = node.getY() - node2.getY() - (double)this.getPanelHeight();
                }
                if (vy < -critYDistance) {
                    vy = node.getY() - node2.getY() + (double)this.getPanelHeight();
                }
                if ((len = vx * vx + vy * vy) == 0.0) {
                    dx += Math.random();
                    dy += Math.random();
                    continue;
                }
                if (!(len < (double)(this.getPanelWidth() * this.getPanelHeight() / 9))) continue;
                dx += vx / len;
                dy += vy / len;
            }
            double dlen = dx * dx + dy * dy;
            if (!(dlen > 0.0)) continue;
            dlen = Math.sqrt(dlen) / 3.0;
            node.setDX(node.getDX() + dx / dlen);
            node.setDY(node.getDY() + dy / dlen);
        }
    }

    protected synchronized void relax2() {
        int border = 10;
        int labelPadding = 10;
        double critXDistance = this.getPanelWidth() * 3 / 4;
        double critYDistance = this.getPanelHeight() * 3 / 4;
        this.edgeAttract();
        this.nodesRepel(critXDistance, critYDistance);
        this.moveNodes(border, labelPadding);
        this.repaint();
        if (this.cool & this.coolToggle) {
            this.temperature -= 0.02;
            this.temperature = Math.max(this.temperature, 0.0);
        }
    }

    protected void moveNodes2(int border, int labelPadding) {
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            double limit = 0.001;
            if (Math.abs(node.getDX()) < limit) {
                node.setDX(0.0);
            }
            if (Math.abs(node.getDY()) < limit) {
                node.setDY(0.0);
            }
            if (this.cool & this.coolToggle) {
                node.setDX(node.getDX() * this.temperature);
                node.setDY(node.getDY() * this.temperature);
            }
            if (!node.isFixed()) {
                node.setX(node.getX() + node.getDX());
                node.setY(node.getY() + node.getDY());
            }
            node.setDX(node.getDX() / 2.0);
            node.setDY(node.getDY() / 2.0);
        }
    }

    protected void moveNodes(int border, int labelPadding) {
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            if (Math.abs(node.getDX()) < 1.0) {
                node.setDX(0.0);
            }
            if (Math.abs(node.getDY()) < 1.0) {
                node.setDY(0.0);
            }
            if (this.cool & this.coolToggle) {
                node.setDX(node.getDX() * this.temperature);
                node.setDY(node.getDY() * this.temperature);
            }
            if (!node.isFixed()) {
                node.setX(node.getX() + Math.max(-5.0, Math.min(5.0, node.getDX())));
                node.setY(node.getY() + Math.max(-5.0, Math.min(5.0, node.getDY())));
            }
            if (node.getX() < (double)border) {
                node.setX(border);
            } else if (node.getX() > (double)(this.getPanelWidth() - 2 * border)) {
                node.setX(this.getPanelWidth() - 2 * border);
            }
            if (node.getY() < (double)(border + labelPadding)) {
                node.setY(border + labelPadding);
            } else if (node.getY() > (double)(this.getPanelHeight() - border)) {
                node.setY(this.getPanelHeight() - border);
            }
            node.setDX(node.getDX() / 2.0);
            node.setDY(node.getDY() / 2.0);
        }
    }

    public void setCool(boolean trueOrFalse) {
        this.coolToggle = trueOrFalse;
    }

    private void resetDelta() {
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            node.setDY(0.0);
            node.setDX(0.0);
        }
    }

    protected synchronized void gravity() {
        double g = 9.81;
        double dt = 0.1;
        double temp = g * dt;
        double cooldown = 0.9;
        int yLimit = 600;
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            if (node.isFixed()) continue;
            node.setDY(node.getDY() + temp);
            node.setY(node.getY() + 0.5 * temp * dt + node.getDY() * dt);
            if (!(node.getY() > 600.0)) continue;
            node.setDY(-node.getDY() * cooldown);
            node.setY(600.0);
        }
        this.repaint();
    }

    public void rotate(double t) {
        double pw2 = this.getPanelWidth() / 2;
        double ph2 = this.getPanelHeight() / 2;
        double cos = Math.cos(t);
        double sin = Math.sin(t);
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            double x = node.getX() - pw2;
            double y = node.getY() - ph2;
            node.setX(x * cos - y * sin + pw2);
            node.setY(x * sin + y * cos + ph2);
        }
    }

    public void mirror(boolean xFlip, boolean yFlip) {
        Node node;
        Iterator<Node> it;
        if (xFlip) {
            it = this.graph.nodesIterator();
            while (it.hasNext()) {
                node = it.next();
                node.setX((double)this.getPanelWidth() - node.getX());
            }
        }
        if (yFlip) {
            it = this.graph.nodesIterator();
            while (it.hasNext()) {
                node = it.next();
                node.setY((double)this.getPanelWidth() - node.getY());
            }
        }
    }

    public void changeNodeColor(int red, int green, int blue) {
        Color color = new Color(red, green, blue);
        Iterator<Node> nodes = this.graph.nodesIterator();
        while (nodes.hasNext()) {
            Node n = nodes.next();
            if (!n.isFixed()) continue;
            n.setColor(this.getCurrentNodeColorSet(), color);
        }
    }

    public void changeNodeColor(Color color) {
        Iterator<Node> nodes = this.graph.nodesIterator();
        while (nodes.hasNext()) {
            Node n = nodes.next();
            if (!n.isFixed()) continue;
            n.setColor(this.getCurrentNodeColorSet(), color);
        }
    }

    public void saveImage(String path, int param) {
        BasicGraphPanel comp = this;
        Dimension d = this.getSize();
        int w = (int)d.getWidth();
        int h = (int)d.getHeight();
        BufferedImage im = new BufferedImage(w, h, 1);
        Graphics2D g2 = im.createGraphics();
        ((Component)comp).paint(g2);
        g2.dispose();
        try {
            File file = new File(path);
            if (param == 0) {
                ImageIO.write((RenderedImage)im, "jpg", file);
            }
            if (param == 1) {
                ImageIO.write((RenderedImage)im, "png", file);
            }
            im.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setNodeFixed(String lbl, boolean fixed) {
        this.graph.getNode(lbl).setFixed(fixed);
    }

    protected Node getClosest(MouseEvent e) {
        int radialDistance = 50;
        int index = -1;
        Node bestNode = null;
        double bestdist = Double.MAX_VALUE;
        int x = e.getX();
        int y = e.getY();
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            double dist = (node.getX() - (double)x) * (node.getX() - (double)x) + (node.getY() - (double)y) * (node.getY() - (double)y);
            if (!(dist < (double)radialDistance & dist < bestdist)) continue;
            bestdist = dist;
            bestNode = node;
        }
        return bestNode;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.handlePressLeftButton(e);
        }
    }

    public void handlePressLeftButton(MouseEvent e) {
        if (this.pick != null) {
            return;
        }
        Node node = this.getClosest(e);
        if (e.isControlDown()) {
            if (node != null) {
                node.setFixed(!node.isFixed());
            }
            this.pick = null;
            e.consume();
            return;
        }
        if (e.isShiftDown()) {
            this.addMouseMotionListener(this);
            if (node != null) {
                this.setPick(node, e);
            }
            e.consume();
            return;
        }
        if (e.getModifiers() == 16) {
            this.addMouseMotionListener(this);
            if (node != null) {
                this.setPick(node, e);
            } else {
                int x = e.getX();
                int y = e.getY();
                this.currentRect = new Rectangle(x, y, 0, 0);
                this.updateDrawableRect(this.getWidth(), this.getHeight());
                this.repaint();
            }
            e.consume();
            return;
        }
    }

    private void setPick(Node node, MouseEvent e) {
        this.pick = node;
        if (this.hideWhenMove) {
            this.visibleGraph = this.graph.subGraph(node);
        }
        this.pickfixed = this.pick.isFixed();
        this.pick.setFixed(true);
        this.pick.setX(e.getX());
        this.pick.setY(e.getY());
        this.oldX = this.pick.getX();
        this.oldY = this.pick.getY();
        this.temperature = 1.0;
        this.cool = false;
    }

    public void handlePressLeftButton_backup(MouseEvent e) {
        if (this.pick == null && e.getButton() == 1 && e.getModifiers() == 16 | e.getModifiers() == 17 | e.getModifiers() == 18) {
            this.addMouseMotionListener(this);
            Node node = this.getClosest(e);
            if (node != null) {
                if (e.getModifiers() == 18) {
                    node.setFixed(!node.isFixed());
                    this.pick = null;
                } else {
                    this.pick = node;
                    this.pickfixed = this.pick.isFixed();
                    this.pick.setFixed(true);
                    this.pick.setX(e.getX());
                    this.pick.setY(e.getY());
                    this.oldX = this.pick.getX();
                    this.oldY = this.pick.getY();
                    this.temperature = 1.0;
                    this.cool = false;
                }
                this.repaint();
            } else {
                int x = e.getX();
                int y = e.getY();
                this.currentRect = new Rectangle(x, y, 0, 0);
                this.updateDrawableRect(this.getWidth(), this.getHeight());
                this.repaint();
            }
            e.consume();
        }
    }

    public boolean findLabel(String expression) {
        Pattern labelPattern = Pattern.compile(expression);
        if (expression.compareTo("") == 0) {
            return false;
        }
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            Matcher matcher = labelPattern.matcher(node.getLabel());
            node.setFixed(false);
            if (!matcher.find()) continue;
            node.setFixed(true);
        }
        return true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handleReleaseLeftButton(e);
    }

    protected void handleReleaseLeftButton(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        this.removeMouseMotionListener(this);
        if (e.getModifiers() == 16) {
            if (this.pick != null) {
                this.pick.setX(e.getX());
                this.pick.setY(e.getY());
                this.pick.setFixed(this.pickfixed);
                this.cool = true;
            } else {
                this.updateSize(e);
                this.fixNodesInRect(this.rectToDraw);
                this.currentRect = null;
            }
        }
        if (e.isShiftDown() && this.pick != null) {
            double xMove = (double)e.getX() - this.oldX;
            double yMove = (double)e.getY() - this.oldY;
            this.moveFixed(xMove, yMove);
            this.pick.setFixed(this.pickfixed);
        }
        if (e.isControlDown()) {
            if (this.pick == null & this.getCurrentRect() != null) {
                this.updateSize(e);
                this.unFixNodesInRect(this.rectToDraw);
                this.currentRect = null;
            } else if (this.pick != null) {
                this.pick.setX(e.getX());
                this.pick.setY(e.getY());
                this.pick.setFixed(!this.pick.isFixed());
            }
        }
        this.pick = null;
        this.repaint();
        e.consume();
    }

    protected void fixNodesInRect(Rectangle rect) {
        if (rect == null) {
            return;
        }
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            if (!rect.contains(node.getX(), node.getY())) continue;
            node.setFixed(true);
        }
    }

    protected void unFixNodesInRect(Rectangle rect) {
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            if (!rect.contains(node.getX(), node.getY())) continue;
            node.setFixed(false);
        }
    }

    private void updateSize(MouseEvent e) {
        if (this.getCurrentRect() == null) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        this.getCurrentRect().setSize(x - this.getCurrentRect().x, y - this.getCurrentRect().y);
        this.updateDrawableRect(this.getPanelWidth(), this.getPanelHeight());
        Rectangle totalRepaint = this.rectToDraw.union(this.previousRectDrawn);
        this.repaint(totalRepaint.x, totalRepaint.y, totalRepaint.width, totalRepaint.height);
    }

    private void updateDrawableRect(int compWidth, int compHeight) {
        int x = this.getCurrentRect().x;
        int y = this.getCurrentRect().y;
        int width = this.getCurrentRect().width;
        int height = this.getCurrentRect().height;
        if (width < 0 && (x = x - (width = 0 - width) + 1) < 0) {
            width += x;
            x = 0;
        }
        if (height < 0 && (y = y - (height = 0 - height) + 1) < 0) {
            height += y;
            y = 0;
        }
        if (this.rectToDraw != null) {
            this.previousRectDrawn.setBounds(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width, this.rectToDraw.height);
            this.rectToDraw.setBounds(x, y, width, height);
        } else {
            this.rectToDraw = new Rectangle(x, y, width, height);
        }
    }

    protected void moveFixed(double xMove, double yMove) {
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            if (!(node.isFixed() & node != this.pick)) continue;
            node.setX(node.getX() + xMove);
            node.setY(node.getY() + yMove);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.handleLeftMouseDragged(e);
    }

    public void handleLeftMouseDragged(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0) {
            if (this.pick != null & e.getModifiers() != 18) {
                this.pick.setX(e.getX());
                this.pick.setY(e.getY());
                this.repaint();
            } else if (this.pick == null) {
                this.updateSize(e);
            }
        }
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void autoFixOrientation() {
        this.graph.autoFixOrientation();
    }

    public void randomGraph(int nNodes, int nEdges) {
        DemoTools dt = new DemoTools();
        this.graph = dt.randomGraph(nNodes, nEdges);
        this.graph.rescaleNodes(600);
        this.updateNodes();
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        Graphics2D g2d = this.prePaint(g);
        if (this.graph == null) {
            this.paintNull(g);
        } else {
            this.paintNet(g2d);
            if (this.getCurrentRect() != null) {
                float[] dashPattern = new float[]{2.0f, 3.0f, 2.0f, 3.0f};
                g2d.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f));
                g2d.drawRect(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width - 1, this.rectToDraw.height - 1);
            }
            g2d.setStroke(new BasicStroke(1.0f));
        }
    }

    protected void paintNull(Graphics g) {
        g.drawString("No graph is loaded", 20, 20);
        g.drawString("Load or create a graph", 30, 40);
        g.drawString("Pavlopoulos, Hooper 2008", 40, 60);
    }

    public void paintPick(Graphics2D g) {
        Node n = this.pick;
        g.setPaint(n.getColor());
        int x = (int)n.getX() - this.correct;
        int y = (int)n.getY() - this.correct;
        Shape shape = PaintTools.getShape(n.getShape(), x, y, this.nodeSize);
        g.fill(shape);
        g.setPaint(Color.black);
        if (n.isFixed()) {
            g.setPaint(Color.yellow);
        }
        g.draw(shape);
    }

    public Rectangle getCurrentRect() {
        return this.currentRect;
    }

    public boolean isBox() {
        return this.box;
    }

    public Graph getVisibleGraph() {
        return this.visibleGraph;
    }
}

