/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit.util;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.webswing.toolkit.util.Logger;

public class CpuMonitor {
    static long previousCPUTime = 0L;
    static long previousTime = 0L;
    static Method getProcessCpuTimeMethod;

    public static double getCpuUtilization() {
        if (getProcessCpuTimeMethod == null) {
            return -1.0;
        }
        try {
            OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
            long currentCpuTime = (Long)getProcessCpuTimeMethod.invoke((Object)osMXBean, new Object[0]);
            long now = ManagementFactory.getRuntimeMXBean().getUptime();
            long cpuTimeDelta = currentCpuTime - previousCPUTime;
            previousCPUTime = currentCpuTime;
            long timeDelta = now - previousTime;
            previousTime = now;
            int processors = Runtime.getRuntime().availableProcessors();
            if (timeDelta == 0L || processors == 0) {
                return 0.0;
            }
            double cpuUsage = (double)TimeUnit.NANOSECONDS.toMillis(cpuTimeDelta) / (double)timeDelta;
            return Math.max(0.0, cpuUsage /= (double)processors) * 100.0;
        }
        catch (Throwable e) {
            getProcessCpuTimeMethod = null;
            Logger.warn("Failed to load CPU utilization. Monitoring CPU disabled.", e);
            return -1.0;
        }
    }

    static {
        try {
            Class<?> osMXBeanClass = Class.forName("com.sun.management.OperatingSystemMXBean");
            getProcessCpuTimeMethod = osMXBeanClass.getMethod("getProcessCpuTime", new Class[0]);
        }
        catch (ReflectiveOperationException sun) {
            try {
                Class<?> osMXBeanClass = Class.forName("com.ibm.lang.management.OperatingSystemMXBean");
                getProcessCpuTimeMethod = osMXBeanClass.getMethod("getProcessCpuTime", new Class[0]);
            }
            catch (ReflectiveOperationException ibm) {
                getProcessCpuTimeMethod = null;
                Logger.warn("Class not found to monitor CPU utilization. Monitoring CPU disabled.", sun);
            }
        }
    }
}

