/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit.extra;

import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.webswing.toolkit.extra.IsolatedRootFile;
import org.webswing.toolkit.util.Logger;
import sun.awt.shell.PublicShellFolderManager;
import sun.awt.shell.ShellFolder;

public class IsolatedFsShellFolderManager
extends PublicShellFolderManager {
    private static File root;
    private static List<File> roots;
    private static String platformImagesFolder;

    public Object get(String key) {
        if (key.equals("fileChooserDefaultFolder")) {
            return this.ensureExists(root);
        }
        if (key.equals("roots")) {
            return this.ensureExists(roots.toArray(new File[roots.size()]));
        }
        if (key.equals("fileChooserComboBoxFolders")) {
            return this.ensureExists(roots.toArray(new File[roots.size()]));
        }
        if (key.equals("fileChooserShortcutPanelFolders")) {
            return this.ensureExists(roots.toArray(new File[roots.size()]));
        }
        if (key.startsWith("fileChooserIcon ")) {
            String fcIconType;
            if (key.equals("fileChooserIcon ListView") || key.equals("fileChooserIcon ViewMenu")) {
                fcIconType = platformImagesFolder + "/ListView.gif";
            } else if (key.equals("fileChooserIcon DetailsView")) {
                fcIconType = platformImagesFolder + "/DetailsView.gif";
            } else if (key.equals("fileChooserIcon UpFolder")) {
                fcIconType = platformImagesFolder + "/UpFolder.gif";
            } else if (key.equals("fileChooserIcon NewFolder")) {
                fcIconType = platformImagesFolder + "/NewFolder.gif";
            } else {
                return null;
            }
            return this.getImage(fcIconType, key);
        }
        if (key.startsWith("optionPaneIcon ")) {
            String iconType;
            if (key == "optionPaneIcon Error") {
                iconType = platformImagesFolder + "/Error.gif";
            } else if (key == "optionPaneIcon Information") {
                iconType = platformImagesFolder + "/Inform.gif";
            } else if (key == "optionPaneIcon Question") {
                iconType = platformImagesFolder + "/Question.gif";
            } else if (key == "optionPaneIcon Warning") {
                iconType = platformImagesFolder + "/Warn.gif";
            } else {
                return null;
            }
            return this.getImage(iconType, key);
        }
        if (key.startsWith("shell32Icon ") || key.startsWith("shell32LargeIcon ")) {
            String name = key.substring(key.indexOf(" ") + 1);
            boolean large = key.startsWith("shell32LargeIcon ");
            String filename = platformImagesFolder + "/" + name + (large ? "_large" : "") + ".png";
            return this.getImage(filename, key);
        }
        return null;
    }

    private File[] ensureExists(File[] roots) {
        for (File f : roots) {
            this.ensureExists(f);
        }
        return roots;
    }

    private File ensureExists(File f) {
        if (!f.getAbsoluteFile().exists()) {
            boolean done = f.mkdirs();
            if (done) {
                Logger.error("Isolated filesystem folder " + f.getAbsolutePath() + "not found. Make sure the folder is unique for each session (use ${user} variable) or disable the 'Clear Upload Folder' option in configuration.", new Object[0]);
            } else {
                Logger.error("Isolated filesystem folder " + f.getAbsolutePath() + " could not be created. Make sure the path is valid and the process has write access.", new Object[0]);
            }
        }
        return f;
    }

    public ShellFolder createShellFolder(File paramFile) throws FileNotFoundException {
        try {
            if (IsolatedFsShellFolderManager.isSubfolderOfRoots(paramFile)) {
                return super.createShellFolder(paramFile);
            }
            throw new FileNotFoundException("Path is outside the allowed Webswing Filesystem isolation folder. (" + paramFile.getCanonicalPath() + ")");
        }
        catch (IOException e) {
            System.err.println("Error while creating ShellFolder. " + e.getMessage());
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            throw new FileNotFoundException("Error while creating ShellFolder. " + e.getMessage());
        }
    }

    public static boolean isSubfolderOfRoots(File paramFile) throws IOException {
        if (Boolean.getBoolean("webswing.isolatedFs")) {
            String cp = paramFile.getCanonicalPath();
            for (File root : roots) {
                if (!cp.startsWith(root.getCanonicalPath())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFileSystemRoot(File paramFile) {
        try {
            for (File root : roots) {
                if (!root.getCanonicalPath().equals(paramFile.getCanonicalPath())) continue;
                return true;
            }
            return false;
        }
        catch (IOException e1) {
            return super.isFileSystemRoot(paramFile);
        }
    }

    /*
     * Exception decompiling
     */
    private Image getImage(String imageFile, String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        roots = new ArrayList<File>();
        platformImagesFolder = System.getProperty("webswing.platformIcons", "webswingplatformicons");
        String path = System.getProperty("webswing.transfer.dir", System.getProperty("user.dir") + "/upload");
        String[] paths = path.split(File.pathSeparator);
        for (int i = 0; i < paths.length; ++i) {
            IsolatedRootFile root = new IsolatedRootFile(paths[i]);
            if (!root.getAbsoluteFile().exists()) {
                root.mkdirs();
            }
            roots.add(root);
            if (i != 0) continue;
            IsolatedFsShellFolderManager.root = root;
            if (!Boolean.getBoolean("webswing.useSharedUserHome")) continue;
            System.setProperty("user.home", root.getAbsolutePath());
        }
    }
}

