/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.audio;

import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;
import org.webswing.audio.AudioMixer;

public class AudioMixerProvider
extends MixerProvider {
    private static AudioMixer globalmixer;
    private static Mixer.Info globalmixerInfo;
    static Thread lockthread;
    static final Object mutex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mixer getMixer(Mixer.Info info) {
        this.initGlobalMixer();
        if (info != null && info != globalmixerInfo) {
            throw new IllegalArgumentException("Mixer " + info.toString() + " not supported by this provider.");
        }
        Object object = mutex;
        synchronized (object) {
            if (lockthread != null && Thread.currentThread() == lockthread) {
                throw new IllegalArgumentException("Mixer " + info.toString() + " not supported by this provider.");
            }
            return globalmixer;
        }
    }

    @Override
    public Mixer.Info[] getMixerInfo() {
        this.initGlobalMixer();
        return new Mixer.Info[]{globalmixerInfo};
    }

    private void initGlobalMixer() {
        if (globalmixer == null) {
            globalmixer = new AudioMixer();
            globalmixerInfo = globalmixer.getMixerInfo();
        }
    }

    static {
        mutex = new Object();
    }
}

