/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemInfo {
    public static final int LogicalCores;
    public static final String OS_String;
    public static final int L2CacheSize;

    public static boolean isWindows() {
        return OS_String.contains("Win");
    }

    public static boolean isMac() {
        return OS_String.contains("Mac");
    }

    public static boolean isLinux() {
        return OS_String.contains("Lin");
    }

    static {
        int sizeToUse;
        block21: {
            LogicalCores = Runtime.getRuntime().availableProcessors();
            OS_String = System.getProperty("os.name");
            sizeToUse = 0;
            try {
                if (SystemInfo.isWindows()) {
                    String output = null;
                    try {
                        Process pr = Runtime.getRuntime().exec("wmic cpu get L2CacheSize, NumberOfCores");
                        BufferedReader br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                        StringBuilder sb = new StringBuilder();
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            sb.append(line).append("\n");
                        }
                        output = sb.toString();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SystemInfo.class.getName()).log(Level.WARNING, null, ex);
                    }
                    output = output.replaceAll("L2CacheSize\\s+NumberOfCores", "").trim();
                    if (output.indexOf("\n") > 0) {
                        output = output.substring(0, output.indexOf("\n")).trim();
                    }
                    String[] vals = output.split("\\s+");
                    sizeToUse = Integer.valueOf(vals[0]) / Integer.valueOf(vals[1]) * 1024;
                    break block21;
                }
                if (SystemInfo.isLinux()) {
                    String output;
                    block22: {
                        output = null;
                        try {
                            Process pr = Runtime.getRuntime().exec("cat /proc/cpuinfo");
                            BufferedReader br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                            String line = null;
                            while ((line = br.readLine()) != null) {
                                if (!line.startsWith("cache size") || output != null) continue;
                                output = line;
                            }
                        }
                        catch (IOException ex) {
                            String appEngineVersion = System.getProperty("com.google.appengine.runtime.version");
                            if (appEngineVersion != null) break block22;
                            Logger.getLogger(SystemInfo.class.getName()).log(Level.WARNING, null, ex);
                        }
                    }
                    output = output.substring(output.indexOf(":") + 1);
                    String[] vals = output.trim().split(" ");
                    int size = Integer.parseInt(vals[0]);
                    if (vals[1].equals("KB")) {
                        size *= 1024;
                    } else if (vals[1].equals("MB")) {
                        size *= 0x100000;
                    }
                    sizeToUse = size;
                    break block21;
                }
                if (SystemInfo.isMac()) {
                    String output = null;
                    try {
                        Process pr = Runtime.getRuntime().exec("sysctl -a hw");
                        BufferedReader br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            if (!line.contains("l1icachesize") || output != null) continue;
                            output = line;
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SystemInfo.class.getName()).log(Level.WARNING, null, ex);
                    }
                    String[] vals = output.split("\\s+");
                    sizeToUse = Integer.parseInt(vals[1]);
                    break block21;
                }
                sizeToUse = 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (sizeToUse == 0) {
            sizeToUse = 262144;
        } else if (sizeToUse < 131072) {
            sizeToUse = 131072;
        }
        L2CacheSize = sizeToUse;
    }
}

