/*
 * Decompiled with CFR 0.152.
 */
package jsat.testing.onesample;

import jsat.distributions.Normal;
import jsat.linear.Vec;
import jsat.testing.StatisticTest;
import jsat.testing.onesample.OneSampleTest;
import jsat.text.GreekLetters;

public class ZTest
implements OneSampleTest {
    private Normal norm;
    private double sampleMean;
    private double sampleDev;
    private int sampleSize;
    private StatisticTest.H1 h1;
    private double hypoMean;

    public ZTest() {
        this(0.0, 1.0, 1);
    }

    public ZTest(double sampleMean, double sampleDev, int sampleSize) {
        this(StatisticTest.H1.NOT_EQUAL, sampleMean, sampleDev, sampleSize);
    }

    public ZTest(StatisticTest.H1 h1, double sampleMean, double sampleDev, int sampleSize) {
        this.h1 = h1;
        this.hypoMean = 0.0;
        this.sampleMean = sampleMean;
        this.sampleDev = sampleDev;
        this.sampleSize = sampleSize;
        this.norm = new Normal();
    }

    public ZTest(Vec data) {
        this(data.mean(), data.standardDeviation(), data.length());
    }

    public ZTest(StatisticTest.H1 h1, Vec data) {
        this(h1, data.mean(), data.standardDeviation(), data.length());
    }

    @Override
    public StatisticTest.H1[] validAlternate() {
        return new StatisticTest.H1[]{StatisticTest.H1.LESS_THAN, StatisticTest.H1.NOT_EQUAL, StatisticTest.H1.GREATER_THAN};
    }

    @Override
    public String testName() {
        return "One Sample Z-Test";
    }

    @Override
    public void setTestUsingData(Vec data) {
        this.sampleMean = data.mean();
        this.sampleDev = data.standardDeviation();
        this.sampleSize = data.length();
    }

    @Override
    public String[] getTestVars() {
        return new String[]{GreekLetters.bar("x"), "\u03c3", "n"};
    }

    @Override
    public void setTestVars(double[] testVars) {
        this.sampleMean = testVars[0];
        this.sampleDev = testVars[1];
        this.sampleSize = (int)testVars[2];
    }

    @Override
    public String getAltVar() {
        return "\u03bc0";
    }

    @Override
    public void setAltVar(double altVar) {
        this.hypoMean = altVar;
    }

    @Override
    public double pValue() {
        double se = this.sampleDev / Math.sqrt(this.sampleSize);
        double zScore = (this.sampleMean - this.hypoMean) / se;
        if (this.h1 == StatisticTest.H1.NOT_EQUAL) {
            return this.norm.cdf(-Math.abs(zScore)) * 2.0;
        }
        if (this.h1 == StatisticTest.H1.LESS_THAN) {
            return this.norm.cdf(zScore);
        }
        return 1.0 - this.norm.cdf(zScore);
    }

    @Override
    public void setAltHypothesis(StatisticTest.H1 h1) {
        this.h1 = h1;
    }

    @Override
    public String getNullVar() {
        return "\u03bc";
    }
}

