/*
 * Decompiled with CFR 0.152.
 */
package jsat.math.integration;

import jsat.math.Function1D;
import jsat.math.integration.Trapezoidal;

public class Romberg {
    public static double romb(Function1D f, double a, double b) {
        return Romberg.romb(f, a, b, 20);
    }

    public static double romb(Function1D f, double a, double b, int max) {
        double[] s = new double[++max];
        double var = 0.0;
        double lastVal = Double.NEGATIVE_INFINITY;
        for (int k = 1; k < max; ++k) {
            for (int i = 1; i <= k; ++i) {
                if (i == 1) {
                    var = s[i];
                    s[i] = Trapezoidal.trapz(f, a, b, (int)Math.pow(2.0, k - 1));
                    continue;
                }
                s[k] = (Math.pow(4.0, i - 1) * s[i - 1] - var) / (Math.pow(4.0, i - 1) - 1.0);
                var = s[i];
                s[i] = s[k];
            }
            if (Math.abs(lastVal - s[k]) < 1.0E-15) {
                return s[k];
            }
            lastVal = s[k];
        }
        return s[max - 1];
    }
}

