/*
 * Decompiled with CFR 0.152.
 */
package jsat.math;

import java.io.Serializable;

public class ExponentialMovingStatistics
implements Serializable,
Cloneable {
    private double mean;
    private double variance;
    private double smoothing;

    public ExponentialMovingStatistics() {
        this(0.1);
    }

    public ExponentialMovingStatistics(double smoothing) {
        this(smoothing, Double.NaN, 0.0);
    }

    public ExponentialMovingStatistics(double smoothing, double mean, double variance) {
        this.mean = mean;
        this.variance = variance;
        this.setSmoothing(smoothing);
    }

    public void setSmoothing(double smoothing) {
        if (smoothing <= 0.0 || smoothing > 1.0 || Double.isNaN(smoothing)) {
            throw new IllegalArgumentException("Smoothing must be in (0, 1], not " + smoothing);
        }
        this.smoothing = smoothing;
    }

    public double getSmoothing() {
        return this.smoothing;
    }

    public void add(double x) {
        if (Double.isNaN(this.mean)) {
            this.mean = x;
            this.variance = 0.0;
        } else {
            this.variance = (1.0 - this.smoothing) * (this.variance + this.smoothing * Math.pow(x - this.mean, 2.0));
            this.mean = (1.0 - this.smoothing) * this.mean + this.smoothing * x;
        }
    }

    public double getMean() {
        return this.mean;
    }

    public double getVariance() {
        return this.variance;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance() + 1.0E-13);
    }
}

