/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.DenseVector;
import jsat.linear.Vec;
import jsat.math.SimpleLinearRegression;
import jsat.math.SpecialMath;

public class Weibull
extends ContinuousDistribution {
    private static final long serialVersionUID = -4083186674624535562L;
    double alpha;
    double beta;
    private double logAlpha;
    private double logBeta;

    public Weibull(double alpha, double beta) {
        this.setAlpha(alpha);
        this.setBeta(beta);
    }

    public double reliability(double x) {
        return Math.exp(-Math.pow(x / this.alpha, this.beta));
    }

    public double failureRate(double x) {
        return this.beta / this.alpha * Math.pow(x / this.alpha, this.beta - 1.0);
    }

    @Override
    public double logPdf(double x) {
        if (x <= 0.0) {
            return -1.7976931348623157E308;
        }
        return this.logAlpha - this.logBeta + (this.alpha - 1.0) * Math.log(x / this.beta) - Math.pow(x / this.beta, this.alpha);
    }

    @Override
    public double pdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return this.alpha / this.beta * Math.pow(x / this.beta, this.alpha - 1.0) * Math.exp(-Math.pow(x / this.beta, this.alpha));
    }

    @Override
    public double cdf(double x) {
        return 1.0 - Math.exp(-Math.pow(x / this.beta, this.alpha));
    }

    @Override
    public double invCdf(double p) {
        return this.beta * Math.pow(-Math.log(1.0 - p), 1.0 / this.alpha);
    }

    @Override
    public double min() {
        return 0.0;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String getDistributionName() {
        return "Weibull";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"\u03b1", "\u03b2"};
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.alpha, this.beta};
    }

    @Override
    public void setVariable(String var, double value) {
        if (var.equals("alpha") || var.equals("\u03b1")) {
            this.setAlpha(value);
        } else if (var.equals("beta") || var.equals("\u03b2")) {
            this.setBeta(value);
        }
    }

    public final void setAlpha(double alpha) {
        if (!(alpha > 0.0)) {
            throw new ArithmeticException("alpha must be > 0 not " + alpha);
        }
        this.alpha = alpha;
        this.logAlpha = Math.log(alpha);
    }

    public final void setBeta(double beta) {
        if (!(beta > 0.0)) {
            throw new ArithmeticException("beta must be > 0 not " + beta);
        }
        this.beta = beta;
        this.logBeta = Math.log(beta);
    }

    @Override
    public ContinuousDistribution clone() {
        return new Weibull(this.alpha, this.beta);
    }

    @Override
    public void setUsingData(Vec data) {
        Vec sData = data.sortedCopy();
        DenseVector ranks = new DenseVector(sData.length());
        for (int i = 0; i < sData.length(); ++i) {
            double tmp = ((double)i + 1.0 - 0.3) / ((double)sData.length() + 0.4);
            tmp = 1.0 / (1.0 - tmp);
            tmp = Math.log(Math.log(tmp));
            ranks.set(i, tmp);
            sData.set(i, Math.log(sData.get(i)));
        }
        double[] s = SimpleLinearRegression.regres(sData, ranks);
        this.setAlpha(s[1]);
        this.setBeta(Math.exp(-s[0] / this.alpha));
    }

    @Override
    public double mean() {
        return this.beta * SpecialMath.gamma(1.0 + 1.0 / this.alpha);
    }

    @Override
    public double median() {
        return Math.pow(Math.log(2.0), 1.0 / this.alpha) * this.beta;
    }

    @Override
    public double mode() {
        if (this.alpha <= 1.0) {
            throw new ArithmeticException("Mode only exists for k > 1");
        }
        return this.beta * Math.pow((this.alpha - 1.0) / this.alpha, 1.0 / this.alpha);
    }

    @Override
    public double variance() {
        return this.beta * this.beta * SpecialMath.gamma(1.0 + 2.0 / this.alpha) - Math.pow(this.median(), 2.0);
    }

    @Override
    public double skewness() {
        double mu = this.mean();
        double stnDev = this.standardDeviation();
        return (SpecialMath.gamma(1.0 + 3.0 / this.alpha) * Math.pow(this.beta, 3.0) - 3.0 * mu * Math.pow(stnDev, 2.0) - Math.pow(mu, 3.0)) / Math.pow(stnDev, 3.0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.alpha);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.beta);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Weibull other = (Weibull)obj;
        if (Double.doubleToLongBits(this.alpha) != Double.doubleToLongBits(other.alpha)) {
            return false;
        }
        return Double.doubleToLongBits(this.beta) == Double.doubleToLongBits(other.beta);
    }
}

