/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.evaluation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.evaluation.ClassificationScore;

public class AUC
implements ClassificationScore {
    private static final long serialVersionUID = 6882234590870560718L;
    private List<Tuple> scores;

    public AUC() {
    }

    public AUC(AUC toClone) {
        if (toClone.scores != null) {
            this.scores = new ArrayList<Tuple>(toClone.scores);
            for (int i = 0; i < this.scores.size(); ++i) {
                this.scores.set(i, new Tuple(this.scores.get((int)i).score, this.scores.get((int)i).positiveClass, this.scores.get((int)i).weight));
            }
        }
    }

    @Override
    public void addResult(CategoricalResults prediction, int trueLabel, double weight) {
        this.scores.add(new Tuple(prediction.getProb(0), trueLabel == 0, weight));
    }

    @Override
    public void addResults(ClassificationScore other) {
        AUC otherObj = (AUC)other;
        this.scores.addAll(otherObj.scores);
    }

    @Override
    public void prepare(CategoricalData toPredict) {
        if (toPredict.getNumOfCategories() != 2) {
            throw new IllegalArgumentException("AUC is only defined for binary classification problems");
        }
        this.scores = new ArrayList<Tuple>();
    }

    @Override
    public double getScore() {
        Collections.sort(this.scores);
        double pos = 0.0;
        double neg = 0.0;
        double sum = 0.0;
        for (Tuple i : this.scores) {
            if (i.positiveClass) {
                pos += i.weight;
                continue;
            }
            neg += i.weight;
        }
        double posLeft = pos;
        for (Tuple i : this.scores) {
            if (i.positiveClass) {
                posLeft -= i.weight;
                continue;
            }
            sum += posLeft;
        }
        return sum / (pos * neg);
    }

    @Override
    public boolean lowerIsBetter() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        return this.getClass().isAssignableFrom(obj.getClass()) && obj.getClass().isAssignableFrom(this.getClass());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public AUC clone() {
        return new AUC(this);
    }

    @Override
    public String getName() {
        return "AUC";
    }

    private static class Tuple
    implements Comparable<Tuple> {
        public double score;
        public boolean positiveClass;
        public double weight;

        public Tuple(double score, boolean positiveClass, double weight) {
            this.score = score;
            this.positiveClass = positiveClass;
            this.weight = weight;
        }

        @Override
        public int compareTo(Tuple o) {
            return Double.compare(this.score, o.score);
        }
    }
}

